/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.profinet.impl.installation;

import com.ur.polyscope.installation.InstallationChangedEvent;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.aspect.InstallationChangeEventAspect;
import com.ur.polyscope.profinet.impl.generated.RTInputData;
import com.ur.polyscope.profinet.impl.generated.WatchdogAction;
import com.ur.polyscope.profinet.impl.installation.ProfinetServiceExt;
import com.ur.polyscope.profinet.impl.installation.ProfinetSettings$AjcClosure1;
import com.ur.polyscope.profinet.impl.installation.ProfinetSettings$AjcClosure3;
import com.ur.polyscope.profinet.impl.installation.ProfinetSettings$AjcClosure5;
import com.ur.polyscope.profinet.impl.installation.ProfinetSettings$AjcClosure7;
import com.ur.polyscope.scriptwriter.PreambleScript;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import java.util.Locale;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ProfinetSettings
implements InstallationComponent,
PreambleScript {
    private static final float WATCHDOG_MINIMAL_FREQUENCY = 10.0f;
    private final ProfinetServiceExt profinetServiceExt;
    private boolean enabled = false;
    private WatchdogAction plcIO = WatchdogAction.IGNORE;
    private WatchdogAction plcREG1 = WatchdogAction.IGNORE;
    private WatchdogAction plcREG2 = WatchdogAction.IGNORE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    @Inject
    public ProfinetSettings(ProfinetServiceExt profinetServiceExt) {
        this.profinetServiceExt = profinetServiceExt;
    }

    public Class<?> getType() {
        return ProfinetSettings.class;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void loadEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.profinetServiceExt.startProfinetDaemon();
        } else {
            this.profinetServiceExt.stopProfinetDaemon();
        }
    }

    public void loadPlcIO(WatchdogAction plcIO) {
        this.plcIO = plcIO;
    }

    public void loadPlcREG1(WatchdogAction plcREG1) {
        this.plcREG1 = plcREG1;
    }

    public void loadPlcREG2(WatchdogAction plcREG2) {
        this.plcREG2 = plcREG2;
    }

    @InstallationChangedEvent
    public void setEnabled(boolean enabled) {
        boolean bl = enabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
        ProfinetSettings$AjcClosure1 profinetSettings$AjcClosure1 = new ProfinetSettings$AjcClosure1(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(profinetSettings$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @InstallationChangedEvent
    public void setPlcIO(WatchdogAction action) {
        WatchdogAction watchdogAction = action;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)((Object)watchdogAction));
        Object[] objectArray = new Object[]{this, watchdogAction, joinPoint};
        ProfinetSettings$AjcClosure3 profinetSettings$AjcClosure3 = new ProfinetSettings$AjcClosure3(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(profinetSettings$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @InstallationChangedEvent
    public void setPlcREG1(WatchdogAction action) {
        WatchdogAction watchdogAction = action;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)((Object)watchdogAction));
        Object[] objectArray = new Object[]{this, watchdogAction, joinPoint};
        ProfinetSettings$AjcClosure5 profinetSettings$AjcClosure5 = new ProfinetSettings$AjcClosure5(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(profinetSettings$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @InstallationChangedEvent
    public void setPlcREG2(WatchdogAction action) {
        WatchdogAction watchdogAction = action;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)((Object)watchdogAction));
        Object[] objectArray = new Object[]{this, watchdogAction, joinPoint};
        ProfinetSettings$AjcClosure7 profinetSettings$AjcClosure7 = new ProfinetSettings$AjcClosure7(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(profinetSettings$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    public WatchdogAction getPlcIO() {
        return this.plcIO;
    }

    public WatchdogAction getPlcREG1() {
        return this.plcREG1;
    }

    public WatchdogAction getPlcREG2() {
        return this.plcREG2;
    }

    public boolean canGenerateScriptCode() {
        return true;
    }

    public void generatePreambleScript(ScriptWriter writer, ScriptGeneratorLookup scriptGeneratorLookup) {
        if (this.isEnabled()) {
            this.appendWatchdogActionScript(writer, this.plcIO, RTInputData.speed_slider_mask.name());
            this.appendWatchdogActionScript(writer, this.plcREG1, RTInputData.input_bit_registers0_to_31.name());
            this.appendWatchdogActionScript(writer, this.plcREG2, RTInputData.input_bit_registers32_to_63.name());
        }
    }

    private void appendWatchdogActionScript(ScriptWriter scriptWriter, WatchdogAction watchdogAction, String moduleRegister) {
        if (!watchdogAction.equals((Object)WatchdogAction.IGNORE)) {
            scriptWriter.appendLine("rtde_set_watchdog(\"" + moduleRegister + "\", " + 10.0f + ", \"" + watchdogAction.name().toLowerCase(Locale.ENGLISH) + "\")");
        }
    }

    static {
        ProfinetSettings.ajc$preClinit();
    }

    static final /* synthetic */ void setEnabled_aroundBody0(ProfinetSettings ajc$this, boolean enabled, JoinPoint joinPoint) {
        ajc$this.loadEnabled(enabled);
    }

    static final /* synthetic */ void setPlcIO_aroundBody2(ProfinetSettings ajc$this, WatchdogAction action, JoinPoint joinPoint) {
        ajc$this.loadPlcIO(action);
    }

    static final /* synthetic */ void setPlcREG1_aroundBody4(ProfinetSettings ajc$this, WatchdogAction action, JoinPoint joinPoint) {
        ajc$this.loadPlcREG1(action);
    }

    static final /* synthetic */ void setPlcREG2_aroundBody6(ProfinetSettings ajc$this, WatchdogAction action, JoinPoint joinPoint) {
        ajc$this.loadPlcREG2(action);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProfinetSettings.java", ProfinetSettings.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEnabled", "com.ur.polyscope.profinet.impl.installation.ProfinetSettings", "boolean", "enabled", "", "void"), 61);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPlcIO", "com.ur.polyscope.profinet.impl.installation.ProfinetSettings", "com.ur.polyscope.profinet.impl.generated.WatchdogAction", "action", "", "void"), 66);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPlcREG1", "com.ur.polyscope.profinet.impl.installation.ProfinetSettings", "com.ur.polyscope.profinet.impl.generated.WatchdogAction", "action", "", "void"), 71);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPlcREG2", "com.ur.polyscope.profinet.impl.installation.ProfinetSettings", "com.ur.polyscope.profinet.impl.generated.WatchdogAction", "action", "", "void"), 76);
    }
}

