/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.profinet.impl.installation;

import com.ur.polyscope.profinet.impl.installation.ProfinetUIStateListener;
import com.ur.polyscope.profinet.installation.ProfinetUIState;
import com.ur.util.event.EventManager;
import com.ur.util.event.NotificationStrategy;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class UIStateHolder {
    private final EventManager eventManager;
    private ProfinetUIState currentUIState = ProfinetUIState.ENABLED;

    @Inject
    public UIStateHolder(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public ProfinetUIState getCurrentUIState() {
        return this.currentUIState;
    }

    public void setCurrentUIState(ProfinetUIState newUIState) {
        this.currentUIState = newUIState;
        this.notifyStateChange();
    }

    private void notifyStateChange() {
        this.eventManager.fireEvent(ProfinetUIStateListener.class, (NotificationStrategy)new NotificationStrategy<ProfinetUIStateListener>(){

            public void notify(ProfinetUIStateListener profinetUIStateListener) {
                profinetUIStateListener.stateChanged(UIStateHolder.this);
            }
        });
    }
}

