/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.profinet.impl.xmlrpc;

import com.ur.polyscope.profinet.impl.xmlrpc.Profinet;
import com.ur.polyscope.profinet.impl.xmlrpc.Response;
import com.ur.polyscope.profinet.impl.xmlrpc.UnknownResponseException;
import com.ur.util.logging.Log;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class XMLRPCProfinet
implements Profinet {
    public static final String DEFAULT_DAEMON_IP = "127.0.0.1";
    public static final int DEFAULT_DAEMON_PORT = 40002;
    private final XmlRpcClient client;

    @Inject
    public XMLRPCProfinet() {
        this(DEFAULT_DAEMON_IP, 40002);
    }

    public XMLRPCProfinet(String host, int port) {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setEnabledForExtensions(true);
        try {
            config.setServerURL(new URL("http://" + host + ":" + port + "/RPC2"));
        }
        catch (MalformedURLException e) {
            Log.error((String)"Malformed URL", (Throwable)e);
        }
        config.setConnectionTimeout(800);
        this.client = new XmlRpcClient();
        this.client.setConfig((XmlRpcClientConfig)config);
    }

    @Override
    public boolean isConnected() throws XmlRpcException, UnknownResponseException {
        Object result = this.client.execute("is_connected", new ArrayList());
        return Response.processBoolean(result);
    }

    @Override
    public String getIODeviceName() throws XmlRpcException, UnknownResponseException {
        Object result = this.client.execute("get_io_device_name", new ArrayList());
        return Response.processString(result);
    }

    @Override
    public String getIPAddress() throws XmlRpcException, UnknownResponseException {
        Object result = this.client.execute("get_ip_address", new ArrayList());
        return Response.processString(result);
    }

    @Override
    public List<Integer> getStatusMessages() throws XmlRpcException, UnknownResponseException {
        Object result = this.client.execute("get_status_messages", new ArrayList());
        return Response.processIntegerArray(result);
    }

    @Override
    public List<Boolean> getPluggableModuleStates() throws XmlRpcException, UnknownResponseException {
        Object result = this.client.execute("get_pluggable_module_states", new ArrayList());
        return Response.processBooleanArray(result);
    }

    @Override
    public boolean isDCPSignalingRequested() throws XmlRpcException, UnknownResponseException {
        Object result = this.client.execute("is_signal_enabled", new ArrayList());
        return Response.processBoolean(result);
    }
}

