/*
 * Decompiled with CFR 0.152.
 */
package com.ur.logging.histogram;

import com.thoughtworks.xstream.XStream;
import com.ur.logging.histogram.LifetimeLogger;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.logging.internal.LogSettings;
import com.ur.util.logging.Log;
import com.ur.util.persist.OptionsSection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.inject.Inject;

public class HistogramPersistence {
    private final File histogramDirectory;
    private final String fileNameBase;

    @Inject
    public HistogramPersistence(LogSettings settings) {
        this(settings.getHomeDirectory(), "histogram");
    }

    HistogramPersistence(File histogramDirectory, String fileNameBase) {
        this.histogramDirectory = histogramDirectory;
        this.fileNameBase = fileNameBase;
    }

    public LifetimeLogger.HistogramData loadHistogramData() {
        if (this.getPropertiesFile().exists()) {
            return this.loadFromFile(this.getPropertiesFile(), new PropertiesConverter());
        }
        return this.loadFromFile(this.getXMLFile(), new XMLConverter());
    }

    public void saveHistogramData(LifetimeLogger.HistogramData data) {
        this.saveToFile(data, this.getPropertiesFile(), new PropertiesConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LifetimeLogger.HistogramData loadFromFile(File file, Converter converter) {
        if (file.exists()) {
            LifetimeLogger.HistogramData histogramData;
            InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF8");
            try {
                histogramData = converter.load(fileReader);
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)fileReader).close();
                    throw throwable;
                }
                catch (Exception e) {
                    Log.error((String)"Could not load histogram data", (Throwable)e);
                }
            }
            ((Reader)fileReader).close();
            return histogramData;
        }
        return new LifetimeLogger.HistogramData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(LifetimeLogger.HistogramData data, File file, Converter converter) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8");){
            converter.save(data, writer);
        }
        catch (Exception e) {
            Log.error((String)"Could not save histogram data", (Throwable)e);
        }
    }

    private File getPropertiesFile() {
        return new File(this.histogramDirectory, this.fileNameBase + ".properties");
    }

    private File getXMLFile() {
        return new File(this.histogramDirectory, this.fileNameBase + ".dat");
    }

    static class XMLConverter
    implements Converter {
        static final long G3_TICKS_TO_MICROS = 8000L;

        XMLConverter() {
        }

        @Override
        public LifetimeLogger.HistogramData load(Reader reader) throws IOException {
            XStream xstream = new XStream();
            xstream.setClassLoader(LifetimeLogger.HistogramData.class.getClassLoader());
            xstream.aliasPackage("gui.controllerinterface", "com.ur.logging.histogram");
            xstream.omitField(LifetimeLogger.HistogramData.class, "outer-class");
            LifetimeLogger.HistogramData histogramData = (LifetimeLogger.HistogramData)xstream.fromXML(reader);
            histogramData.time_total_up *= 8000L;
            histogramData.time_total_running *= 8000L;
            histogramData.time_last_seen_controller_timestamp *= 8000L;
            histogramData.time_session_start_controller_timestamp *= 8000L;
            histogramData.time_total_up_at_session_start *= 8000L;
            return histogramData;
        }

        @Override
        public void save(LifetimeLogger.HistogramData data, Writer writer) throws IOException {
            XStream xstream = new XStream();
            xstream.setClassLoader(LifetimeLogger.HistogramData.class.getClassLoader());
            xstream.omitField(LifetimeLogger.HistogramData.class, "outer-class");
            xstream.toXML((Object)data, writer);
        }
    }

    static class PropertiesConverter
    implements Converter {
        private static final String SPEED = "speed";
        private static final String CURRENT = "current";
        private static final String POSITION = "position";
        private static final String MICRO_TEMPERATURE = "micro_temperature";
        private static final String MOTOR_TEMPERATURE = "motor_temperature";
        private static final String ROBOT_MODE = "robot_mode";
        private static final String TIME_TOTAL_UP = "time_total_up";
        private static final String TIME_TOTAL_RUNNING = "time_total_running";
        private static final String TIME_LAST_SEEN_CONTROLLER_TIMESTAMP = "time_last_seen_controller_timestamp";
        private static final String TIME_SESSION_START_CONTROLLER_TIMESTAMP = "time_session_start_controller_timestamp";
        private static final String TIME_TOTAL_UP_AT_SESSION_START = "time_total_up_at_session_start";
        private static final String TOOL_VOLTAGE_48V = "tool_voltage_48v";
        private static final String TOOL_TEMPERATURE = "tool_temperature";
        private static final String TOOL_OUTPUT_VOLTAGE = "tool_output_voltage";
        private static final String TOOL_MODE = "tool_mode";
        private static final String TOOL_CURRENT = "tool_current";
        private static final String MASTER_TEMPERATURE = "master_temperature";
        private static final String ROBOT_VOLTAGE_48V = "robot_voltage_48v";
        private static final String ROBOT_CURRENT = "robot_current";
        private static final String MASTER_IO_CURRENT = "master_io_current";
        private static final String COUNTDOWN_TO_SAVE = "countdown_to_save";
        private static final String NUMBER_OF_TIMES_SAVED = "number_of_times_saved";

        PropertiesConverter() {
        }

        @Override
        public LifetimeLogger.HistogramData load(Reader reader) throws IOException {
            OptionsSection section = new OptionsSection();
            section.load(reader);
            LifetimeLogger.HistogramData result = new LifetimeLogger.HistogramData();
            for (int jointId = 0; jointId < 6; ++jointId) {
                result.histogram_Speed[jointId] = section.getIntArray(this.jointProperty(SPEED, jointId), new int[10]);
                result.histogram_Current[jointId] = section.getIntArray(this.jointProperty(CURRENT, jointId), new int[10]);
                result.histogram_Position[jointId] = section.getIntArray(this.jointProperty(POSITION, jointId), new int[10]);
                result.histogram_MicroTemperature[jointId] = section.getIntArray(this.jointProperty(MICRO_TEMPERATURE, jointId), new int[10]);
                result.histogram_MotorTemperature[jointId] = section.getIntArray(this.jointProperty(MOTOR_TEMPERATURE, jointId), new int[10]);
            }
            result.robotMode = section.getIntArray(ROBOT_MODE, new int[10]);
            result.time_total_up = section.getLong(TIME_TOTAL_UP, 0L);
            result.time_total_running = section.getLong(TIME_TOTAL_RUNNING, 0L);
            result.time_last_seen_controller_timestamp = section.getLong(TIME_LAST_SEEN_CONTROLLER_TIMESTAMP, 0L);
            result.time_session_start_controller_timestamp = section.getLong(TIME_SESSION_START_CONTROLLER_TIMESTAMP, 0L);
            result.time_total_up_at_session_start = section.getLong(TIME_TOTAL_UP_AT_SESSION_START, 0L);
            result.histogram_toolVoltage48V = section.getIntArray(TOOL_VOLTAGE_48V, new int[10]);
            result.histogram_toolTemperature = section.getIntArray(TOOL_TEMPERATURE, new int[10]);
            result.histogram_toolOutputVoltage = section.getIntArray(TOOL_OUTPUT_VOLTAGE, new int[10]);
            result.histogram_toolMode = section.getIntArray(TOOL_MODE, new int[10]);
            result.histogram_toolCurrent = section.getIntArray(TOOL_CURRENT, new int[10]);
            result.histogram_masterTemperature = section.getIntArray(MASTER_TEMPERATURE, new int[10]);
            result.histogram_robotVoltage48V = section.getIntArray(ROBOT_VOLTAGE_48V, new int[10]);
            result.histogram_robotCurrent = section.getIntArray(ROBOT_CURRENT, new int[10]);
            result.histogram_masterIOCurrent = section.getIntArray(MASTER_IO_CURRENT, new int[10]);
            result.countdownToAutosave = section.getLong(COUNTDOWN_TO_SAVE, 0L);
            result.nuberOfTimesSaved = section.getInt(NUMBER_OF_TIMES_SAVED, 0);
            return result;
        }

        @Override
        public void save(LifetimeLogger.HistogramData data, Writer writer) throws IOException {
            OptionsSection section = new OptionsSection();
            for (int i = 0; i < 6; ++i) {
                section.setIntArray(this.jointProperty(SPEED, i), data.histogram_Speed[i]);
                section.setIntArray(this.jointProperty(CURRENT, i), data.histogram_Current[i]);
                section.setIntArray(this.jointProperty(POSITION, i), data.histogram_Position[i]);
                section.setIntArray(this.jointProperty(MICRO_TEMPERATURE, i), data.histogram_MicroTemperature[i]);
                section.setIntArray(this.jointProperty(MOTOR_TEMPERATURE, i), data.histogram_MotorTemperature[i]);
            }
            section.setIntArray(ROBOT_MODE, data.robotMode);
            section.setLong(TIME_TOTAL_UP, data.time_total_up);
            section.setLong(TIME_TOTAL_RUNNING, data.time_total_running);
            section.setLong(TIME_LAST_SEEN_CONTROLLER_TIMESTAMP, data.time_last_seen_controller_timestamp);
            section.setLong(TIME_SESSION_START_CONTROLLER_TIMESTAMP, data.time_session_start_controller_timestamp);
            section.setLong(TIME_TOTAL_UP_AT_SESSION_START, data.time_total_up_at_session_start);
            section.setIntArray(TOOL_VOLTAGE_48V, data.histogram_toolVoltage48V);
            section.setIntArray(TOOL_TEMPERATURE, data.histogram_toolTemperature);
            section.setIntArray(TOOL_OUTPUT_VOLTAGE, data.histogram_toolOutputVoltage);
            section.setIntArray(TOOL_MODE, data.histogram_toolMode);
            section.setIntArray(TOOL_CURRENT, data.histogram_toolCurrent);
            section.setIntArray(MASTER_TEMPERATURE, data.histogram_masterTemperature);
            section.setIntArray(ROBOT_VOLTAGE_48V, data.histogram_robotVoltage48V);
            section.setIntArray(ROBOT_CURRENT, data.histogram_robotCurrent);
            section.setIntArray(MASTER_IO_CURRENT, data.histogram_masterIOCurrent);
            section.setLong(COUNTDOWN_TO_SAVE, data.countdownToAutosave);
            section.setInt(NUMBER_OF_TIMES_SAVED, data.nuberOfTimesSaved);
            section.save(writer);
        }

        private String jointProperty(String baseName, int jointId) {
            return baseName + "_" + this.nameForJoint(jointId);
        }

        private String nameForJoint(int jointId) {
            return JointType.fromJointNumber((int)jointId).name().toLowerCase();
        }
    }

    static interface Converter {
        public LifetimeLogger.HistogramData load(Reader var1) throws IOException;

        public void save(LifetimeLogger.HistogramData var1, Writer var2) throws IOException;
    }
}

