/*
 * Decompiled with CFR 0.152.
 */
package com.ur.logging.histogram;

import com.ur.lang.PrimitiveUtils;
import com.ur.logging.histogram.HistogramPersistence;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.polyscope.logging.internal.LogSettings;
import com.ur.util.event.EventManager;
import com.ur.util.logging.FilePersister;
import com.ur.util.logging.Log;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Singleton
public class LifetimeLogger
implements RobotStateListener {
    private static final long PERSIST_EVERY = TimeUnit.HOURS.toMicros(1L);
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final long SESSION_CONTINUATION_TIMEOUT = TimeUnit.SECONDS.toMicros(8L);
    private static LogSettings settings;
    private static DecimalFormat df2;
    private static DecimalFormat df3;
    private static DecimalFormat df4;
    public static Vector<String> logLineList;
    public final HistogramData histogramData;
    private HistogramPersistence histogramPersistence;

    @Inject
    public LifetimeLogger(LogSettings settings, HistogramPersistence histogramPersistence, EventManager eventManager) {
        LifetimeLogger.settings = settings;
        this.histogramPersistence = histogramPersistence;
        this.histogramData = histogramPersistence.loadHistogramData();
        eventManager.addStrongListener(RobotStateListener.class, (Object)this);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LifetimeLogger.this.cleanUp();
            }
        });
        this.histogramData.countdownToAutosave = 0L;
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String dateStr = sdf.format(new Date());
        LifetimeLogger.addLogLine("******** Log start (" + dateStr + ") ********\n");
    }

    public void updateRobotState(RobotState robotState) {
        long deltaTime = robotState.timestamp - this.histogramData.time_last_seen_controller_timestamp;
        if (deltaTime < SESSION_CONTINUATION_TIMEOUT && deltaTime >= 0L) {
            int index;
            this.histogramData.time_total_up += deltaTime;
            if (robotState.programRunning) {
                this.histogramData.time_total_running += deltaTime;
            }
            for (int j = 0; j < 6; ++j) {
                int indexS = (int)Math.abs(robotState.jointSpeed.getJoint(j) / 0.5);
                indexS = PrimitiveUtils.between((int)indexS, (int)0, (int)9);
                int[] nArray = this.histogramData.histogram_Speed[j];
                int n = indexS;
                nArray[n] = nArray[n] + 1;
                int indexC = (int)Math.abs((double)robotState.jointCurrent[j] / 2.0);
                indexC = PrimitiveUtils.between((int)indexC, (int)0, (int)9);
                int[] nArray2 = this.histogramData.histogram_Current[j];
                int n2 = indexC;
                nArray2[n2] = nArray2[n2] + 1;
                index = (int)((robotState.jointPosition.getJoint(j) + Math.PI * 2) / 1.2566);
                index = PrimitiveUtils.between((int)index, (int)0, (int)9);
                int[] nArray3 = this.histogramData.histogram_Position[j];
                int n3 = index;
                nArray3[n3] = nArray3[n3] + 1;
                index = (int)(((double)robotState.jointMicroTemperature[j] + 20.0) / 15.0);
                index = PrimitiveUtils.between((int)index, (int)0, (int)9);
                int[] nArray4 = this.histogramData.histogram_MicroTemperature[j];
                int n4 = index;
                nArray4[n4] = nArray4[n4] + 1;
                index = (int)(((double)robotState.jointMotorTemperature[j] + 20.0) / 15.0);
                index = PrimitiveUtils.between((int)index, (int)0, (int)9);
                int[] nArray5 = this.histogramData.histogram_MotorTemperature[j];
                int n5 = index;
                nArray5[n5] = nArray5[n5] + 1;
            }
            index = robotState.robotMode.getId();
            int n = index = PrimitiveUtils.between((int)index, (int)0, (int)9);
            this.histogramData.robotMode[n] = this.histogramData.robotMode[n] + 1;
            index = (int)((double)robotState.toolVoltage48V / 5.0);
            int n6 = index = PrimitiveUtils.between((int)index, (int)0, (int)9);
            this.histogramData.histogram_toolVoltage48V[n6] = this.histogramData.histogram_toolVoltage48V[n6] + 1;
            index = (int)((double)robotState.toolTemperature + 1.3333333333333333);
            int n7 = index = PrimitiveUtils.between((int)index, (int)0, (int)9);
            this.histogramData.histogram_toolTemperature[n7] = this.histogramData.histogram_toolTemperature[n7] + 1;
            index = (int)((double)robotState.toolOutputVoltage / 5.0);
            int n8 = index = PrimitiveUtils.between((int)index, (int)0, (int)9);
            this.histogramData.histogram_toolOutputVoltage[n8] = this.histogramData.histogram_toolOutputVoltage[n8] + 1;
            int n9 = index = robotState.toolMode.getId() % 10;
            this.histogramData.histogram_toolMode[n9] = this.histogramData.histogram_toolMode[n9] + 1;
            index = (int)(robotState.toolCurrent * 10.0f);
            int n10 = index = PrimitiveUtils.between((int)index, (int)0, (int)9);
            this.histogramData.histogram_toolCurrent[n10] = this.histogramData.histogram_toolCurrent[n10] + 1;
            index = (int)((double)robotState.masterTemperature + 1.3333333333333333);
            int n11 = index = PrimitiveUtils.between((int)index, (int)0, (int)9);
            this.histogramData.histogram_masterTemperature[n11] = this.histogramData.histogram_masterTemperature[n11] + 1;
            index = (int)((double)robotState.robotVoltage48V / 5.0);
            int n12 = index = PrimitiveUtils.between((int)index, (int)0, (int)9);
            this.histogramData.histogram_robotVoltage48V[n12] = this.histogramData.histogram_robotVoltage48V[n12] + 1;
            index = (int)((double)robotState.robotCurrent / 4.0) + 2;
            int n13 = index = PrimitiveUtils.between((int)index, (int)0, (int)9);
            this.histogramData.histogram_robotCurrent[n13] = this.histogramData.histogram_robotCurrent[n13] + 1;
            index = (int)(robotState.masterIOCurrent * 10.0f);
            int n14 = index = PrimitiveUtils.between((int)index, (int)0, (int)9);
            this.histogramData.histogram_masterIOCurrent[n14] = this.histogramData.histogram_masterIOCurrent[n14] + 1;
        } else {
            this.histogramData.time_session_start_controller_timestamp = robotState.timestamp;
            this.histogramData.time_total_up_at_session_start = this.histogramData.time_total_up;
        }
        this.histogramData.time_last_seen_controller_timestamp = robotState.timestamp;
        if (deltaTime > 0L) {
            this.histogramData.countdownToAutosave -= deltaTime;
        }
        if (this.histogramData.countdownToAutosave <= 0L) {
            ++this.histogramData.nuberOfTimesSaved;
            this.histogramPersistence.saveHistogramData(this.histogramData);
            LifetimeLogger.saveLoglistMessages();
            this.histogramData.countdownToAutosave = PERSIST_EVERY;
        }
    }

    public long controllerTimestampToLifetimeTimestamp(long timestamp) {
        long ret = timestamp < 1L ? this.histogramData.time_last_seen_controller_timestamp - this.histogramData.time_session_start_controller_timestamp + timestamp + this.histogramData.time_total_up_at_session_start : timestamp + this.histogramData.time_total_up_at_session_start;
        if (ret < 0L) {
            ret = this.histogramData.time_total_up;
        }
        return ret;
    }

    public static void addLogLine(String entry) {
        String fixedLogEntry = entry.replace("\n", "\r\n");
        logLineList.add(fixedLogEntry);
        if (logLineList.size() == settings.lengthOfLogInMemoryBeforePersist()) {
            LifetimeLogger.saveLoglistMessages();
        }
    }

    public static synchronized void saveLoglistMessages() {
        try {
            FilePersister.appendLines(logLineList, (String)"log_history", (String)"txt");
            logLineList.clear();
        }
        catch (Exception e) {
            Log.error((String)"Could not save log message list", (Throwable)e);
        }
    }

    private void cleanUp() {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String dateStr = sdf.format(new Date());
        LifetimeLogger.addLogLine("******** Log end (" + dateStr + ") ********\n");
        this.histogramPersistence.saveHistogramData(this.histogramData);
        LifetimeLogger.saveLoglistMessages();
    }

    public static String getTimeString(long t) {
        if (t != -1L) {
            long ms = t /= 1000L;
            long s = t / 1000L;
            long m = t / 60000L;
            long h = t / 3600000L;
            long d = t / 86400000L;
            return "" + df4.format(d %= 10000L) + "d" + df2.format(h %= 24L) + "h" + df2.format(m %= 60L) + "m" + df2.format(s %= 60L) + "." + df3.format(ms %= 1000L) + "s";
        }
        return "----:--:--:--.--- ";
    }

    static {
        df2 = new DecimalFormat("00");
        df3 = new DecimalFormat("000");
        df4 = new DecimalFormat("0000");
        logLineList = new Vector();
    }

    public static class HistogramData
    implements Serializable {
        public int[][] histogram_Speed = new int[6][10];
        public int[][] histogram_Current = new int[6][10];
        public int[][] histogram_Position = new int[6][10];
        public int[][] histogram_MicroTemperature = new int[6][10];
        public int[][] histogram_MotorTemperature = new int[6][10];
        public int[][][] histogram_SpeedAndCurrent = new int[6][10][10];
        public int[] robotMode = new int[10];
        public long time_total_up;
        public long time_total_running;
        public long time_last_seen_controller_timestamp = 0L;
        public long time_session_start_controller_timestamp = 0L;
        public long time_total_up_at_session_start = 0L;
        public int[] histogram_toolVoltage48V = new int[10];
        public int[] histogram_toolTemperature = new int[10];
        public int[] histogram_toolOutputVoltage = new int[10];
        public int[] histogram_toolMode = new int[10];
        public int[] histogram_toolCurrent = new int[10];
        public int[] histogram_masterTemperature = new int[10];
        public int[] histogram_robotVoltage48V = new int[10];
        public int[] histogram_robotCurrent = new int[10];
        public int[] histogram_masterIOCurrent = new int[10];
        public long countdownToAutosave = 0L;
        public int nuberOfTimesSaved = 0;

        public int hashCode() {
            return new HashCodeBuilder().append((Object[])this.histogram_Speed).append((Object[])this.histogram_Current).append((Object[])this.histogram_Position).append((Object[])this.histogram_MicroTemperature).append((Object[])this.histogram_MotorTemperature).append(this.robotMode).append(this.time_total_up).append(this.time_total_running).append(this.time_last_seen_controller_timestamp).append(this.time_session_start_controller_timestamp).append(this.time_total_up_at_session_start).append(this.histogram_toolVoltage48V).append(this.histogram_toolTemperature).append(this.histogram_toolOutputVoltage).append(this.histogram_toolMode).append(this.histogram_toolCurrent).append(this.histogram_masterTemperature).append(this.histogram_robotVoltage48V).append(this.histogram_robotCurrent).append(this.histogram_masterIOCurrent).append(this.countdownToAutosave).append(this.nuberOfTimesSaved).toHashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof HistogramData) {
                HistogramData otherData = (HistogramData)other;
                return new EqualsBuilder().append((Object[])this.histogram_Speed, (Object[])otherData.histogram_Speed).append((Object[])this.histogram_Current, (Object[])otherData.histogram_Current).append((Object[])this.histogram_Position, (Object[])otherData.histogram_Position).append((Object[])this.histogram_MicroTemperature, (Object[])otherData.histogram_MicroTemperature).append((Object[])this.histogram_MotorTemperature, (Object[])otherData.histogram_MotorTemperature).append(this.robotMode, otherData.robotMode).append(this.time_total_up, otherData.time_total_up).append(this.time_total_running, otherData.time_total_running).append(this.time_last_seen_controller_timestamp, otherData.time_last_seen_controller_timestamp).append(this.time_session_start_controller_timestamp, otherData.time_session_start_controller_timestamp).append(this.time_total_up_at_session_start, otherData.time_total_up_at_session_start).append(this.histogram_toolVoltage48V, otherData.histogram_toolVoltage48V).append(this.histogram_toolTemperature, otherData.histogram_toolTemperature).append(this.histogram_toolOutputVoltage, otherData.histogram_toolOutputVoltage).append(this.histogram_toolMode, otherData.histogram_toolMode).append(this.histogram_toolCurrent, otherData.histogram_toolCurrent).append(this.histogram_masterTemperature, otherData.histogram_masterTemperature).append(this.histogram_robotVoltage48V, otherData.histogram_robotVoltage48V).append(this.histogram_robotCurrent, otherData.histogram_robotCurrent).append(this.histogram_masterIOCurrent, otherData.histogram_masterIOCurrent).append(this.countdownToAutosave, otherData.countdownToAutosave).append(this.nuberOfTimesSaved, otherData.nuberOfTimesSaved).isEquals();
            }
            return false;
        }
    }
}

