/*
 * Decompiled with CFR 0.152.
 */
package com.ur.logging.resources;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class LoggingImageResource {
    private static boolean isG5 = true;

    private LoggingImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="date-and-time.png")
    public static Icon dateAndTime() {
        return LoggingImageResource.tryGetImage("date-and-time.png");
    }

    @Key(value="joint_1.png")
    public static Icon joint1() {
        return LoggingImageResource.tryGetImage("joint_1.png");
    }

    @Key(value="form-warning.png")
    public static Icon formWarning() {
        return LoggingImageResource.tryGetImage("form-warning.png");
    }

    @Key(value="form-developer-warning.png")
    public static Icon formDeveloperWarning() {
        return LoggingImageResource.tryGetImage("form-developer-warning.png");
    }

    @Key(value="log-report-available.png")
    public static Icon logReportAvailable() {
        return LoggingImageResource.tryGetImage("log-report-available.png");
    }

    @Key(value="joint_4.png")
    public static Icon joint4() {
        return LoggingImageResource.tryGetImage("joint_4.png");
    }

    @Key(value="joint_3.png")
    public static Icon joint3() {
        return LoggingImageResource.tryGetImage("joint_3.png");
    }

    @Key(value="form-developer-info.png")
    public static Icon formDeveloperInfo() {
        return LoggingImageResource.tryGetImage("form-developer-info.png");
    }

    @Key(value="my_ur.png")
    public static Icon myUr() {
        return LoggingImageResource.tryGetImage("my_ur.png");
    }

    @Key(value="log-white.png")
    public static Icon logWhite() {
        return LoggingImageResource.tryGetImage("log-white.png");
    }

    @Key(value="joint_0.png")
    public static Icon joint0() {
        return LoggingImageResource.tryGetImage("joint_0.png");
    }

    @Key(value="form-fault.png")
    public static Icon formFault() {
        return LoggingImageResource.tryGetImage("form-fault.png");
    }

    @Key(value="blank.png")
    public static Icon blank() {
        return LoggingImageResource.tryGetImage("blank.png");
    }

    @Key(value="joint_5.png")
    public static Icon joint5() {
        return LoggingImageResource.tryGetImage("joint_5.png");
    }

    @Key(value="form-developer-error.png")
    public static Icon formDeveloperError() {
        return LoggingImageResource.tryGetImage("form-developer-error.png");
    }

    @Key(value="form-developer-debug.png")
    public static Icon formDeveloperDebug() {
        return LoggingImageResource.tryGetImage("form-developer-debug.png");
    }

    @Key(value="joint_2.png")
    public static Icon joint2() {
        return LoggingImageResource.tryGetImage("joint_2.png");
    }

    @Key(value="form-attachment.png")
    public static Icon formAttachment() {
        return LoggingImageResource.tryGetImage("form-attachment.png");
    }

    @Key(value="robot_joints.png")
    public static Icon robotJoints() {
        return LoggingImageResource.tryGetImage("robot_joints.png");
    }

    @Key(value="form-information.png")
    public static Icon formInformation() {
        return LoggingImageResource.tryGetImage("form-information.png");
    }

    @Key(value="form-developer-fault.png")
    public static Icon formDeveloperFault() {
        return LoggingImageResource.tryGetImage("form-developer-fault.png");
    }

    @Key(value="form-error.png")
    public static Icon formError() {
        return LoggingImageResource.tryGetImage("form-error.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return LoggingImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    static {
        if (isG5) {
            LoggingImageResource.tryGetImage("date-and-time.png");
            LoggingImageResource.tryGetImage("joint_1.png");
            LoggingImageResource.tryGetImage("form-warning.png");
            LoggingImageResource.tryGetImage("form-developer-warning.png");
            LoggingImageResource.tryGetImage("log-report-available.png");
            LoggingImageResource.tryGetImage("joint_4.png");
            LoggingImageResource.tryGetImage("joint_3.png");
            LoggingImageResource.tryGetImage("form-developer-info.png");
            LoggingImageResource.tryGetImage("my_ur.png");
            LoggingImageResource.tryGetImage("log-white.png");
            LoggingImageResource.tryGetImage("joint_0.png");
            LoggingImageResource.tryGetImage("form-fault.png");
            LoggingImageResource.tryGetImage("blank.png");
            LoggingImageResource.tryGetImage("joint_5.png");
            LoggingImageResource.tryGetImage("form-developer-error.png");
            LoggingImageResource.tryGetImage("form-developer-debug.png");
            LoggingImageResource.tryGetImage("joint_2.png");
            LoggingImageResource.tryGetImage("form-attachment.png");
            LoggingImageResource.tryGetImage("robot_joints.png");
            LoggingImageResource.tryGetImage("form-information.png");
            LoggingImageResource.tryGetImage("form-developer-fault.png");
            LoggingImageResource.tryGetImage("form-error.png");
        }
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = path + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

