/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.internal;

import com.ur.logging.resources.TextResource;
import com.ur.view.constants.dev.JointMode;
import javax.inject.Inject;

public class JointModes {
    private static TextResource textResource;

    @Inject
    public static void setTextResource(TextResource textResource) {
        JointModes.textResource = textResource;
    }

    public static String getString(int id) {
        if (id == -1) {
            return textResource.noController();
        }
        return JointModes.getString(JointMode.byId((int)id));
    }

    public static String getString(JointMode mode) {
        switch (mode) {
            case NOT_RESPONDING: {
                return textResource.jointNotRespondingMode();
            }
            case MOTOR_INITIALISATION: {
                return textResource.jointMotorInitialisationMode();
            }
            case BOOTING: {
                return textResource.jointBootingMode();
            }
            case PART_D_CALIBRATION_ERROR: {
                return textResource.jointPartDCalibrationErrorMode();
            }
            case BOOTLOADER: {
                return textResource.jointBootloaderMode();
            }
            case CALIBRATION: {
                return textResource.jointCalibrationMode();
            }
            case FAULT: {
                return textResource.jointFaultMode();
            }
            case RUNNING: {
                return textResource.jointRunningMode();
            }
            case IDLE: {
                return textResource.jointIdleMode();
            }
            case SHUTTING_DOWN: {
                return textResource.jointShuttingDownMode();
            }
            case READY_FOR_POWER_OFF: {
                return textResource.jointReadyForPowerOffMode();
            }
            case POWER_OFF: {
                return textResource.jointPowerOffMode();
            }
            case BACKDRIVE: {
                return textResource.jointBackdriveMode();
            }
            case PART_D_CALIBRATION: {
                return "PART_D_CAL";
            }
            case BRAKE_FAILURE: {
                return textResource.jointBrakeFailureMode();
            }
        }
        return textResource.jointModeUnknown() + " " + mode;
    }
}

