/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.internal;

import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.polyscope.logging.internal.LogSettings;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;

public class LogSettingsImpl
implements LogSettings {
    private static final String RUNNING_IN_DEVELOPMENT_MODE = "RunningInDevelopmentMode";
    private static final String LENGTH_OF_LOG_IN_MEMORY_BEFORE_PERSIST = "LengthOfLogInMemoryBeforePersist";
    private static final String MOCK_LANGUAGE = "dummy.language";
    private static final String SHOW_DEVELOPER_MESSAGES = "ShowDeveloperMessages";
    private static final String SHOW_LOG_ERRORS = "showLogErrors";
    private static final String SHOW_LOG_WARNINGS = "showLogWarnings";
    private static final String SHOW_LOG_INFORMATION = "showLogInformation";
    private static final String SHOW_LOG_ATTACHMENTS = "showLogAttachments";
    private static WriteableModuleSettings settings = new WriteableModuleSettings("logging.properties");

    @Override
    public int lengthOfLogInMemoryBeforePersist() {
        return settings.properties().getInteger(LENGTH_OF_LOG_IN_MEMORY_BEFORE_PERSIST, 1000);
    }

    @Override
    public boolean showDeveloperInformation() {
        return settings.properties().getBoolean(SHOW_DEVELOPER_MESSAGES, false);
    }

    @Override
    public boolean filterInformation() {
        return settings.properties().getBoolean(SHOW_LOG_INFORMATION, false);
    }

    @Override
    public boolean filterWarnings() {
        return settings.properties().getBoolean(SHOW_LOG_WARNINGS, false);
    }

    @Override
    public boolean filterErrors() {
        return settings.properties().getBoolean(SHOW_LOG_ERRORS, true);
    }

    @Override
    public boolean filterAttachments() {
        return settings.properties().getBoolean(SHOW_LOG_ATTACHMENTS, false);
    }

    @Override
    public boolean isRunningInDevelopmentMode() {
        return System.getProperty(RUNNING_IN_DEVELOPMENT_MODE, "false").equals("true");
    }

    @Override
    public File getHomeDirectory() {
        return new File(System.getProperty("user.home"));
    }

    @Override
    public void setLogFilters(boolean showInformation, boolean showWarning, boolean showErrors, boolean showAttachments) {
        settings.properties().setProperty(SHOW_LOG_INFORMATION, Boolean.toString(showInformation));
        settings.properties().setProperty(SHOW_LOG_WARNINGS, Boolean.toString(showWarning));
        settings.properties().setProperty(SHOW_LOG_ERRORS, Boolean.toString(showErrors));
        settings.properties().setProperty(SHOW_LOG_ATTACHMENTS, Boolean.toString(showAttachments));
        try {
            settings.write();
        }
        catch (IOException e) {
            Log.error((String)"Log Filter settings will not be saved!");
        }
    }

    public static boolean useDummyLanguage() {
        return settings.properties().getBoolean(MOCK_LANGUAGE, false);
    }
}

