/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.internal;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ReadOnlyDashboardAction;
import com.ur.dashboardserver.ScriptActionDefinitionParser;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.logging.histogram.LifetimeLogger;
import com.ur.swing.SwingUtil;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.constants.errorcodes.MessageSource;

@ReadOnlyDashboardAction
public class LoggingAction
implements DashBoardAction {
    private static final ScriptActionDefinitionParser SAVE_LOG = new ScriptActionDefinitionParser("saveLog");
    private static final ScriptActionDefinitionParser ADD_TO_LOG = new ScriptActionDefinitionParser("addToLog <rest>");

    public boolean canHandleMessage(String input) {
        return SAVE_LOG.isMatch(input) || ADD_TO_LOG.isMatch(input);
    }

    public String execute(String inputLine) {
        if (SAVE_LOG.isMatch(inputLine)) {
            Runnable doWorkRunnable = new Runnable(){

                @Override
                public void run() {
                    LifetimeLogger.saveLoglistMessages();
                }
            };
            SwingUtil.invokeAndWait((Runnable)doWorkRunnable);
            return "Log saved to disk";
        }
        String logMessage = ADD_TO_LOG.getArgument(0, inputLine);
        RobotMessage robotMessage = new RobotMessage();
        robotMessage.message = logMessage;
        robotMessage.type = RobotMessageType.TEXT;
        robotMessage.timestamp = -1L;
        robotMessage.source = MessageSource.GUI;
        robotMessage.notifyAllSubscribers();
        return "Added log message";
    }
}

