/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.internal;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ReadOnlyDashboardAction;
import com.ur.lang.StringUtils;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.polyscope.controllerinterface.errorcode.ErrorCode;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.errorcodes.MessageSource;
import com.ur.view.constants.errorcodes.ReportDataType;
import com.ur.view.constants.errorcodes.ReportLevel;

@ReadOnlyDashboardAction
public class RobotMessageAction
implements DashBoardAction {
    private static final String HELP = "help";
    private static final String SAFETY_MESSAGE = "safety";
    private static final String ERROR_MESSAGE = "error";

    public boolean canHandleMessage(String input) {
        return StringUtils.startsWithAnyIgnoreCase((String)input, (String[])new String[]{"robotmessage"});
    }

    public String execute(String input) {
        String[] message = input.split(" ");
        RobotMessage robotMessage = new RobotMessage();
        if (message.length <= 1) {
            return "Unknown command\nType 'RobotMessage help' for usage.";
        }
        if (message[1].equalsIgnoreCase(HELP)) {
            return "Type 'RobotMessage <subcommand> [args]\n\nAvailable subcommands:\n\tsafety\t=> Takes 6 arguments: safety mode, warning level, source, error code, error argument, extra data\n\terror\t=> Takes 5 arguments: warning level, source, error code, error argument, extra data\nAvailable arguments:\n\tSafety Mode: " + this.safetyArguments() + "\n\tWarning Level: " + this.warningLevelArguments() + "\n\tSource: " + this.sourceArguments() + "\n\tError Code: " + this.errorCodeArguments() + "\n\tError Argument: (unsigned)\n\tExtra Data: (" + this.extraDataTypes() + ")\nExamples:\n" + this.safetyMessageExamples() + "\n" + this.errorMessageExamples();
        }
        if (message[1].equalsIgnoreCase(SAFETY_MESSAGE)) {
            robotMessage.type = RobotMessageType.SAFETY_MODE;
            robotMessage.safetyMode = SafetyMode.valueOf((String)message[2].toUpperCase());
            robotMessage.warningLevel = ReportLevel.valueOf((String)message[3].toUpperCase());
            robotMessage.source = MessageSource.valueOf((String)message[4].toUpperCase());
            try {
                robotMessage.errorCode = ErrorCode.byId((int)Integer.parseInt(message[5]));
            }
            catch (NumberFormatException e) {
                robotMessage.errorCode = ErrorCode.valueOf((String)message[5].toUpperCase());
            }
            robotMessage.errorArgument = Integer.parseInt(message[6]);
            if (message.length > 7) {
                robotMessage.extraData = message[7];
            }
        } else if (message[1].equalsIgnoreCase(ERROR_MESSAGE)) {
            robotMessage.type = RobotMessageType.ERROR_CODE;
            robotMessage.warningLevel = ReportLevel.valueOf((String)message[2].toUpperCase());
            robotMessage.source = MessageSource.valueOf((String)message[3].toUpperCase());
            try {
                robotMessage.errorCode = ErrorCode.byId((int)Integer.parseInt(message[4]));
            }
            catch (NumberFormatException e) {
                robotMessage.errorCode = ErrorCode.valueOf((String)message[4].toUpperCase());
            }
            robotMessage.errorArgument = Integer.parseInt(message[5]);
            if (message.length > 6) {
                robotMessage.extraData = message[6];
            }
        }
        robotMessage.notifyAllSubscribers();
        return "fired RobotMessage";
    }

    private String safetyArguments() {
        return StringUtils.joinStringsWith((String)", ", (Object[])SafetyMode.values());
    }

    private String sourceArguments() {
        return StringUtils.joinStringsWith((String)", ", (Object[])MessageSource.values());
    }

    private String errorCodeArguments() {
        return StringUtils.joinStringsWith((String)", ", (Object[])ErrorCode.values());
    }

    private String warningLevelArguments() {
        return StringUtils.joinStringsWith((String)", ", (Object[])ReportLevel.values());
    }

    private String extraDataTypes() {
        return StringUtils.joinStringsWith((String)", ", (Object[])ReportDataType.values()).toLowerCase();
    }

    private String safetyMessageExamples() {
        return "\tRobotMessage safety " + SafetyMode.SYSTEM_EMERGENCY_STOP + " " + ReportLevel.VIOLATION + " " + MessageSource.UA + " " + ErrorCode.JOINT_POSITION_DEVIATION_PROTECTIVE_STOP + " 11 50\n\tRobotMessage " + SAFETY_MESSAGE + " " + SafetyMode.SYSTEM_EMERGENCY_STOP + " " + ReportLevel.VIOLATION + " " + MessageSource.UA + " 740 11 50\n";
    }

    private String errorMessageExamples() {
        return "\tRobotMessage error " + ReportLevel.FAULT + " " + MessageSource.SCB_FPGA + " " + ErrorCode.SAFETY_SYSTEM + " 6 0xA6\n\tRobotMessage " + ERROR_MESSAGE + " " + ReportLevel.FAULT + " " + MessageSource.SCB_FPGA + " 283 6 0xA6\n";
    }
}

