/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.internal;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.injection.Binder;
import com.ur.injection.Builder;
import com.ur.injection.ServicesBinder;
import com.ur.log.GoToLog;
import com.ur.log.GoToLogConsumer;
import com.ur.log.LogTab;
import com.ur.log.logentry.robotmessage.RobotMessageConsumer;
import com.ur.logging.resources.TextResource;
import com.ur.logging.resources.impl.TextResourceImpl;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.logging.internal.ErrorCodeMessageConsumer;
import com.ur.polyscope.logging.internal.ExportButtonActionFactory;
import com.ur.polyscope.logging.internal.GoToInnerLogTab;
import com.ur.polyscope.logging.internal.JointModes;
import com.ur.polyscope.logging.internal.LogSettings;
import com.ur.polyscope.logging.internal.LogSettingsImpl;
import com.ur.polyscope.logging.internal.LogTabCardPanelContribution;
import com.ur.polyscope.logging.internal.LoggingAction;
import com.ur.polyscope.logging.internal.ReservedNamesProviderImpl;
import com.ur.polyscope.logging.internal.RobotMessageAction;
import com.ur.polyscope.logging.internal.RunScreenFooterImpl;
import com.ur.polyscope.logging.internal.dashboardserver.GenerateSupportReportAction;
import com.ur.polyscope.logging.internal.flightrecord.FullRobotLogProbe;
import com.ur.polyscope.logging.internal.flightrecord.MinimalRobotLogProbe;
import com.ur.polyscope.logging.logtab.AttachmentModel;
import com.ur.polyscope.logging.logtab.InnerLogTab;
import com.ur.polyscope.logging.logtab.LogTabLayoutStrategy;
import com.ur.polyscope.logging.logtab.ShowLogTabContribution;
import com.ur.polyscope.logging.naming.ReservedNamesProvider;
import com.ur.swing.CardPanelMappedContribution;
import com.ur.swing.extensible.ExtensionPointServiceBinder;
import com.ur.swing.extensible.FooterExtension;
import com.ur.swing.extensible.MenuExtension;
import com.ur.util.logging.Log;
import com.ur.view.constants.comm.RobotMessageType;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class ServiceBinderImpl
implements ServicesBinder {
    private static final String RUNNING_IN_DEVELOPMENT_MODE = "RunningInDevelopmentMode";

    public void bind(Binder binder) {
        binder.bindToExtensionPoint(MenuExtension.class, ShowLogTabContribution.class);
        binder.bindClass(InnerLogTab.LayoutStrategy.class, LogTabLayoutStrategy.class);
        binder.bindToExtensionPoint(FooterExtension.class, RunScreenFooterImpl.class);
        binder.bindToExtensionPoint(CardPanelMappedContribution.class, LogTabCardPanelContribution.class);
        ExtensionPointServiceBinder.registerExtensionPoints((Binder)binder, RunScreenFooterImpl.class);
        binder.bindClass(LogTab.class, InnerLogTab.class);
        this.bindTextResource(binder);
        binder.bindClass(LogSettings.class, LogSettingsImpl.class);
        binder.bindToExtensionPoint(DashBoardAction.class, LoggingAction.class);
        binder.bindToExtensionPoint(FlightRecorderProbe.class, MinimalRobotLogProbe.class);
        binder.bindToExtensionPoint(FlightRecorderProbe.class, FullRobotLogProbe.class);
        binder.bindToExtensionPoint(DashBoardAction.class, GenerateSupportReportAction.class);
        binder.bindKeyToExtensionPoint((Enum)RobotMessageType.ERROR_CODE, RobotMessageConsumer.class, ErrorCodeMessageConsumer.class);
        binder.requestStaticBinding(ExportButtonActionFactory.class);
        binder.requestStaticBinding(JointModes.class);
        binder.requestStaticBinding(AttachmentModel.class);
        binder.bindClass(GoToLog.class, GoToInnerLogTab.class);
        if (System.getProperty(RUNNING_IN_DEVELOPMENT_MODE, "false").equals("true")) {
            binder.bindToExtensionPoint(DashBoardAction.class, RobotMessageAction.class);
        }
        binder.bindClass(ReservedNamesProvider.class, ReservedNamesProviderImpl.class);
        Log.debug((String)"Log component is bound");
    }

    public void load(Builder builder) {
        GoToLog goToLog = (GoToLog)builder.get(GoToLog.class);
        for (GoToLogConsumer c : this.tryGetConsumers(builder)) {
            c.setGoToLog(goToLog);
        }
    }

    private Set<GoToLogConsumer> tryGetConsumers(Builder builder) {
        try {
            return builder.getExtensions(GoToLogConsumer.class);
        }
        catch (Throwable e) {
            return new HashSet<GoToLogConsumer>();
        }
    }

    private void bindTextResource(Binder binder) {
        if (LogSettingsImpl.useDummyLanguage()) {
            binder.bindInstance(TextResource.class, (Object)new TextResourceImpl(new Locale("dummy")));
        } else {
            binder.bindClass(TextResource.class, TextResourceImpl.class);
        }
    }
}

