/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.internal;

import com.ur.lang.DecimalFormatFactory;
import com.ur.logging.resources.TextResource;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TimeCounter {
    public static final String TIME_COUNTER_SECONDS = "timeCounterSeconds.G5RunPanel";
    private static final String UNDEFINED_TIME_STRING = "--";
    private final DecimalFormat twoDigitFormat = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"00");
    private JLabel daysLabel = new JLabel();
    private JLabel hoursLabel = new JLabel();
    private JLabel minutesLabel = new JLabel();
    private JLabel secondsLabel = new JLabel();

    public TimeCounter() {
        this.secondsLabel.setName(TIME_COUNTER_SECONDS);
    }

    public void initializeLabels(JPanel panel, ViewContext viewContext) {
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        URFontFactory fontFactory = viewContext.getFontFactory();
        panel.add(widgetFactory.createTitleValuePair(textResource.Days(), this.daysLabel));
        panel.add(widgetFactory.createTitleValuePair(textResource.Hours(), this.hoursLabel));
        panel.add(widgetFactory.createTitleValuePair(textResource.Minutes(), this.minutesLabel));
        panel.add(widgetFactory.createTitleValuePair(textResource.Seconds(), this.secondsLabel));
        URFontFactory.Size fontSize = URFontFactory.Size.VERY_LARGE;
        URFontFactory.Style fontStyle = URFontFactory.Style.BOLD;
        this.daysLabel.setFont(fontFactory.getRelativeFont(fontStyle, fontSize));
        this.hoursLabel.setFont(fontFactory.getRelativeFont(fontStyle, fontSize));
        this.minutesLabel.setFont(fontFactory.getRelativeFont(fontStyle, fontSize));
        this.secondsLabel.setFont(fontFactory.getRelativeFont(fontStyle, fontSize));
    }

    public void resetLabels() {
        this.daysLabel.setText(UNDEFINED_TIME_STRING);
        this.hoursLabel.setText(UNDEFINED_TIME_STRING);
        this.minutesLabel.setText(UNDEFINED_TIME_STRING);
        this.secondsLabel.setText(UNDEFINED_TIME_STRING);
    }

    public void updateLabels(long days, long hours, long minutes, long seconds) {
        this.setDays(days);
        this.setHours(hours);
        this.setMinutes(minutes);
        this.setSeconds(seconds);
    }

    public JLabel getDaysLabel() {
        return this.daysLabel;
    }

    public JLabel getHoursLabel() {
        return this.hoursLabel;
    }

    public JLabel getMinutesLabel() {
        return this.minutesLabel;
    }

    public JLabel getSecondsLabel() {
        return this.secondsLabel;
    }

    public void setDays(long days) {
        if (days != this.parseLongOrDefault(this.daysLabel)) {
            this.daysLabel.setText(String.valueOf(days));
        }
    }

    public void setHours(long hours) {
        if (hours != this.parseLongOrDefault(this.hoursLabel)) {
            this.hoursLabel.setText(this.twoDigitFormat.format(hours));
        }
    }

    public void setMinutes(long minutes) {
        if (minutes != this.parseLongOrDefault(this.minutesLabel)) {
            this.minutesLabel.setText(this.twoDigitFormat.format(minutes));
        }
    }

    public void setSeconds(long seconds) {
        if (seconds != this.parseLongOrDefault(this.secondsLabel)) {
            this.secondsLabel.setText(this.twoDigitFormat.format(seconds));
        }
    }

    private long parseLongOrDefault(JLabel label) {
        Long returnValue;
        if (label.getText().equals(UNDEFINED_TIME_STRING)) {
            return -1L;
        }
        try {
            returnValue = Long.parseLong(label.getText());
        }
        catch (NumberFormatException ex) {
            returnValue = -1L;
        }
        return returnValue;
    }
}

