/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.internal;

import com.ur.logging.resources.TextResource;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.polyscope.logging.internal.RobotLogService;
import com.ur.polyscope.logging.internal.TimeCounter;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.EventNotificationService;
import java.awt.Container;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

@Singleton
public class TimeCounterWidget
extends CardPanel
implements RobotStateListener {
    private final RobotLogService lifetimeLogger;
    private TimeCounter timeCounter;

    @Inject
    TimeCounterWidget(ViewContext viewContext, RobotLogService lifetimeLogger, HelpIdAssigner helpIdAssigner) {
        this.lifetimeLogger = lifetimeLogger;
        this.timeCounter = new TimeCounter();
        this.initComponents(viewContext);
        helpIdAssigner.assignHelpId((JComponent)((Object)this), "gui:robot_age");
    }

    public void enter(Object o) {
        super.enter(o);
        EventNotificationService.register((Object)((Object)this), RobotStateListener.class, (Object)((Object)this));
    }

    public Object exit() {
        EventNotificationService.unregister((Object)((Object)this));
        return super.exit();
    }

    private void initComponents(ViewContext viewContext) {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setBorder((Border)new CardBorder(((TextResource)viewContext.getTextResource(TextResource.class)).robotAge()));
        this.add(Box.createRigidArea(new Dimension(400, 80)));
        JPanel timePanel = new JPanel();
        this.timeCounter.initializeLabels(timePanel, viewContext);
        this.add(timePanel);
        this.add(Box.createRigidArea(new Dimension(400, 80)));
    }

    public void updateRobotState(RobotState rs) {
        this.setTime(this.lifetimeLogger.getTimeInMillis(rs.timestamp));
    }

    void setTime(long time) {
        if (time < 0L) {
            this.timeCounter.resetLabels();
        } else {
            this.extractDateFromTimestamp(time /= 1000L);
        }
    }

    private void extractDateFromTimestamp(long time) {
        long s = time / 1000L;
        long m = time / 60000L;
        long h = time / 3600000L;
        long d = time / 86400000L;
        this.timeCounter.updateLabels(d %= 10000L, h %= 24L, m %= 60L, s %= 60L);
    }

    TimeCounter getTimeCounter() {
        return this.timeCounter;
    }
}

