/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.internal.dashboardserver;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ReadOnlyDashboardAction;
import com.ur.dashboardserver.ScriptActionDefinitionParser;
import com.ur.disk.Directories;
import com.ur.polyscope.logging.logtab.myur.AssemblyTask;
import com.ur.polyscope.logging.logtab.myur.AssemblyTaskResult;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentificationProvider;
import com.ur.swing.taskprogress.TaskMonitor;
import com.ur.util.concurrent.Task;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Provider;

@ReadOnlyDashboardAction
public class GenerateSupportReportAction
implements DashBoardAction {
    private static final ScriptActionDefinitionParser GENERATE_SUPPORT_REPORT = new ScriptActionDefinitionParser("generate support file <arg>");
    private final Provider<AssemblyTask> assemblyTaskProvider;
    private final TaskMonitor taskMonitor;
    private RobotIdentificationProvider robotIdentificationProvider;

    @Inject
    public GenerateSupportReportAction(Provider<AssemblyTask> assemblyTaskProvider, TaskMonitor taskMonitor, RobotIdentificationProvider robotIdentificationProvider) {
        this.assemblyTaskProvider = assemblyTaskProvider;
        this.taskMonitor = taskMonitor;
        this.robotIdentificationProvider = robotIdentificationProvider;
    }

    public boolean canHandleMessage(String input) {
        return GENERATE_SUPPORT_REPORT.isMatch(input);
    }

    public String execute(String input) {
        StringBuilder message = new StringBuilder("Error: Failed to create Support Report file ");
        try {
            String destination = this.getTargetLocation(GENERATE_SUPPORT_REPORT.getArgument(0, input));
            String fileName = this.generateSupportFileName();
            if (this.assembleFiles(destination + File.separator + fileName)) {
                message = new StringBuilder("Completed successfully: " + fileName);
            }
        }
        catch (IllegalArgumentException i) {
            message.append(i.getMessage());
        }
        catch (IOException e) {
            message.append(e.getMessage());
        }
        Log.info((String)message.toString());
        return message.toString();
    }

    private String getTargetLocation(String pathArgument) throws IOException {
        File inputTargetFile;
        String inputTargetFilePath = pathArgument;
        if (!pathArgument.startsWith("/")) {
            inputTargetFilePath = Directories.programs().getCanonicalPath() + File.separator + pathArgument;
        }
        if ((inputTargetFile = new File(inputTargetFilePath)).canWrite() && this.isAnAllowedLocation(inputTargetFile.getCanonicalPath())) {
            return inputTargetFile.getCanonicalPath();
        }
        throw new IllegalArgumentException(" invalid target location " + inputTargetFilePath);
    }

    private boolean isAnAllowedLocation(String path) throws IOException {
        return path.startsWith(Directories.programs().getCanonicalPath()) || path.startsWith("/media");
    }

    private boolean assembleFiles(String targetPath) {
        AssemblyTask myUrFileAssemblyTask = (AssemblyTask)((Object)this.assemblyTaskProvider.get());
        myUrFileAssemblyTask.setTargetFile(new File(targetPath));
        myUrFileAssemblyTask.setSilent(true);
        this.taskMonitor.showProgressPercentage(true);
        this.taskMonitor.wait(this.taskMonitor.run((Task)myUrFileAssemblyTask));
        this.taskMonitor.showProgressPercentage(false);
        return myUrFileAssemblyTask.getExportTaskResult().equals((Object)AssemblyTaskResult.COMPLETED_SUCCESSFULY);
    }

    public String generateSupportFileName() {
        String timestamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        String serialNumber = ((RobotIdentification)this.robotIdentificationProvider.get()).getSerialNumber().getSerialNumber();
        return "ur_" + serialNumber + "_" + timestamp + ".zip";
    }
}

