/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.internal.flightrecord;

import com.google.common.net.MediaType;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.AttachmentCollector;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachmentFactory;
import com.ur.polyscope.logging.internal.RobotLogService;
import java.io.File;
import java.io.PrintStream;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class FullRobotLogProbe
implements FlightRecorderProbe {
    private static final String HOME = System.getProperty("user.home");
    private RobotLogService provider;
    private final FlightRecorderAttachmentFactory attachmentFactory;

    @Inject
    FullRobotLogProbe(RobotLogService robotLogService, FlightRecorderAttachmentFactory attachmentFactory) {
        this.provider = robotLogService;
        this.attachmentFactory = attachmentFactory;
    }

    public String getName() {
        return "Log History Probe";
    }

    public void write(PrintStream out) {
    }

    public List<FlightRecorderAttachment> getFileAttachments() {
        this.provider.saveLoglistMessages();
        AttachmentCollector r = new AttachmentCollector(this.attachmentFactory);
        r.collect(new File(HOME, "log_history.txt"), Integer.MAX_VALUE, MediaType.PLAIN_TEXT_UTF_8.toString());
        r.collect(new File(HOME, "log_history.bak"), Integer.MAX_VALUE, MediaType.PLAIN_TEXT_UTF_8.toString());
        return r.asList();
    }

    public void start() {
    }

    public void stop() {
    }

    public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
        return EnumSet.of(FlightRecorderTriggerType.SYSTEM_CONFIGURATION_REPORT);
    }
}

