/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.logtab;

import com.ur.log.logentry.LogEntry;
import com.ur.swing.SwingUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class AttachmentModel {
    private final LinkedHashSet<LogEntry> entriesWithAttachments = new LinkedHashSet();
    private Runnable notify = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final AtomicBoolean running = new AtomicBoolean(false);

    public void setNotify(Runnable notify) {
        this.notify = notify;
    }

    public TimerTask getTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                if (AttachmentModel.this.running.getAndSet(true)) {
                    return;
                }
                try {
                    AttachmentModel.this.updateAttachmentEntries();
                }
                finally {
                    AttachmentModel.this.running.set(false);
                }
            }
        };
    }

    private void updateAttachmentEntries() {
        SwingUtil.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                Iterator entries = AttachmentModel.this.entriesWithAttachments.iterator();
                boolean attachmentChanged = false;
                while (entries.hasNext()) {
                    LogEntry attachmentEntry = (LogEntry)entries.next();
                    boolean couldExport = attachmentEntry.getAttachmentState().canExport();
                    attachmentEntry.getAttachmentState().update();
                    boolean canExport = attachmentEntry.getAttachmentState().canExport();
                    if (couldExport != canExport) {
                        attachmentChanged = true;
                    }
                    if (!attachmentEntry.getAttachmentState().noAttachment()) continue;
                    AttachmentModel.this.entriesWithAttachments.remove(attachmentEntry);
                    attachmentChanged = true;
                }
                if (attachmentChanged) {
                    AttachmentModel.this.notifyParent();
                }
            }
        });
    }

    public void addIfAttachment(LogEntry entry) {
        if (entry.getAttachmentState().hasAttachment()) {
            this.entriesWithAttachments.add(entry);
        }
    }

    public boolean removeEntry(LogEntry entry) {
        return this.entriesWithAttachments.remove(entry);
    }

    public void clear() {
        this.entriesWithAttachments.clear();
    }

    public void replaceElements(List<LogEntry> entries) {
        this.clear();
        for (LogEntry entry : entries) {
            this.addIfAttachment(entry);
        }
        this.notifyParent();
    }

    public int size() {
        return this.entriesWithAttachments.size();
    }

    private void notifyParent() {
        this.notify.run();
    }
}

