/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.logtab;

import com.ur.logging.resources.TextResource;
import com.ur.polyscope.logging.logtab.LogEntryModel;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class ClearLogToolPanel
extends JPanel {
    private TextResource textResource;
    private JButton clear;

    ClearLogToolPanel(final LogEntryModel logService, TextResource textResource, final ConfirmationDialogCreator dialogCreator) {
        this.textResource = textResource;
        this.initComponents();
        logService.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                ClearLogToolPanel.this.clear.setEnabled(!logService.isEmpty());
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ClearLogToolPanel.this.clear.setEnabled(!logService.isEmpty());
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ClearLogToolPanel.this.clear.setEnabled(!logService.isEmpty());
            }
        });
        this.clear.setName("clearLog.logEntires.logTab");
        this.clear.setEnabled(!logService.isEmpty());
        this.clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialogCreator.showConfirmationDialog(ClearLogToolPanel.this.confirmClearLog(), new ConfirmationDialogListener(){

                    public void onOkClicked() {
                        logService.removeAllElements();
                        logService.clearLogs();
                    }
                });
            }
        });
    }

    public ConfirmationMessage confirmClearLog() {
        return new ConfirmationMessage(this.textResource.confirmClearLogTitle(), this.textResource.confirmClearLogExplanation(), this.textResource.confirmClearLogAction(), this.textResource.cancelConfirmation());
    }

    private void initComponents() {
        this.clear = new JButton();
        this.setLayout(new FlowLayout(2, 0, 0));
        this.clear.setText(this.textResource.clear());
        this.add(this.clear);
    }
}

