/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.logtab;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.react.Recipe;
import com.ur.log.LogTab;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageListener;
import com.ur.logging.resources.LoggingImageResource;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.Joint;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.logging.internal.JointModes;
import com.ur.polyscope.logging.logtab.ClearLogToolPanel;
import com.ur.polyscope.logging.logtab.LogEntryModel;
import com.ur.polyscope.logging.logtab.myur.AssembleMyURDataAction;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotJointCurrent;
import com.ur.swing.BindingRegistration;
import com.ur.swing.BindingRegistrationWasClosed;
import com.ur.swing.CardPanel;
import com.ur.swing.GuiUtilities;
import com.ur.swing.SwingUtil;
import com.ur.swing.URFingerDragScrollMouseListener;
import com.ur.swing.units.Units;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import java.awt.Component;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

@Singleton
public class InnerLogTab
extends CardPanel
implements LogTab,
RobotStateListener {
    public static final int FILLER_COUNT = 1;
    public static final String LOG_ENTRIES = "logEntries.logTab";
    public static final String INFORMATION_LOG_SELECTOR = "informationSelector.logEntries.logTab";
    public static final String WARNING_LOG_SELECTOR = "warningSelector.logEntries.logTab";
    public static final String ERROR_LOG_SELECTOR = "errorSelector.logEntries.logTab";
    public static final String ATTACHMENT_LOG_SELECTOR = "attachmentSelector.logEntries.logTab";
    public static final String CLEAR_LOG = "clearLog.logEntires.logTab";
    public static final String LOG_SCREEN = "logScreen.HeaderMenu";
    public static final String EXPORT_BUTTON = "exportButton.logEntries.logTab";
    public static final String MYUR_BUTOTN = "myURButton.logTab";
    private static final String DATE_AND_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final int ARBITRARY_TOLERANCE_FOR_LOG_FOLLOW_MODE = 50;
    private static final int BUFFER_SIZE = 20;
    private final MenuListener menuListener = new ClosePopupWhenMenuSelected();
    private final DecimalFormat yyy_xFormat = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"###0.0");
    private final DecimalFormat f = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#0.0");
    private final DecimalFormat kf = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#0");
    private final float[] powerConsumptionBuffer = new float[20];
    private final EventManager eventManager;
    private final RobotJointCurrent robotJointCurrent;
    protected LogEntryModel robotLogModel;
    protected AssembleMyURDataAction assembleMyURDataAction;
    protected BindingRegistrationWasClosed informNoClose = BindingRegistrationWasClosed.NULL_REGISTRATION_WAS_CLOSED;
    LayoutStrategy layoutStrategy;
    ClearLogToolPanel clearLogToolPanel;
    JLabel controllerTempLabel;
    JLabel controllerTempTextLabel;
    JLabel controllerTempUnitLabel;
    Box.Filler filler1;
    Box.Filler filler2;
    Box.Filler filler3;
    JToggleButton filterErrors;
    JToggleButton filterWarning;
    JToggleButton filterInformation;
    JToggleButton filterAttachment;
    JTextField filterTextField;
    JPanel filterPanel;
    JLabel ioCurrentLabel;
    JLabel ioCurrentTextLabel;
    JLabel ioCurrentunitLabel;
    JLabel jLabel2;
    JLabel jLabel24;
    JLabel jLabel25;
    JLabel jLabel26;
    JLabel jLabel27;
    JLabel jLabel28;
    JPanel jPanel1;
    JPanel jPanel10;
    JPanel jPanel11;
    JPanel jPanel4;
    JPanel jPanel5;
    JPanel jPanel53;
    JPanel jPanel57;
    JPanel jPanel6;
    JPanel jPanel7;
    JPanel jPanel71;
    JPanel jPanel72;
    JPanel jPanel73;
    JPanel jPanel74;
    JPanel jPanel75;
    JPanel jPanel76;
    JPanel jPanel77;
    JPanel jPanel78;
    JPanel jPanel79;
    JPanel jPanel8;
    JPanel jPanel80;
    JPanel jPanel81;
    JPanel jPanel82;
    JPanel jPanel83;
    JPanel jPanel9;
    JScrollPane logEntriesScroll;
    JPanel logControlsPanel;
    JList logEntries;
    JPanel logPanel;
    JLabel robotCurrentLabel;
    JLabel robotCurrentTextLabel;
    JLabel robotCurrentUnitLabel;
    JPanel robotHealthPanel;
    JProgressBar robotJoint0CurrentProgressBar;
    JProgressBar robotJoint0MotorTempProgressBar;
    JLabel robotJoint0State;
    JLabel robotJoint0VoltageLabel;
    JProgressBar robotJoint1CurrentProgressBar;
    JProgressBar robotJoint1MotorTempProgressBar;
    JLabel robotJoint1State;
    JLabel robotJoint1VoltageLabel;
    JProgressBar robotJoint2CurrentProgressBar;
    JProgressBar robotJoint2MotorTempProgressBar;
    JLabel robotJoint2State;
    JLabel robotJoint2VoltageLabel;
    JProgressBar robotJoint3CurrentProgressBar;
    JProgressBar robotJoint3MotorTempProgressBar;
    JLabel robotJoint3State;
    JLabel robotJoint3VoltageLabel;
    JProgressBar robotJoint4CurrentProgressBar;
    JProgressBar robotJoint4MotorTempProgressBar;
    JLabel robotJoint4State;
    JLabel robotJoint4VoltageLabel;
    JProgressBar robotJoint5CurrentProgressBar;
    JProgressBar robotJoint5MotorTempProgressBar;
    JLabel robotJoint5State;
    JLabel robotJoint5VoltageLabel;
    JLabel robotPowerLabel;
    JLabel robotPowerUnitLabel;
    JLabel robotVoltageLabel;
    JLabel robotVoltageTextLabel;
    JLabel robotVoltageUnitLabel;
    JLabel robotpowerTextLabel;
    JPanel temperaturePanel;
    JLabel toolCurrentLabel;
    JLabel toolCurrentTextLabel;
    JLabel toolCurrentUnitLabel;
    JLabel uptimeLabel;
    JButton assembleMyURDataButton;
    private double powerConsumptionSum = 0.0;
    private int powerConsumptionBufferPointer = 0;
    private Subscription robotStateSubscription = Subscription.NULL;

    @Inject
    InnerLogTab(RobotConfigurationProvider robot, LogEntryModel logService, EventManager eventManager, LayoutStrategy layoutStrategy, @Source(value=Arm.class) Recipe<Arm> armRecipe, AssembleMyURDataAction assembleMyURDataAction) {
        this.robotJointCurrent = robot.getRobotJointCurrent();
        this.layoutStrategy = layoutStrategy;
        this.robotLogModel = logService;
        this.eventManager = eventManager;
        this.assembleMyURDataAction = assembleMyURDataAction;
        layoutStrategy.applyLayoutTo(this);
        for (int i = 0; i < this.powerConsumptionBuffer.length; ++i) {
            this.powerConsumptionBuffer[i] = 0.0f;
        }
        eventManager.addStrongListener(RobotMessageListener.class, (Object)this.robotLogModel);
        layoutStrategy.initHelpIds(this);
        GuiUtilities.setScrollbarWidthLarge((JScrollPane)this.logEntriesScroll);
        this.logEntries.setName(LOG_ENTRIES);
        this.logEntries.setModel(this.robotLogModel);
        this.logEntries.getModel().addListDataListener(new FollowLogEntriesMode());
        new URFingerDragScrollMouseListener((Component)this.logEntries);
        this.filterInformation.setName(INFORMATION_LOG_SELECTOR);
        this.filterWarning.setName(WARNING_LOG_SELECTOR);
        this.filterErrors.setName(ERROR_LOG_SELECTOR);
        this.filterAttachment.setName(ATTACHMENT_LOG_SELECTOR);
        this.uptimeLabel.setIcon(LoggingImageResource.dateAndTime());
        this.robotLogModel.startTimers();
        Log.debug((String)"Created Log Tab");
        armRecipe.executeOnUIThread().forEach(arm -> {
            new JointVisualMetrics(arm.getJoint(JointType.fromJointNumber((int)0)), this.robotJoint0State, this.robotJoint0VoltageLabel, this.robotJoint0CurrentProgressBar, this.robotJoint0MotorTempProgressBar);
            new JointVisualMetrics(arm.getJoint(JointType.fromJointNumber((int)1)), this.robotJoint1State, this.robotJoint1VoltageLabel, this.robotJoint1CurrentProgressBar, this.robotJoint1MotorTempProgressBar);
            new JointVisualMetrics(arm.getJoint(JointType.fromJointNumber((int)2)), this.robotJoint2State, this.robotJoint2VoltageLabel, this.robotJoint2CurrentProgressBar, this.robotJoint2MotorTempProgressBar);
            new JointVisualMetrics(arm.getJoint(JointType.fromJointNumber((int)3)), this.robotJoint3State, this.robotJoint3VoltageLabel, this.robotJoint3CurrentProgressBar, this.robotJoint3MotorTempProgressBar);
            new JointVisualMetrics(arm.getJoint(JointType.fromJointNumber((int)4)), this.robotJoint4State, this.robotJoint4VoltageLabel, this.robotJoint4CurrentProgressBar, this.robotJoint4MotorTempProgressBar);
            new JointVisualMetrics(arm.getJoint(JointType.fromJointNumber((int)5)), this.robotJoint5State, this.robotJoint5VoltageLabel, this.robotJoint5CurrentProgressBar, this.robotJoint5MotorTempProgressBar);
        });
    }

    boolean isFilterAttachmentSelected() {
        return this.filterAttachment.isSelected();
    }

    public void enter(Object o) {
        super.enter(o);
        this.layoutStrategy.filterMessages(this);
        this.robotStateSubscription = this.eventManager.addStrongListener(RobotStateListener.class, (Object)this);
    }

    public void setSelection(RobotMessage rm) {
        int index = this.robotLogModel.findIndex(rm);
        if (index != -1) {
            this.logEntries.setSelectedIndex(index);
        }
    }

    public Object exit() {
        this.robotStateSubscription.dispose();
        this.closeInformationWindow();
        return super.exit();
    }

    public void updateRobotState(RobotState robotState) {
        this.powerConsumptionFilterAdd(robotState.robotVoltage48V * robotState.robotCurrent);
        this.uptimeLabel.setText(this.getCurrentTime());
        this.robotVoltageLabel.setText("" + this.f.format(robotState.robotVoltage48V));
        this.robotCurrentLabel.setText("" + this.f.format(robotState.robotCurrent));
        this.robotPowerLabel.setText("" + this.kf.format(this.powerConsumptionFilterGetAvg()));
        this.ioCurrentLabel.setText("" + this.f.format(robotState.masterIOCurrent));
        this.toolCurrentLabel.setText("" + this.kf.format(1000.0f * robotState.toolCurrent));
        this.controllerTempLabel.setText(Units.convert_from_celsius((double)robotState.masterTemperature));
    }

    private String getCurrentTime() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(DATE_AND_TIME_FORMAT));
    }

    private void powerConsumptionFilterAdd(float powerNow) {
        this.powerConsumptionSum -= (double)this.powerConsumptionBuffer[this.powerConsumptionBufferPointer];
        this.powerConsumptionBuffer[this.powerConsumptionBufferPointer] = powerNow;
        this.powerConsumptionSum += (double)powerNow;
        ++this.powerConsumptionBufferPointer;
        if (this.powerConsumptionBufferPointer == this.powerConsumptionBuffer.length) {
            this.powerConsumptionBufferPointer = 0;
        }
    }

    private float powerConsumptionFilterGetAvg() {
        return (float)(this.powerConsumptionSum / (double)this.powerConsumptionBuffer.length);
    }

    public double getJointMaxCurrent(int j) {
        return this.robotJointCurrent.getJointMaxCurrent(j);
    }

    protected void filterTextChanged() {
        this.robotLogModel.setFilterText(this.filterTextField.getText());
        this.layoutStrategy.filterMessages(this);
    }

    protected void filterInformationStateChanged(ChangeEvent evt) {
        this.layoutStrategy.filterMessages(this);
    }

    protected void filterErrorsStateChanged(ChangeEvent evt) {
        this.layoutStrategy.filterMessages(this);
    }

    protected void filterWarningStateChanged(ChangeEvent evt) {
        this.layoutStrategy.filterMessages(this);
    }

    protected void filterAttachmentStateChanged(ChangeEvent evt) {
        this.layoutStrategy.filterAttachments(this);
    }

    private void closeInformationWindow() {
        if (!this.informNoClose.equals(BindingRegistration.NULL_REGISTRATION)) {
            this.informNoClose.removeRegistration();
            this.informNoClose = BindingRegistrationWasClosed.NULL_REGISTRATION_WAS_CLOSED;
        }
    }

    public MenuListener getMenuListener() {
        return this.menuListener;
    }

    private class ClosePopupWhenMenuSelected
    implements MenuListener {
        private ClosePopupWhenMenuSelected() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            InnerLogTab.this.closeInformationWindow();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }

    public class FollowLogEntriesMode
    implements ListDataListener {
        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.updateList();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.updateList();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            InnerLogTab.this.layoutStrategy.attachmentStatesUpdated();
            this.setFilterAttachmentEnabled();
        }

        private void updateList() {
            this.showLastItem();
            this.setFilterAttachmentEnabled();
        }

        private void showLastItem() {
            JScrollBar scrollBar = InnerLogTab.this.logEntriesScroll.getVerticalScrollBar();
            if (this.logInFollowMode(scrollBar)) {
                scrollBar.setValue(Integer.MAX_VALUE);
            }
        }

        private boolean logInFollowMode(JScrollBar scrollBar) {
            return scrollBar.getValue() + scrollBar.getModel().getExtent() > scrollBar.getMaximum() - 50;
        }

        private void setFilterAttachmentEnabled() {
            SwingUtil.invokeLater(() -> {
                if (InnerLogTab.this.robotLogModel.doAnyMessagesHaveAttachments()) {
                    InnerLogTab.this.filterAttachment.setEnabled(true);
                } else {
                    InnerLogTab.this.filterAttachment.setEnabled(false);
                    InnerLogTab.this.filterAttachment.setSelected(false);
                    InnerLogTab.this.layoutStrategy.filterAttachments(InnerLogTab.this);
                }
            });
        }
    }

    private class JointVisualMetrics {
        JointVisualMetrics(Joint joint, JLabel stateLabel, JLabel voltageLabel, JProgressBar currentProgressBar, JProgressBar motorTempProgressBar) {
            stateLabel.setText(JointModes.getString(joint.getMode()));
            voltageLabel.setText(InnerLogTab.this.yyy_xFormat.format(joint.getVoltage()) + " " + Units.getText().unitV());
            this.updateCurrentOfJoint(joint, currentProgressBar);
            this.updateTemperatureOfJoint(joint, motorTempProgressBar);
        }

        private void updateCurrentOfJoint(Joint joint, JProgressBar robotJointCurrentProgressBar) {
            robotJointCurrentProgressBar.setString(InnerLogTab.this.yyy_xFormat.format(Math.abs(joint.getCurrent())) + Units.getText().unitA());
            double jointMaxCurrent = InnerLogTab.this.getJointMaxCurrent(joint.getJointType().getJointNumber());
            robotJointCurrentProgressBar.setValue((int)((double)Math.abs(joint.getCurrent()) * (100.0 / jointMaxCurrent)));
        }

        private void updateTemperatureOfJoint(Joint joint, JProgressBar robotJointTemperature) {
            robotJointTemperature.setValue((int)joint.getMotorTemperature());
            if ((double)joint.getMotorTemperature() > -30.0) {
                robotJointTemperature.setString(Units.convert_from_celsius((double)joint.getMotorTemperature()) + " " + Units.getText().unitDegC());
            } else {
                robotJointTemperature.setString("- NC -");
            }
        }
    }

    public static interface LayoutStrategy {
        public void applyLayoutTo(InnerLogTab var1);

        public void filterMessages(InnerLogTab var1);

        public void filterAttachments(InnerLogTab var1);

        public void initHelpIds(InnerLogTab var1);

        public void attachmentStatesUpdated();
    }
}

