/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.logtab;

import com.ur.log.logentry.LogEntry;
import com.ur.logging.resources.LoggingImageResource;
import com.ur.polyscope.logging.logtab.InnerLogTab;
import com.ur.swing.TableUtils;
import com.ur.util.swing.TwoIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;

public class LogEntriesCellRenderer
extends DefaultListCellRenderer {
    private final InnerLogTab tab;
    private TwoIcons twoIcons = new TwoIcons();

    LogEntriesCellRenderer(InnerLogTab tab, Font font) {
        this.tab = tab;
        this.setOpaque(true);
        this.setLayout(new BoxLayout(this, 0));
        this.setFont(font);
        this.setIcon((Icon)this.twoIcons);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        LogEntry entry = (LogEntry)value;
        if (entry.isValid()) {
            this.twoIcons.setLeftIcon(this.getEntryIcon(entry));
            this.twoIcons.setRightIcon(this.getAttachmentIcon(entry));
            this.setText(entry.getDisplay(false));
            this.setBackground(TableUtils.getRowColor((int)index, (boolean)isSelected));
            this.setTextColor(entry);
            this.setVisible(entry.hasDetails());
        } else {
            this.twoIcons.setLeftIcon(null);
            this.twoIcons.setRightIcon(null);
            this.setText("   ");
            this.setBackground(TableUtils.ODD_ROW_COLOR);
            this.setVisible(false);
        }
        return this;
    }

    private Icon getAttachmentIcon(LogEntry logEntry) {
        return logEntry.getAttachmentState().hasAttachment() ? LoggingImageResource.logReportAvailable() : LoggingImageResource.blank();
    }

    private Icon getEntryIcon(LogEntry entry) {
        return this.getIconFrom(entry);
    }

    private void setTextColor(LogEntry entry) {
        this.setForeground(this.tab.isFilterAttachmentSelected() && entry.getAttachmentState().noAttachment() ? Color.GRAY : Color.BLACK);
    }

    private Icon getIconFrom(LogEntry entry) {
        switch (entry.getWarningLevel()) {
            case CRITICAL_FAULT: 
            case FAULT: {
                return LoggingImageResource.formFault();
            }
            case DEVL_FAULT: {
                return LoggingImageResource.formDeveloperFault();
            }
            case VIOLATION: {
                return LoggingImageResource.formError();
            }
            case DEVL_VIOLATION: {
                return LoggingImageResource.formDeveloperError();
            }
            case WARNING: {
                return LoggingImageResource.formWarning();
            }
            case DEVL_WARNING: {
                return LoggingImageResource.formDeveloperWarning();
            }
            case INFO: {
                return LoggingImageResource.formInformation();
            }
            case DEVL_INFO: {
                return LoggingImageResource.formDeveloperInfo();
            }
            case DEBUG: 
            case DEVL_DEBUG: {
                return LoggingImageResource.formDeveloperDebug();
            }
        }
        throw new IllegalStateException("Unknown warning level");
    }
}

