/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.logtab;

import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.log.SuggestionProvider;
import com.ur.log.logentry.LogEntry;
import com.ur.log.logentry.LogEntryNull;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageListener;
import com.ur.logging.histogram.LifetimeLogger;
import com.ur.polyscope.logging.internal.LogSettings;
import com.ur.polyscope.logging.logtab.AttachmentModel;
import com.ur.swing.SwingUtil;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.constants.errorcodes.ReportLevel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import javax.swing.DefaultListModel;

class LogEntryModel
extends DefaultListModel
implements RobotMessageListener {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private final LifetimeLogger lifetimeLogger;
    private final Map<RobotMessageType, SuggestionProvider> suggestionProviderMap;
    private final LogSettings settings;
    private final ConcurrentLinkedQueue<LogEntry> robotMessagesQueue = new ConcurrentLinkedQueue();
    private UpdateModelTask updateModelTask = new UpdateModelTask();
    private boolean information;
    private boolean warning;
    private boolean error = true;
    private String filterText = "";
    private final AttachmentModel attachmentModel;

    @Inject
    LogEntryModel(LifetimeLogger lifetimeLogger, Map<RobotMessageType, SuggestionProvider> suggestionProviderMap, LogSettings settings, AttachmentModel attachmentModel) {
        this.lifetimeLogger = lifetimeLogger;
        this.suggestionProviderMap = suggestionProviderMap;
        this.settings = settings;
        this.attachmentModel = attachmentModel;
        this.attachmentModel.setNotify(new Runnable(){

            @Override
            public void run() {
                SwingUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LogEntryModel.this.fireContentsChanged(LogEntryModel.this, 0, LogEntryModel.this.getSize());
                    }
                });
            }
        });
    }

    void startTimers() {
        Timer updateModelTimer = new Timer("LogEntryModel-update-timer");
        Timer updateAttachmentsTimer = new Timer("LogEntryModel-attachments-timer");
        this.updateModelTask = new UpdateModelTask();
        updateModelTimer.schedule((TimerTask)this.updateModelTask, 0L, 200L);
        updateAttachmentsTimer.schedule(this.attachmentModel.getTimerTask(), 100L, 200L);
    }

    void setFilterText(String filterText) {
        this.filterText = filterText;
    }

    public void handleRobotMessage(RobotMessage robotMessage) {
        LogEntry message = this.getParseMessage(robotMessage);
        if (message != null && this.isMessageToBeCached(message)) {
            this.robotMessagesQueue.add(message);
            this.updateModelTask.markDirty();
        }
    }

    void forceUpdateModel() {
        this.updateModelTask.markDirty();
        this.updateModelTask.run();
        SwingUtil.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private void fitRobotMessageQueueSizeToSettings() {
        ArrayList<LogEntry> logEntriesToRemove = new ArrayList<LogEntry>();
        while (this.robotMessagesQueue.size() > this.settings.lengthOfLogInMemoryBeforePersist()) {
            logEntriesToRemove.add(this.robotMessagesQueue.poll());
        }
        for (LogEntry logEntry : logEntriesToRemove) {
            this.removeElement(logEntry);
            this.attachmentModel.removeEntry(logEntry);
        }
    }

    private boolean isMessageToBeCached(LogEntry message) {
        return this.settings.showDeveloperInformation() || this.isNonDevelopementInfo(message);
    }

    private boolean isNonDevelopementInfo(LogEntry message) {
        return message.getWarningLevel().getId() <= ReportLevel.DEVL_DEBUG.getId();
    }

    private LogEntry getParseMessage(RobotMessage robotMessage) {
        if (this.doNotGenereateLogLine(robotMessage)) {
            return null;
        }
        String technicalTime = this.getTechnicalTime(robotMessage);
        String friendlyTime = new SimpleDateFormat(DATE_FORMAT).format(new Date());
        LogEntry entry = new LogEntry(robotMessage, friendlyTime, technicalTime);
        entry.setSuggestion(this.getSuggestion(robotMessage));
        LifetimeLogger.addLogLine(entry.export());
        return entry;
    }

    private boolean doNotGenereateLogLine(RobotMessage robotMessage) {
        return this.isInkognito(robotMessage) || this.isLabelOrFirmwareUpdate(robotMessage);
    }

    private boolean isInkognito(RobotMessage robotMessage) {
        return StringUtils.containsWord((String)robotMessage.toString(), (String)"inkognito");
    }

    private boolean isLabelOrFirmwareUpdate(RobotMessage robotMessage) {
        return EqualsUtil.equalsOneOf((Object)robotMessage.type, (Object[])new RobotMessageType[]{RobotMessageType.PROGRAM_LABEL, RobotMessageType.FIRMWARE_UPDATE_STATUS, RobotMessageType.PROGRAM_LABEL_THREADS});
    }

    private String getSuggestion(RobotMessage robotMessage) {
        SuggestionProvider suggestionProvider = this.suggestionProviderMap.get(robotMessage.type);
        return suggestionProvider == null ? "" : suggestionProvider.getSuggestion(robotMessage);
    }

    protected String getTechnicalTime(RobotMessage robotMessage) {
        return LifetimeLogger.getTimeString(this.lifetimeLogger.controllerTimestampToLifetimeTimestamp(robotMessage.timestamp));
    }

    private boolean isMessageToBeShown(LogEntry message) {
        boolean shouldShowBasedOnLevel;
        if (message == null) {
            return false;
        }
        boolean bl = shouldShowBasedOnLevel = this.filter(message) != null;
        if (StringUtils.isNullOrEmpty((String)this.filterText)) {
            return shouldShowBasedOnLevel;
        }
        return shouldShowBasedOnLevel && message.toString().toLowerCase().contains(this.filterText.toLowerCase());
    }

    int findIndex(LogEntry logEntry) {
        if (logEntry != null) {
            int selectedMessageHashCode = logEntry.hashCode();
            int size = this.getSize();
            for (int i = 0; i < size; ++i) {
                LogEntry nextLogEntry = this.getLogEntry(i);
                if (nextLogEntry == null || nextLogEntry.hashCode() != selectedMessageHashCode) continue;
                return i;
            }
        }
        return -1;
    }

    int findIndex(RobotMessage message) {
        for (int i = 0; i < this.getSize(); ++i) {
            LogEntry entry = this.getLogEntry(i);
            if (entry == null || message != entry.getMessage()) continue;
            return i;
        }
        return -1;
    }

    boolean doAnyMessagesHaveAttachments() {
        return this.attachmentModel.size() > 0;
    }

    void setFilters(boolean information, boolean warning, boolean error) {
        this.information = information;
        this.warning = warning;
        this.error = error;
        this.fitRobotMessageQueueSizeToSettings();
        ArrayList<LogEntry> filteredList = new ArrayList<LogEntry>();
        for (LogEntry logEntry : this.robotMessagesQueue) {
            if (!this.isMessageToBeShown(logEntry)) continue;
            filteredList.add(logEntry);
        }
        LogEntryModel.replaceElements((DefaultListModel)this, filteredList);
        this.attachmentModel.replaceElements(filteredList);
    }

    public static void replaceElements(DefaultListModel listModel, List<?> result) {
        LogEntryModel.replaceElements(listModel, result.toArray(new Object[0]));
    }

    public static void replaceElements(DefaultListModel listModel, Object[] elements) {
        LogEntryModel.removeAll(listModel);
        LogEntryModel.addAll(listModel, elements);
        listModel.addElement(new LogEntryNull());
    }

    public static void removeAll(DefaultListModel listModel) {
        listModel.removeAllElements();
    }

    public static void addAll(DefaultListModel listModel, Object[] elements) {
        for (Object each : elements) {
            listModel.addElement(each);
        }
    }

    private LogEntry filter(LogEntry entry) {
        if (this.information) {
            if (entry.getWarningLevel() == ReportLevel.INFO) {
                return entry;
            }
            boolean developmentInformation = EqualsUtil.equalsOneOf((Object)entry.getWarningLevel(), (Object[])new ReportLevel[]{ReportLevel.DEBUG, ReportLevel.DEVL_DEBUG, ReportLevel.DEVL_INFO});
            if (developmentInformation && this.settings.showDeveloperInformation()) {
                return entry;
            }
        }
        if (this.warning) {
            boolean developmentWarning;
            if (entry.getWarningLevel() == ReportLevel.WARNING) {
                return entry;
            }
            boolean bl = developmentWarning = entry.getWarningLevel() == ReportLevel.DEVL_WARNING;
            if (developmentWarning && this.settings.showDeveloperInformation()) {
                return entry;
            }
        }
        if (this.error) {
            if (EqualsUtil.equalsOneOf((Object)entry.getWarningLevel(), (Object[])new ReportLevel[]{ReportLevel.FAULT, ReportLevel.CRITICAL_FAULT, ReportLevel.VIOLATION})) {
                return entry;
            }
            if (!this.isNonDevelopementInfo(entry) && this.settings.showDeveloperInformation()) {
                return entry;
            }
        }
        return null;
    }

    void clearLogs() {
        this.clear();
        this.tryToClearCachedMessages();
        LifetimeLogger.saveLoglistMessages();
        this.attachmentModel.clear();
    }

    private void tryToClearCachedMessages() {
        this.robotMessagesQueue.clear();
    }

    LogEntry getLogEntry(int i) {
        return (LogEntry)this.get(i);
    }

    private class UpdateModelTask
    extends TimerTask {
        private volatile boolean dirty = true;

        private UpdateModelTask() {
        }

        @Override
        public void run() {
            if (!this.dirty) {
                return;
            }
            SwingUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!UpdateModelTask.this.dirty) {
                        return;
                    }
                    LogEntryModel.this.fitRobotMessageQueueSizeToSettings();
                    if (LogEntryModel.this.getSize() == 0) {
                        for (int i = 0; i < 1; ++i) {
                            LogEntryModel.this.addElement(new LogEntryNull());
                        }
                    }
                    for (LogEntry logEntry : LogEntryModel.this.robotMessagesQueue) {
                        if (!LogEntryModel.this.isMessageToBeShown(logEntry) || LogEntryModel.this.contains(logEntry)) continue;
                        LogEntryModel.this.add(LogEntryModel.this.getSize() - 1, logEntry);
                        LogEntryModel.this.attachmentModel.addIfAttachment(logEntry);
                    }
                    UpdateModelTask.this.dirty = false;
                }
            });
        }

        void markDirty() {
            this.dirty = true;
        }
    }
}

