/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.logtab;

import com.ur.lang.StringUtils;
import com.ur.log.logentry.LanguagePack;
import com.ur.log.logentry.LogEntry;
import com.ur.log.logentry.LogEntryAttachmentState;
import com.ur.logging.resources.LoggingImageResource;
import com.ur.logging.resources.TextResource;
import com.ur.polyscope.logging.internal.CardLayoutUtil;
import com.ur.polyscope.logging.internal.ExportButtonActionFactory;
import com.ur.polyscope.logging.internal.LogSettings;
import com.ur.polyscope.logging.logtab.ClearLogToolPanel;
import com.ur.polyscope.logging.logtab.InnerLogTab;
import com.ur.polyscope.logging.logtab.LogEntriesCellRenderer;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.DocumentUpdateListener;
import com.ur.swing.FormBuilder;
import com.ur.swing.URFingerDragScrollMouseListener;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.units.Units;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LogTabLayoutStrategy
implements InnerLogTab.LayoutStrategy {
    private static final Color BETWEEN_CARD_COLOR = UIManager.getColor("CardPanel.background");
    public static final String SELECT_LOG_ENTRY = "select";
    public static final String SHOW_DETAILS = "Content";
    public static final String DETAIL_EXPLANATION_LOG = "detail.explanation.logTab";
    private final TextResource textResource;
    private final ViewContext view;
    private final WidgetFactory widgetFactory;
    private final LogSettings settings;
    private final Font logFont;
    private final ExportButtonActionFactory exportButtonActionFactory;
    private final HelpIdAssigner helpIdAssigner;
    private final ConfirmationDialogCreator dialogCreator;
    private MoreInfoSelect logSelection;
    private JLabel explanationLabel;
    private JLabel explanation;
    private JLabel suggestionLabel;
    private JLabel suggestion;
    private JLabel reportGeneratingLabel;
    private InnerLogTab tab;
    private JPanel details;
    private JPanel exportButtonPanel;

    @Inject
    public LogTabLayoutStrategy(ViewContext viewContext, LogSettings settings, ExportButtonActionFactory exportButtonActionFactory, ConfirmationDialogCreator dialogCreator) {
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.view = viewContext;
        this.widgetFactory = viewContext.createWidgetFactory();
        this.settings = settings;
        this.logFont = viewContext.getFontFactory().getRelativeFont(URFontFactory.Typeface.MONOSPACED, URFontFactory.Size.SMALL);
        this.exportButtonActionFactory = exportButtonActionFactory;
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.dialogCreator = dialogCreator;
    }

    @Override
    public void applyLayoutTo(final InnerLogTab tab) {
        this.tab = tab;
        tab.filterInformation = this.widgetFactory.createToggleButton((Action)((Object)new InformationFilterAction()));
        tab.filterWarning = this.widgetFactory.createToggleButton((Action)((Object)new WarningFilterAction()));
        tab.filterErrors = this.widgetFactory.createToggleButton((Action)((Object)new ErrorFilterAction()));
        tab.filterAttachment = this.widgetFactory.createToggleButton((Action)((Object)new AttachmentFilterAction()));
        tab.filterInformation.setSelected(!this.settings.filterInformation());
        tab.filterWarning.setSelected(!this.settings.filterWarnings());
        tab.filterErrors.setSelected(!this.settings.filterErrors());
        tab.filterAttachment.setSelected(!this.settings.filterAttachments());
        tab.filterInformation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogTabLayoutStrategy.this.filterMessages(tab);
            }
        });
        tab.filterWarning.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogTabLayoutStrategy.this.filterMessages(tab);
            }
        });
        tab.filterErrors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogTabLayoutStrategy.this.filterMessages(tab);
            }
        });
        tab.filterAttachment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogTabLayoutStrategy.this.filterAttachments(tab);
            }
        });
        tab.uptimeLabel = this.widgetFactory.createLabel("");
        tab.controllerTempLabel = this.widgetFactory.createLabel(this.textResource.controllerTemp());
        tab.robotVoltageLabel = this.widgetFactory.createLabel(this.textResource.robotVoltage());
        tab.robotCurrentLabel = this.widgetFactory.createLabel(this.textResource.robotCurrent());
        tab.robotPowerLabel = this.widgetFactory.createLabel(this.textResource.robotCurrent());
        tab.ioCurrentLabel = this.widgetFactory.createLabel(this.textResource.ioCurrent());
        tab.toolCurrentLabel = this.widgetFactory.createLabel(this.textResource.toolCurrent());
        tab.robotJoint0State = this.widgetFactory.createLabel("Joint 0 State");
        tab.robotJoint1State = this.widgetFactory.createLabel("Joint 1 State");
        tab.robotJoint2State = this.widgetFactory.createLabel("Joint 2 State");
        tab.robotJoint3State = this.widgetFactory.createLabel("Joint 3 State");
        tab.robotJoint4State = this.widgetFactory.createLabel("Joint 4 State");
        tab.robotJoint5State = this.widgetFactory.createLabel("Joint 5 State");
        tab.robotJoint0VoltageLabel = this.widgetFactory.createLabel("Joint 0 Voltage");
        tab.robotJoint1VoltageLabel = this.widgetFactory.createLabel("Joint 1 Voltage");
        tab.robotJoint2VoltageLabel = this.widgetFactory.createLabel("Joint 2 Voltage");
        tab.robotJoint3VoltageLabel = this.widgetFactory.createLabel("Joint 3 Voltage");
        tab.robotJoint4VoltageLabel = this.widgetFactory.createLabel("Joint 4 Voltage");
        tab.robotJoint5VoltageLabel = this.widgetFactory.createLabel("Joint 5 Voltage");
        tab.robotJoint0CurrentProgressBar = new JProgressBar();
        tab.robotJoint1CurrentProgressBar = new JProgressBar();
        tab.robotJoint2CurrentProgressBar = new JProgressBar();
        tab.robotJoint3CurrentProgressBar = new JProgressBar();
        tab.robotJoint4CurrentProgressBar = new JProgressBar();
        tab.robotJoint5CurrentProgressBar = new JProgressBar();
        tab.robotJoint0MotorTempProgressBar = new JProgressBar();
        tab.robotJoint1MotorTempProgressBar = new JProgressBar();
        tab.robotJoint2MotorTempProgressBar = new JProgressBar();
        tab.robotJoint3MotorTempProgressBar = new JProgressBar();
        tab.robotJoint4MotorTempProgressBar = new JProgressBar();
        tab.robotJoint5MotorTempProgressBar = new JProgressBar();
        JPanel readings = this.view.createFormBuilder().label(this.textResource.controllerTemp(), new FormBuilder.PanelConstraints[0]).component((JComponent)tab.controllerTempLabel, new FormBuilder.PanelConstraints[0]).label(Units.getText().unitDegC(), new FormBuilder.PanelConstraints[0]).end().label(this.textResource.robotVoltage(), new FormBuilder.PanelConstraints[0]).component((JComponent)tab.robotVoltageLabel, new FormBuilder.PanelConstraints[0]).label(Units.getText().unitV(), new FormBuilder.PanelConstraints[0]).end().label(this.textResource.avgRobotPower(), new FormBuilder.PanelConstraints[0]).component((JComponent)tab.robotPowerLabel, new FormBuilder.PanelConstraints[0]).label(Units.getText().unitW(), new FormBuilder.PanelConstraints[0]).end().label(this.textResource.Current(), new FormBuilder.PanelConstraints[0]).component((JComponent)tab.robotCurrentLabel, new FormBuilder.PanelConstraints[0]).label(Units.getText().unitA(), new FormBuilder.PanelConstraints[0]).end().label(this.textResource.ioCurrent(), new FormBuilder.PanelConstraints[0]).component((JComponent)tab.ioCurrentLabel, new FormBuilder.PanelConstraints[0]).label(Units.getText().unitA(), new FormBuilder.PanelConstraints[0]).end().label(this.textResource.toolCurrent(), new FormBuilder.PanelConstraints[0]).component((JComponent)tab.toolCurrentLabel, new FormBuilder.PanelConstraints[0]).label(Units.getText().unitMa(), new FormBuilder.PanelConstraints[0]).end().groupColumns(new int[]{1}).groupColumns(new int[]{2, 3}).getCardPanel(this.textResource.Readings());
        readings.setMinimumSize(new Dimension(350, 0));
        readings.setPreferredSize(new Dimension(350, 0));
        tab.controllerTempLabel.setHorizontalAlignment(11);
        tab.robotVoltageLabel.setHorizontalAlignment(4);
        tab.robotCurrentLabel.setHorizontalAlignment(4);
        tab.robotPowerLabel.setHorizontalAlignment(4);
        tab.ioCurrentLabel.setHorizontalAlignment(4);
        tab.toolCurrentLabel.setHorizontalAlignment(4);
        JPanel joint0 = this.createJointLoadIndicator(tab.robotJoint0CurrentProgressBar, tab.robotJoint0MotorTempProgressBar);
        JPanel joint1 = this.createJointLoadIndicator(tab.robotJoint1CurrentProgressBar, tab.robotJoint1MotorTempProgressBar);
        JPanel joint2 = this.createJointLoadIndicator(tab.robotJoint2CurrentProgressBar, tab.robotJoint2MotorTempProgressBar);
        JPanel joint3 = this.createJointLoadIndicator(tab.robotJoint3CurrentProgressBar, tab.robotJoint3MotorTempProgressBar);
        JPanel joint4 = this.createJointLoadIndicator(tab.robotJoint4CurrentProgressBar, tab.robotJoint4MotorTempProgressBar);
        JPanel joint5 = this.createJointLoadIndicator(tab.robotJoint5CurrentProgressBar, tab.robotJoint5MotorTempProgressBar);
        JLabel jointLabelsImage = new JLabel(LoggingImageResource.robotJoints());
        jointLabelsImage.setBorder(BorderFactory.createEmptyBorder());
        JPanel jointLoad = this.view.createFormBuilder().label(LoggingImageResource.joint0(), this.textResource.joint0Name(), new FormBuilder.PanelConstraints[0]).component((JComponent)tab.robotJoint0State, new FormBuilder.PanelConstraints[0]).component((JComponent)joint0, new FormBuilder.PanelConstraints[0]).component((JComponent)tab.robotJoint0VoltageLabel, new FormBuilder.PanelConstraints[0]).label(jointLabelsImage, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.FILL_ROWS}).end().label(LoggingImageResource.joint1(), this.textResource.joint1Name(), new FormBuilder.PanelConstraints[0]).component((JComponent)tab.robotJoint1State, new FormBuilder.PanelConstraints[0]).component((JComponent)joint1, new FormBuilder.PanelConstraints[0]).component((JComponent)tab.robotJoint1VoltageLabel, new FormBuilder.PanelConstraints[0]).spacer().end().label(LoggingImageResource.joint2(), this.textResource.joint2Name(), new FormBuilder.PanelConstraints[0]).component((JComponent)tab.robotJoint2State, new FormBuilder.PanelConstraints[0]).component((JComponent)joint2, new FormBuilder.PanelConstraints[0]).component((JComponent)tab.robotJoint2VoltageLabel, new FormBuilder.PanelConstraints[0]).spacer().end().label(LoggingImageResource.joint3(), this.textResource.joint3Name(), new FormBuilder.PanelConstraints[0]).component((JComponent)tab.robotJoint3State, new FormBuilder.PanelConstraints[0]).component((JComponent)joint3, new FormBuilder.PanelConstraints[0]).component((JComponent)tab.robotJoint3VoltageLabel, new FormBuilder.PanelConstraints[0]).spacer().end().label(LoggingImageResource.joint4(), this.textResource.joint4Name(), new FormBuilder.PanelConstraints[0]).component((JComponent)tab.robotJoint4State, new FormBuilder.PanelConstraints[0]).component((JComponent)joint4, new FormBuilder.PanelConstraints[0]).component((JComponent)tab.robotJoint4VoltageLabel, new FormBuilder.PanelConstraints[0]).spacer().end().label(LoggingImageResource.joint5(), this.textResource.joint5Name(), new FormBuilder.PanelConstraints[0]).component((JComponent)tab.robotJoint5State, new FormBuilder.PanelConstraints[0]).component((JComponent)joint5, new FormBuilder.PanelConstraints[0]).component((JComponent)tab.robotJoint5VoltageLabel, new FormBuilder.PanelConstraints[0]).spacer().end().groupColumns(new int[]{2, 3}).fixedSizeColumnAndWidthPairs(new int[]{1, 60}).getCardPanel(this.textResource.jointLoad());
        tab.logEntries = this.widgetFactory.createList();
        tab.logEntriesScroll = this.widgetFactory.scrollable((JComponent)tab.logEntries);
        tab.logEntriesScroll.setHorizontalScrollBarPolicy(30);
        this.logSelection = new MoreInfoSelect();
        tab.logEntries.addListSelectionListener(this.logSelection);
        tab.logEntries.setSelectionMode(0);
        tab.logEntriesScroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        tab.logEntriesScroll.setVerticalScrollBarPolicy(22);
        tab.logEntriesScroll.setViewportView(tab.logEntries);
        tab.uptimeLabel.setIconTextGap(3);
        tab.clearLogToolPanel = new ClearLogToolPanel(tab.robotLogModel, this.textResource, this.dialogCreator);
        tab.filler3 = new Box.Filler(new Dimension(16, 0), new Dimension(16, 0), new Dimension(16, Short.MAX_VALUE));
        tab.filterPanel = new JPanel();
        tab.filterPanel.setLayout(new FlowLayout(2, 15, 0));
        tab.filterPanel.add(this.widgetFactory.createLabel(this.textResource.View()));
        if (this.settings.isRunningInDevelopmentMode()) {
            this.createFilterTextField(tab);
            tab.filterPanel.add(tab.filterTextField);
        }
        tab.filterPanel.add(tab.filterInformation);
        tab.filterPanel.add(tab.filterWarning);
        tab.filterPanel.add(tab.filterErrors);
        tab.filterPanel.add(tab.filterAttachment);
        tab.filterPanel.add(new JLabel(LoggingImageResource.blank()));
        tab.filterPanel.add(tab.clearLogToolPanel);
        tab.assembleMyURDataButton = this.widgetFactory.createButton((Action)((Object)tab.assembleMyURDataAction));
        tab.assembleMyURDataButton.setName("myURButton.logTab");
        tab.assembleMyURDataButton.setText(this.textResource.extract());
        tab.logControlsPanel = new JPanel();
        tab.logControlsPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        tab.logControlsPanel.setLayout(new BoxLayout(tab.logControlsPanel, 2));
        tab.logControlsPanel.add(Box.createHorizontalStrut(10));
        tab.logControlsPanel.add(tab.uptimeLabel);
        tab.logControlsPanel.add(Box.createHorizontalGlue());
        tab.logControlsPanel.add(tab.filterPanel);
        tab.logControlsPanel.add(Box.createHorizontalStrut(200));
        tab.logControlsPanel.add(tab.assembleMyURDataButton);
        tab.logControlsPanel.add(Box.createHorizontalStrut(10));
        JPanel detailsContent = this.widgetFactory.verticalPanel(10);
        detailsContent.setOpaque(true);
        detailsContent.setBackground(Color.WHITE);
        detailsContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.explanationLabel = this.widgetFactory.createColumnTitle(this.textResource.explanation());
        this.explanation = this.widgetFactory.createLabel("");
        this.suggestionLabel = this.widgetFactory.createColumnTitle(this.textResource.suggestion());
        this.suggestion = this.widgetFactory.createLabel("");
        this.reportGeneratingLabel = this.widgetFactory.createColumnTitle(this.textResource.reportGenerating());
        this.exportButtonPanel = this.widgetFactory.verticalPanel(10);
        detailsContent.add(this.explanationLabel);
        detailsContent.add(this.explanation);
        this.explanation.setName(DETAIL_EXPLANATION_LOG);
        detailsContent.add(this.widgetFactory.createLabel(""));
        detailsContent.add(this.suggestionLabel);
        detailsContent.add(this.suggestion);
        detailsContent.add(this.reportGeneratingLabel);
        detailsContent.add(this.exportButtonPanel);
        this.suggestion.setVerticalAlignment(1);
        this.explanation.setVerticalAlignment(1);
        new URFingerDragScrollMouseListener((Component)detailsContent);
        JScrollPane detailsScroll = this.widgetFactory.scrollable((JComponent)detailsContent);
        this.details = new JPanel();
        this.details.setPreferredSize(new Dimension(380, 0));
        this.details.setMinimumSize(new Dimension(380, 0));
        this.details.setLayout(new CardLayout());
        this.details.add((Component)new JLabel(HTML.html((String)HTML.center((String)this.textResource.pleaseSelectEntry()))), SELECT_LOG_ENTRY);
        this.details.add((Component)detailsScroll, SHOW_DETAILS);
        JPanel entriesPanel = new JPanel(new BorderLayout());
        JPanel entriesDivider = new JPanel();
        entriesDivider.setBorder(BorderFactory.createEmptyBorder(0, 15, 2, 15));
        entriesDivider.add(new JSeparator(){
            {
                this.setPreferredSize(new Dimension(1200, 2));
            }
        });
        entriesPanel.add((Component)entriesDivider, "North");
        entriesPanel.add((Component)this.details, "East");
        entriesPanel.add((Component)tab.logEntriesScroll, "Center");
        tab.logPanel = new JPanel();
        tab.logPanel.setLayout(new BorderLayout());
        tab.logPanel.add((Component)tab.logControlsPanel, "North");
        tab.logPanel.add((Component)entriesPanel, "Center");
        tab.logPanel.setBorder(BorderFactory.createEmptyBorder());
        this.createCard(this.textResource.dateLog(), tab.logPanel);
        tab.logEntries.setCellRenderer(new LogEntriesCellRenderer(tab, this.logFont));
        tab.robotHealthPanel = new JPanel();
        tab.robotHealthPanel.setLayout(new BorderLayout(5, 5));
        tab.robotHealthPanel.setBackground(BETWEEN_CARD_COLOR);
        tab.robotHealthPanel.add((Component)readings, "West");
        tab.robotHealthPanel.add((Component)jointLoad, "Center");
        tab.setLayout(new BorderLayout(5, 5));
        tab.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, BETWEEN_CARD_COLOR));
        tab.add(tab.robotHealthPanel, "North");
        tab.add(tab.logPanel, "Center");
        tab.setBackground(BETWEEN_CARD_COLOR);
    }

    private void createFilterTextField(final InnerLogTab tab) {
        tab.filterTextField = this.widgetFactory.createTextField();
        tab.filterTextField.setColumns(15);
        tab.filterTextField.getDocument().addDocumentListener((DocumentListener)new DocumentUpdateListener(){

            public void update() {
                tab.filterTextChanged();
            }
        });
    }

    private JPanel createJointLoadIndicator(JProgressBar currentValue, JProgressBar motorTemperature) {
        currentValue.setStringPainted(true);
        currentValue.setFont(this.view.getFontFactory().getRelativeFont(URFontFactory.Size.TINY));
        currentValue.setOpaque(false);
        currentValue.setPreferredSize(new Dimension(150, 15));
        currentValue.setMinimumSize(new Dimension(150, 15));
        motorTemperature.setStringPainted(true);
        motorTemperature.setFont(this.view.getFontFactory().getRelativeFont(URFontFactory.Size.TINY));
        motorTemperature.setOpaque(false);
        motorTemperature.setPreferredSize(new Dimension(150, 15));
        motorTemperature.setMinimumSize(new Dimension(150, 15));
        JPanel result = new JPanel();
        result.setBorder(BorderFactory.createEmptyBorder(2, 40, 2, 40));
        result.add(currentValue);
        result.add(motorTemperature);
        result.setLayout(new GridLayout(2, 1, 1, 1));
        return result;
    }

    private void createCard(String title, JPanel mainSettings) {
        mainSettings.setBorder((Border)new CardBorder(title));
    }

    @Override
    public void filterMessages(InnerLogTab tab) {
        boolean showErrors = !tab.filterErrors.isSelected();
        boolean showWarning = !tab.filterWarning.isSelected();
        boolean showInformation = !tab.filterInformation.isSelected();
        boolean showAttachment = !tab.filterAttachment.isSelected();
        this.settings.setLogFilters(showInformation, showWarning, showErrors, showAttachment);
        int selectedIndex = tab.logEntries.getSelectedIndex();
        LogEntry selectedEntry = null;
        if (selectedIndex >= 0) {
            selectedEntry = tab.robotLogModel.getLogEntry(selectedIndex);
        }
        tab.robotLogModel.setFilters(showInformation, showWarning, showErrors);
        selectedIndex = tab.robotLogModel.findIndex(selectedEntry);
        tab.logEntries.setSelectedIndex(selectedIndex);
        tab.logEntries.ensureIndexIsVisible(selectedIndex);
    }

    @Override
    public void filterAttachments(InnerLogTab tab) {
        boolean showErrors = !tab.filterErrors.isSelected();
        boolean showWarning = !tab.filterWarning.isSelected();
        boolean showInformation = !tab.filterInformation.isSelected();
        boolean showAttachment = !tab.filterAttachment.isSelected();
        this.settings.setLogFilters(showInformation, showWarning, showErrors, showAttachment);
        tab.logEntries.updateUI();
    }

    @Override
    public void initHelpIds(InnerLogTab tab) {
        this.helpIdAssigner.assignHelpId((JComponent)tab.robotHealthPanel, "gui:logtab_health");
        this.helpIdAssigner.assignHelpId((JComponent)tab.logPanel, "gui:logtab_log");
        this.helpIdAssigner.assignHelpId((JComponent)tab.assembleMyURDataButton, "gui:logtab_save_myur");
    }

    @Override
    public void attachmentStatesUpdated() {
        this.logSelection.update();
    }

    public class MoreInfoSelect
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.update();
        }

        public void update() {
            LogEntry entry = (LogEntry)((LogTabLayoutStrategy)LogTabLayoutStrategy.this).tab.logEntries.getSelectedValue();
            ((LogTabLayoutStrategy)LogTabLayoutStrategy.this).tab.informNoClose.removeRegistration();
            this.showExplanationIfOneIsAvailable(entry);
        }

        private void showExplanationIfOneIsAvailable(LogEntry entry) {
            if (entry == null) {
                CardLayoutUtil.flipToCard(LogTabLayoutStrategy.this.details, LogTabLayoutStrategy.SELECT_LOG_ENTRY);
                return;
            }
            if (!entry.isValid()) {
                CardLayoutUtil.flipToCard(LogTabLayoutStrategy.this.details, LogTabLayoutStrategy.SELECT_LOG_ENTRY);
                return;
            }
            String explanationMessage = entry.getFriendlyMessageCodeExplanation();
            String suggestionMessage = entry.getFriendlyMessageCodeSuggestion();
            LogTabLayoutStrategy.this.suggestionLabel.setText(entry.getFriendlyMessageCodeSuggestionLabel(LanguagePack.getTextResource()));
            if (StringUtils.startsAndEndsWith((String)"!", (String)explanationMessage)) {
                explanationMessage = "";
            }
            if (StringUtils.startsAndEndsWith((String)"!", (String)suggestionMessage)) {
                suggestionMessage = entry.getSuggestion();
            }
            boolean hasComments = this.hasSuggestionOrExplanation(explanationMessage, suggestionMessage);
            boolean hasAttachment = entry.getAttachmentState().hasAttachment();
            LogTabLayoutStrategy.this.explanationLabel.setVisible(!StringUtils.isNullOrOnlyWhitespace((String)explanationMessage));
            LogTabLayoutStrategy.this.explanation.setText(HTML.html((String)explanationMessage));
            LogTabLayoutStrategy.this.suggestionLabel.setVisible(!StringUtils.isNullOrOnlyWhitespace((String)suggestionMessage));
            LogTabLayoutStrategy.this.suggestion.setText(HTML.html((String)suggestionMessage));
            this.configureExportComponents(entry);
            CardLayoutUtil.flipToCard(LogTabLayoutStrategy.this.details, hasComments || hasAttachment ? LogTabLayoutStrategy.SHOW_DETAILS : LogTabLayoutStrategy.SELECT_LOG_ENTRY);
        }

        private boolean hasSuggestionOrExplanation(String explanation, String suggestion) {
            return !StringUtils.isNullOrOnlyWhitespace((String)explanation) || !StringUtils.isNullOrOnlyWhitespace((String)suggestion);
        }

        private void configureExportComponents(LogEntry entry) {
            LogTabLayoutStrategy.this.exportButtonPanel.removeAll();
            if (entry.getAttachmentState().hasAttachment()) {
                LogTabLayoutStrategy.this.exportButtonPanel.add(this.createErrorReportExportComponent(entry));
            }
            this.setCanExportVisibility(entry);
        }

        private JComponent createErrorReportExportComponent(LogEntry entry) {
            LogEntryAttachmentState attachmentState = entry.getAttachmentState();
            JPanel exportLine = new JPanel(new FlowLayout(3));
            exportLine.setOpaque(false);
            JButton exportButton = new JButton();
            if (attachmentState.canExport()) {
                Action exportReportAction = LogTabLayoutStrategy.this.exportButtonActionFactory.createExportAttachmentAction(entry.getAttachment());
                exportReportAction.putValue("Name", LogTabLayoutStrategy.this.textResource.exportReport());
                exportButton.setAction(exportReportAction);
            } else {
                Action disabledExportReportAction = LogTabLayoutStrategy.this.exportButtonActionFactory.createDisabledExportAttachmentAction();
                disabledExportReportAction.putValue("Name", LogTabLayoutStrategy.this.textResource.exportReport());
                exportButton.setAction(disabledExportReportAction);
            }
            exportButton.setName("exportButton.logEntries.logTab");
            exportLine.add(exportButton);
            return exportLine;
        }

        private void setCanExportVisibility(LogEntry entry) {
            LogTabLayoutStrategy.this.reportGeneratingLabel.setVisible(entry.getAttachmentState().attachmentPending());
        }
    }

    private class AttachmentFilterAction
    extends AbstractActionDefinition {
        private AttachmentFilterAction() {
            this.putValue("SmallIcon", LoggingImageResource.formAttachment());
            this.putValue("Function", ActionDefinition.Function.INLINE_ACTION);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class ErrorFilterAction
    extends AbstractActionDefinition {
        private ErrorFilterAction() {
            this.putValue("SmallIcon", LoggingImageResource.formError());
            this.putValue("Function", ActionDefinition.Function.INLINE_ACTION);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class WarningFilterAction
    extends AbstractActionDefinition {
        private WarningFilterAction() {
            this.putValue("SmallIcon", LoggingImageResource.formWarning());
            this.putValue("Function", ActionDefinition.Function.INLINE_ACTION);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class InformationFilterAction
    extends AbstractActionDefinition {
        private InformationFilterAction() {
            this.putValue("SmallIcon", LoggingImageResource.formInformation());
            this.putValue("Function", ActionDefinition.Function.INLINE_ACTION);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }
}

