/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.logtab.myur;

import com.ur.logging.resources.TextResource;
import com.ur.polyscope.logging.logtab.myur.AssemblyTaskResult;
import com.ur.swing.SwingUtil;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.MessageDialogCreator;
import com.ur.swing.dialog.MessageDialogType;
import javax.inject.Inject;

public class AssemblyResultMessage
implements Runnable {
    private final MessageDialogCreator messageDialogCreator;
    private final TextResource textResource;
    private AssemblyTaskResult assemblyTaskResult;

    @Inject
    public AssemblyResultMessage(MessageDialogCreator messageDialogCreator, TextResource textResource) {
        this.messageDialogCreator = messageDialogCreator;
        this.textResource = textResource;
    }

    void showExportCompletedMessage(AssemblyTaskResult assemblyTaskResult) {
        this.assemblyTaskResult = assemblyTaskResult;
        SwingUtil.invokeLater((Runnable)this);
    }

    @Override
    public void run() {
        DialogMessage message;
        MessageDialogType messageType;
        switch (this.assemblyTaskResult) {
            case COMPLETED_SUCCESSFULY: {
                messageType = MessageDialogType.MESSAGE;
                message = new DialogMessage(this.textResource.myURDialogTitle(), this.textResource.myURExportResultOk());
                break;
            }
            case COMPLETED_WITH_ERRORS: {
                messageType = MessageDialogType.WARNING;
                message = new DialogMessage(this.textResource.myURDialogTitle(), this.textResource.myURExportResultWithErrors());
                break;
            }
            default: {
                messageType = MessageDialogType.ERROR;
                message = new DialogMessage(this.textResource.myURDialogTitle(), this.textResource.myURExportResultFailed());
            }
        }
        this.messageDialogCreator.showMessageDialog(message, messageType, null);
    }
}

