/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.logging.logtab.myur;

import com.google.common.io.ByteSource;
import com.ur.logging.resources.TextResource;
import com.ur.polyscope.flightrecorder.FlightRecorder;
import com.ur.polyscope.flightrecorder.FlightRecorderReporter;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.ReportDescription;
import com.ur.polyscope.logging.logtab.myur.AssemblyResultMessage;
import com.ur.polyscope.logging.logtab.myur.AssemblyTaskResult;
import com.ur.polyscope.logging.logtab.myur.ByteSourceFlightReportWrapper;
import com.ur.polyscope.persistence.compressed.CompressionFactory;
import com.ur.polyscope.persistence.compressed.CompressionProgressState;
import com.ur.polyscope.persistence.compressed.DeflateProgress;
import com.ur.polyscope.persistence.compressed.Deflater;
import com.ur.polyscope.persistence.compressed.DeflaterConfiguration;
import com.ur.polyscope.persistence.compressed.DeflaterSource;
import com.ur.swing.taskprogress.TaskMonitor;
import com.ur.util.Waiting;
import com.ur.util.concurrent.SequentialTask;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;

public class AssemblyTask
extends SequentialTask {
    private final TaskMonitor taskMonitor;
    private final CompressionFactory compressionFactory;
    private final FlightRecorder flightRecorder;
    private final FlightRecorderReporter flightRecorderReporter;
    private final Provider<AssemblyResultMessage> assemblyResultMessageProvider;
    private File assembledFile;
    private AssemblyTaskResult exportTaskStatus = AssemblyTaskResult.COMPLETED_SUCCESSFULY;
    private boolean isSilent;

    @Inject
    AssemblyTask(TaskMonitor taskMonitor, CompressionFactory compressionFactory, FlightRecorder flightRecorder, FlightRecorderReporter flightRecorderReporter, Provider<AssemblyResultMessage> assemblyResultMessageProvider, TextResource textResource) {
        super(textResource.myURDialogTitle(), 110, false);
        this.taskMonitor = taskMonitor;
        this.compressionFactory = compressionFactory;
        this.flightRecorder = flightRecorder;
        this.flightRecorderReporter = flightRecorderReporter;
        this.assemblyResultMessageProvider = assemblyResultMessageProvider;
    }

    public void run() {
        if (!this.generateConfigurationReport()) {
            this.exportTaskStatus = AssemblyTaskResult.FAILED;
        }
        if (this.exportTaskStatus == AssemblyTaskResult.COMPLETED_SUCCESSFULY) {
            this.taskMonitor.addProgress(10);
            Log.info((String)"Configuration report ready");
            try {
                if (!this.compressAllRecords()) {
                    Log.warning((String)"Files compression failed or timed out");
                    this.exportTaskStatus = AssemblyTaskResult.COMPLETED_WITH_ERRORS;
                }
            }
            catch (FileNotFoundException e) {
                Log.error((String)("Error while trying to compress " + e));
                this.exportTaskStatus = AssemblyTaskResult.FAILED;
            }
        }
        Log.info((String)("Support file export completed with result: " + (Object)((Object)this.exportTaskStatus)));
        if (!this.isSilent) {
            ((AssemblyResultMessage)this.assemblyResultMessageProvider.get()).showExportCompletedMessage(this.exportTaskStatus);
        }
    }

    public AssemblyTaskResult getExportTaskResult() {
        return this.exportTaskStatus;
    }

    private boolean generateConfigurationReport() {
        ReportDescription configurationReport = this.flightRecorder.reportIncident(FlightRecorderTriggerType.SYSTEM_CONFIGURATION_REPORT);
        if (configurationReport == null) {
            return false;
        }
        final Future configurationReportProgress = configurationReport.getReportTask();
        boolean doneInTimeLimit = Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return configurationReportProgress.isDone();
            }
        }, (int)5, (TimeUnit)TimeUnit.MINUTES);
        if (!doneInTimeLimit) {
            Log.error((String)"Timed out creating system configuration report");
            configurationReportProgress.cancel(true);
            return false;
        }
        return this.flightRecorderReporter.getReport(configurationReport.getReportId()) != null;
    }

    private boolean compressAllRecords() throws FileNotFoundException {
        DeflaterConfiguration configuration = this.compressionFactory.getDeflaterConfiguration().setOutputStream((OutputStream)new FileOutputStream(this.assembledFile)).setIsSynchronous(false);
        Deflater deflater = this.compressionFactory.getDeflater(configuration);
        Collection allReports = this.flightRecorderReporter.getAvailableReports();
        ArrayList<DeflaterSource> deflaterSourceList = new ArrayList<DeflaterSource>();
        for (String reportId : allReports) {
            DeflaterSource deflaterSource = this.compressionFactory.getDeflaterSource().setSource((ByteSource)new ByteSourceFlightReportWrapper(this.flightRecorderReporter, reportId)).setTargetFileName(reportId + ".zip").setTargetDirectoryPath(this.assembledFile.getName());
            deflaterSourceList.add(deflaterSource);
        }
        final DeflateProgress progress = this.compressionFactory.compositeDeflateProgress(deflater.appendSources(deflaterSourceList));
        deflater.close();
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){
            private int lastProgressValue = 0;

            public boolean itHappened() {
                int currentPercentComplete = progress.getPercentageComplete();
                if (currentPercentComplete > this.lastProgressValue) {
                    AssemblyTask.this.taskMonitor.addProgress(currentPercentComplete - this.lastProgressValue);
                    this.lastProgressValue = currentPercentComplete;
                }
                return progress.getProgressState() == CompressionProgressState.COMPLETED || progress.getProgressState() == CompressionProgressState.FAILED;
            }
        }, (int)15, (TimeUnit)TimeUnit.MINUTES);
        return progress.getProgressState() == CompressionProgressState.COMPLETED;
    }

    public void setTargetFile(File assembledFile) {
        if (assembledFile != null) {
            this.assembledFile = assembledFile;
        } else {
            Log.warning((String)"Target File should not be null");
        }
    }

    public void setSilent(boolean isSilent) {
        this.isSilent = isSilent;
    }
}

