/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.tool.impl.payload;

import com.ur.injection.HasKey;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;

@HasKey(value="optional-payload")
class OptionalPayload
implements DomainComponent {
    public static final Weight EMPTY_WEIGHT = Weight.from((double)Double.POSITIVE_INFINITY, (Weight.Unit)Weight.Unit.SI);
    public static final ValueConverter CONVERTER = UnitsValueConverterFactory.getWeightConverter();
    private final boolean usePayload;
    private final Weight payload;

    public OptionalPayload() {
        this(true, EMPTY_WEIGHT);
    }

    public OptionalPayload(boolean usePayload, Weight payload) {
        this.usePayload = usePayload;
        this.payload = Double.isInfinite(payload.asDouble()) ? EMPTY_WEIGHT : payload;
    }

    public boolean isEnabled() {
        return this.usePayload();
    }

    public boolean isDefined() {
        return !this.usePayload || this.payload != EMPTY_WEIGHT;
    }

    public void writeScript(ScriptWriter scriptWriter) {
        if (this.usePayload()) {
            scriptWriter.set_payload_mass(this.payload.asDouble());
        }
    }

    public boolean usePayload() {
        return this.usePayload;
    }

    public Weight payloadValue() {
        return this.payload;
    }

    public boolean isPayloadEmpty() {
        return this.payload == EMPTY_WEIGHT;
    }

    public String asValue() {
        if (this.isPayloadEmpty()) {
            return "";
        }
        return CONVERTER.fromModel((Object)this.payload) + " " + CONVERTER.getUnit();
    }

    public String toString() {
        return "{OptionalPayload: {usePayload: " + this.usePayload + ", " + "payloadValue: " + (this.usePayload ? this.payload.toString() : "EMPTY") + "}}";
    }

    public int hashCode() {
        return (this.usePayload ? 23 : 0) + this.payload.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(OptionalPayload.class)) {
            OptionalPayload other = (OptionalPayload)obj;
            return this.usePayload == other.usePayload && this.payload.equals((Object)other.payload);
        }
        return false;
    }

    public OptionalPayload changePayload(Weight payload) {
        return new OptionalPayload(this.usePayload(), payload);
    }

    public OptionalPayload setUsePayload(boolean selected) {
        return new OptionalPayload(selected, this.payloadValue());
    }
}

