/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.tool.impl.payload;

import com.ur.injection.HasKey;
import com.ur.lang.StringUtils;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.tool.impl.TextResource;
import com.ur.polyscope.tool.impl.payload.OptionalPayload;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.validation.PayloadValidation;
import com.ur.swing.validation.ValidationStrategy;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

@HasKey(value="optional-payload")
class OptionalPayloadView
implements ViewComponent {
    private static final String USE_PAYLOAD = "TotalPayload.usePayload";
    private static final String PAYLOAD_VALUE = "TotalPayload.payloadValue";
    private static final boolean CANNOT_BE_EMPTY = false;
    private static final boolean SOFT_VALUE = false;
    private static final boolean HARD_VALUE = true;
    private final TextResource textResource;
    private OptionalPayload node;
    private final JPanel content;
    JCheckBox enablePayload;
    private JComponent label;
    NumberField payloadValue;
    protected ViewComponent.ModifyListener modifyListener;

    @Inject
    public OptionalPayloadView(PayloadValidation payloadValidation, ViewContext viewContext) {
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.label = this.createLabel();
        this.payloadValue = new AllowEmptyNumberField();
        this.payloadValue.setEnabled(false);
        this.payloadValue.setMode(Mode.PositiveNumbers);
        this.payloadValue.setName(PAYLOAD_VALUE);
        this.payloadValue.setErrorValidationStrategy(new ValidationStrategy[]{payloadValidation.getPayloadValidator(true, false)});
        this.payloadValue.setWarningValidationStrategy(new ValidationStrategy[]{payloadValidation.getPayloadValidator(false, false)});
        this.payloadValue.addActionListener((ActionListener)new PayloadUpdate());
        this.content = viewContext.createFormBuilder().component(this.label, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().component((JComponent)this.payloadValue, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().getRow();
        this.content.addPropertyChangeListener("enabled", new EnablePayloadListener());
        this.content.setBorder(BorderFactory.createEmptyBorder());
    }

    private JComponent createLabel() {
        this.enablePayload = new JCheckBox(this.textResource.setTotalPayload());
        this.enablePayload.setFocusable(false);
        this.enablePayload.setName(USE_PAYLOAD);
        this.enablePayload.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OptionalPayloadView.this.setPayloadCheckBoxItemStateChanged();
            }
        });
        return this.enablePayload;
    }

    public void setModifyListener(ViewComponent.ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    public void setDomain(DomainComponent domain) {
        this.node = (OptionalPayload)domain;
        this.enablePayload.setSelected(this.node.usePayload());
        this.payloadValue.setEnabled(this.node.usePayload() && this.label.isEnabled());
        if (this.node.isPayloadEmpty()) {
            this.payloadValue.setText("");
            this.payloadValue.setBackground(DisplayMessageFactory.WARNING_COLOR);
        } else {
            this.payloadValue.setValue((Object)this.node.payloadValue());
        }
    }

    public JComponent asComponent() {
        return this.content;
    }

    private void setPayloadCheckBoxItemStateChanged() {
        this.node = this.node.setUsePayload(this.enablePayload.isSelected());
        if (!this.payloadValue.getText().isEmpty()) {
            Weight payload = (Weight)this.payloadValue.getValue();
            this.node = this.node.changePayload(payload);
        }
        this.modifyListener.onModified((DomainComponent)this.node);
        this.payloadValue.setEnabled(this.enablePayload.isSelected() && this.enablePayload.isEnabled());
    }

    private static class AllowEmptyNumberField
    extends NumberField {
        public AllowEmptyNumberField() {
            super(UnitsValueConverterFactory.getWeightConverter(), true);
        }

        public void setBackground(Color color) {
            if (!this.isEnabled()) {
                color = DisplayMessageFactory.OK_COLOR;
            } else if (this.getDocument() != null && StringUtils.isNullOrOnlyWhitespace((String)this.getText())) {
                color = DisplayMessageFactory.WARNING_COLOR;
            }
            super.setBackground(color);
        }
    }

    private class EnablePayloadListener
    implements PropertyChangeListener {
        private EnablePayloadListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Boolean enabled = (Boolean)propertyChangeEvent.getNewValue();
            OptionalPayloadView.this.label.setEnabled(enabled);
            OptionalPayloadView.this.payloadValue.setEnabled(enabled.booleanValue());
        }
    }

    private class PayloadUpdate
    implements ActionListener {
        private PayloadUpdate() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Weight payload = (Weight)OptionalPayloadView.this.payloadValue.getValue();
            OptionalPayloadView.this.node = OptionalPayloadView.this.node.changePayload(payload);
            if (OptionalPayloadView.this.node.isPayloadEmpty()) {
                this.makePayloadEmpty();
            }
            OptionalPayloadView.this.modifyListener.onModified((DomainComponent)OptionalPayloadView.this.node);
        }

        private void makePayloadEmpty() {
            OptionalPayloadView.this.payloadValue.setText("");
            OptionalPayloadView.this.payloadValue.setBackground(DisplayMessageFactory.WARNING_COLOR);
        }
    }
}

