/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.tool.impl.payload;

import com.ur.injection.HasKey;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.valueobjects.Weight;
import javax.inject.Inject;

@HasKey(value="payload-with-cog")
public class PayloadWithCog
implements DomainComponent {
    public static final Weight DEFAULT_PAYLOAD = Weight.ZERO;
    private final boolean setPayloadValue;
    private final Weight payloadValue;
    private final boolean useTCPasCOG;

    @Inject
    public PayloadWithCog() {
        this(false, DEFAULT_PAYLOAD, false);
    }

    public PayloadWithCog(boolean setPayloadValue, Weight payloadValue, boolean useTCPasCOG) {
        this.setPayloadValue = setPayloadValue;
        this.payloadValue = payloadValue;
        this.useTCPasCOG = useTCPasCOG;
    }

    public boolean isSetPayloadValue() {
        return this.setPayloadValue;
    }

    public Weight getPayloadValue() {
        return this.payloadValue;
    }

    public boolean isUseTCPasCOG() {
        return this.useTCPasCOG;
    }

    public boolean isEnabled() {
        return this.isSetPayloadValue();
    }

    public boolean isDefined() {
        return true;
    }

    public void writeScript(ScriptWriter writer) {
        if (this.isSetPayloadValue()) {
            if (this.isUseTCPasCOG()) {
                writer.set_payload(this.getPayloadValue().asDouble());
            } else {
                writer.set_payload_mass(this.getPayloadValue().asDouble());
            }
        }
    }

    public String toString() {
        return "{Payload: {isSet: " + this.isSetPayloadValue() + ", value: " + this.payloadValue + ", tcpAsCog: " + this.isUseTCPasCOG() + "}}";
    }

    public String asValue() {
        return "" + this.getPayloadValue();
    }

    public int hashCode() {
        return (this.setPayloadValue ? 23 : 0) + (this.useTCPasCOG ? 23 : 0) + this.payloadValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && PayloadWithCog.class.equals(obj.getClass())) {
            PayloadWithCog other = (PayloadWithCog)obj;
            return this.setPayloadValue == other.setPayloadValue && EqualsUtil.equals((double)this.payloadValue.asDouble(), (double)other.payloadValue.asDouble(), (double)1.0E-4) && this.useTCPasCOG == other.useTCPasCOG;
        }
        return false;
    }
}

