/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.tool.impl.payload;

import com.ur.injection.HasKey;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.PersistComponent;
import com.ur.polyscope.tool.impl.payload.PayloadWithCog;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.urcap.api.domain.data.DataModel;

@HasKey(value="payload-with-cog")
public class PayloadWithCogPersistence
implements PersistComponent {
    private static final String PAYLOAD_ATTRIBUTE = "payload";
    private static final String USE_TCP_AS_COG = "tcpAsCog";

    public void serialize(DomainComponent domain, DataModel attributes) {
        PayloadWithCog payloadWithCog = (PayloadWithCog)domain;
        if (payloadWithCog.isSetPayloadValue()) {
            attributes.set(PAYLOAD_ATTRIBUTE, payloadWithCog.getPayloadValue().asDouble());
            attributes.set(USE_TCP_AS_COG, payloadWithCog.isUseTCPasCOG());
        }
    }

    public DomainComponent deserializer(DataModel attributes) {
        if (attributes.isSet(PAYLOAD_ATTRIBUTE)) {
            boolean useTcpAsCog = attributes.get(USE_TCP_AS_COG, true);
            return new PayloadWithCog(true, Weight.from((double)attributes.get(PAYLOAD_ATTRIBUTE, 0.0), (Weight.Unit)Weight.Unit.SI), useTcpAsCog);
        }
        return new PayloadWithCog();
    }
}

