/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.tool.impl.payload;

import com.ur.injection.HasKey;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.tool.impl.TextResource;
import com.ur.polyscope.tool.impl.payload.PayloadWithCog;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.validation.PayloadValidation;
import com.ur.swing.validation.ValidationStrategy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdesktop.swingx.HorizontalLayout;

@HasKey(value="payload-with-cog")
public class PayloadWithCogView
extends JPanel
implements ViewComponent {
    public static final String PAYLOAD_CHECKBOX_ID = "ActionCard.setPayloadCheckboxId";
    public static final String USE_TCP_AS_COG = "ActionCard.useTcpAsCogCheckboxId";
    public static final String PAYLOAD = "payload.PayloadWithCogView";
    private final JPanel content;
    private NumberField payloadTextField;
    private JCheckBox setPayloadCheckBox;
    private JCheckBox useActiveTCPasCOGCheckBox;
    private PayloadWithCog node;
    private ViewComponent.ModifyListener modifyListener;

    @Inject
    public PayloadWithCogView(PayloadValidation payloadValidation, ViewContext viewContext) {
        FormBuilder form = viewContext.createFormBuilder();
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.setPayloadCheckBox = new JCheckBox();
        this.setPayloadCheckBox.setText(textResource.setTotalPayload());
        this.setPayloadCheckBox.setFocusable(false);
        this.setPayloadCheckBox.setName(PAYLOAD_CHECKBOX_ID);
        this.setPayloadCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PayloadWithCogView.this.setPayloadCheckBoxItemStateChanged();
            }
        });
        this.payloadTextField = new NumberField(UnitsValueConverterFactory.getWeightConverter());
        this.payloadTextField.setEnabled(false);
        this.payloadTextField.setPreferredSize(new Dimension(120, 28));
        this.payloadTextField.setMode(Mode.PositiveNumbers);
        this.payloadTextField.setName(PAYLOAD);
        this.payloadTextField.setErrorValidationStrategy(new ValidationStrategy[]{payloadValidation.getPayloadValidator(true, false)});
        this.payloadTextField.setWarningValidationStrategy(new ValidationStrategy[]{payloadValidation.getPayloadValidator(false, false)});
        this.payloadTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PayloadWithCogView.this.payloadUpdate();
            }
        });
        this.useActiveTCPasCOGCheckBox = new JCheckBox();
        this.useActiveTCPasCOGCheckBox.setText(textResource.useActiveTcpAsCog());
        this.useActiveTCPasCOGCheckBox.setFocusable(false);
        this.useActiveTCPasCOGCheckBox.setName(USE_TCP_AS_COG);
        this.useActiveTCPasCOGCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PayloadWithCogView.this.useTcpAsCogChanged();
            }
        });
        JPanel payloadPanel = new JPanel((LayoutManager)new HorizontalLayout(5));
        payloadPanel.setBorder(BorderFactory.createEmptyBorder());
        payloadPanel.add(this.setPayloadCheckBox);
        payloadPanel.add((Component)this.payloadTextField);
        this.content = form.component((JComponent)payloadPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.useActiveTCPasCOGCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.INDENT}).end().getRow();
    }

    public void setModifyListener(ViewComponent.ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    public void setDomain(DomainComponent domain) {
        this.node = (PayloadWithCog)domain;
        this.setPayloadCheckBox.setSelected(this.node.isSetPayloadValue());
        this.payloadTextField.setEnabled(this.node.isSetPayloadValue());
        this.payloadTextField.setValue((Object)this.node.getPayloadValue());
        this.useActiveTCPasCOGCheckBox.setEnabled(this.node.isSetPayloadValue());
        this.useActiveTCPasCOGCheckBox.setSelected(this.node.isUseTCPasCOG());
    }

    private void useTcpAsCogChanged() {
        this.notifyChange(new PayloadWithCog(this.setPayloadCheckBox.isSelected(), this.node.getPayloadValue(), this.useActiveTCPasCOGCheckBox.isSelected()));
    }

    private void setPayloadCheckBoxItemStateChanged() {
        this.notifyChange(new PayloadWithCog(this.setPayloadCheckBox.isSelected(), this.node.getPayloadValue(), this.setPayloadCheckBox.isSelected()));
        this.useActiveTCPasCOGCheckBox.setEnabled(this.setPayloadCheckBox.isSelected());
        this.useActiveTCPasCOGCheckBox.setSelected(this.setPayloadCheckBox.isSelected());
        this.payloadTextField.setEnabled(this.setPayloadCheckBox.isSelected());
    }

    private void notifyChange(PayloadWithCog payloadWithCog) {
        if (!this.node.equals(payloadWithCog)) {
            this.node = payloadWithCog;
            this.modifyListener.onModified((DomainComponent)payloadWithCog);
        }
    }

    private void payloadUpdate() {
        this.notifyChange(new PayloadWithCog(this.node.isSetPayloadValue(), (Weight)this.payloadTextField.getValue(), this.node.isUseTCPasCOG()));
    }

    public JComponent asComponent() {
        return this.content;
    }

    JCheckBox getSetPayloadCheckBox() {
        return this.setPayloadCheckBox;
    }

    JCheckBox getUseActiveTCPasCOGCheckBox() {
        return this.useActiveTCPasCOGCheckBox;
    }

    NumberField getPayloadTextField() {
        return this.payloadTextField;
    }
}

