/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.tool.impl.tcp;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.tcp.FinalizableTCP;
import com.ur.polyscope.tcp.TCPCallback;
import com.ur.polyscope.tcp.TCPInternal;
import com.ur.polyscope.tcp.TCPRef;
import com.ur.polyscope.tcp.TCPService;
import com.ur.polyscope.tcp.owner.TCPReferenceOwnerManager;
import com.ur.polyscope.tcp.urcap.AbstractTCPCallback;
import com.ur.polyscope.tcp.urcap.TCPFactory;
import com.ur.polyscope.tool.impl.tcp.TCPImpl;
import com.ur.urcap.api.domain.tcp.TCP;
import com.ur.urcap.api.domain.value.PoseFactory;
import javax.inject.Inject;

public class TCPFactoryImpl
implements TCPFactory {
    private final PoseFactory poseFactory;
    private final TCPService tcpService;
    private final TCPReferenceOwnerManager referenceOwnerManager;
    static final String XML_ELEMENT_NAME = "TCP";
    static final String TCP_KEY = "key";
    static final String TCP_NAME = "name";

    @Inject
    public TCPFactoryImpl(PoseFactory poseFactory, TCPService tcpService, TCPReferenceOwnerManager referenceOwnerManager) {
        this.poseFactory = poseFactory;
        this.tcpService = tcpService;
        this.referenceOwnerManager = referenceOwnerManager;
    }

    public TCP createTCPWrapperForDelayedTCP(FinalizableTCP tcp, final AbstractTCPCallback callback) {
        TCPImpl tcpWrapper = new TCPImpl((com.ur.polyscope.tcp.TCP)tcp, this.poseFactory);
        callback.setWrapper((TCPInternal)tcpWrapper);
        tcp.setFinalizeCallback(new TCPCallback(){

            public void onFinalize(com.ur.polyscope.tcp.TCP tcp) {
                callback.onFinalize(tcp);
                if (tcp instanceof TCPInternal) {
                    TCPFactoryImpl.this.referenceOwnerManager.registerTCPReferenceOwner((TCPInternal)tcp, ((TCPInternal)tcp).getTCPRef());
                }
            }
        });
        return tcpWrapper;
    }

    public TCP createTCPWrapper(TCPRef tcpRef) {
        TCPImpl tcp = new TCPImpl(tcpRef, this.poseFactory);
        this.referenceOwnerManager.registerTCPReferenceOwner((TCPInternal)tcp, tcpRef);
        return tcp;
    }

    public boolean canRead(String nodeName) {
        return XML_ELEMENT_NAME.equals(nodeName);
    }

    public String readKey(PersistReader reader) {
        return reader.getStringAttribute(TCP_KEY);
    }

    public TCP readValue(PersistReader reader) {
        String name = reader.getStringAttribute(TCP_NAME);
        TCPRef tcpRef = this.tcpService.getTCPRef(name);
        TCP tcpWrapper = this.createTCPWrapper(tcpRef);
        return tcpWrapper;
    }
}

