/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.tool.impl.tcp;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.visualizer.element.VisualizerElement;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.polyscope.visualizer.utils.AxesVisualization;
import com.ur.polyscope.visualizer.utils.Pose6dTransformUtils;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;

public class TCPVisualization
implements VisualizerElement {
    private TransformGroup positionTransformGroup;
    private final Provider<Arm> armProvider;

    @Inject
    public TCPVisualization(@Source(value=Arm.class) Recipe<Arm> armRecipe) {
        this.armProvider = armRecipe.lastProvider();
    }

    public Node getElementNode() {
        this.positionTransformGroup = AxesVisualization.getElementNode();
        return this.positionTransformGroup;
    }

    void setPosition(Pose6d positionInBaseCoordinates) {
        Vector3d o;
        if (positionInBaseCoordinates == null) {
            return;
        }
        Vector3d p = positionInBaseCoordinates.getPos();
        if (this.baseCoordinatesAreNaN(p, o = positionInBaseCoordinates.getRot())) {
            positionInBaseCoordinates = new Pose6d();
        }
        this.positionTransformGroup.setTransform(Pose6dTransformUtils.getTransform3D((Pose6d)positionInBaseCoordinates));
    }

    private boolean baseCoordinatesAreNaN(Vector3d p, Vector3d o) {
        if (Double.isNaN(p.x) || Double.isNaN(p.y) || Double.isNaN(p.z)) {
            return true;
        }
        return Double.isNaN(o.x) || Double.isNaN(o.y) || Double.isNaN(o.z);
    }

    public VisualizerElementType getElementType() {
        return VisualizerElementType.TCP;
    }

    public void update() {
        this.setPosition(((Arm)this.armProvider.get()).getTool().getCartesianInfo().getTool());
    }
}

