/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.tool.impl.tcp;

import com.google.inject.Inject;
import com.ur.lang.StringUtils;
import com.ur.polyscope.tcp.TCPService;
import com.ur.polyscope.tcp.urcap.TCPContributed;
import com.ur.polyscope.tcp.urcap.TcpConfigurationFactory;
import com.ur.polyscope.tool.impl.tcp.NotifyOnInvalidAction;
import com.ur.polyscope.tool.impl.tcp.TCPConfigurationImpl;
import com.ur.urcap.api.contribution.driver.general.tcp.TCPConfiguration;

public class TcpConfigurationFactoryImpl
implements TcpConfigurationFactory {
    private final TCPContributed tcpContributionModel;
    private final TCPService tcpService;

    @Inject
    public TcpConfigurationFactoryImpl(TCPContributed tcpContributionModel, TCPService tcpService) {
        this.tcpContributionModel = tcpContributionModel;
        this.tcpService = tcpService;
    }

    public TCPConfiguration createTCPConfiguration(Class contributor, String additionalIdentification) {
        NotifyOnInvalidAction notifyOnInvalidAction = new NotifyOnInvalidAction();
        String uniqueId = "ID_" + contributor.getName().hashCode() + this.getAdditionalIdentificationString(additionalIdentification);
        return new TCPConfigurationImpl(this.tcpContributionModel, uniqueId, contributor, this.tcpService, notifyOnInvalidAction);
    }

    private String getAdditionalIdentificationString(String additionalIdentification) {
        return StringUtils.isNullOrEmpty((String)additionalIdentification) ? "" : "_" + additionalIdentification;
    }
}

