/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.settings;

import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.polyscope.freedrive.settings.SettingsChangedListener;
import com.ur.polyscope.java.logger.LogFactory;
import java.io.IOException;

public final class FreedriveSettings {
    private static final String LAF_SETTINGS_KEY = "lockAxesEnabled";
    private static final WriteableModuleSettings settings = new WriteableModuleSettings("laf.properties");
    private static SettingsChangedListener settingsChangedListener;

    private FreedriveSettings() {
    }

    public static boolean isLAFEnabled() {
        return settings.properties().getBoolean(LAF_SETTINGS_KEY, true);
    }

    public static void setLAFEnabled(boolean enabled) {
        settings.properties().setProperty(LAF_SETTINGS_KEY, Boolean.toString(enabled));
        try {
            settings.write();
        }
        catch (IOException e) {
            LogFactory.createLogger(FreedriveSettings.class).warn("Unable to persist LAF settings", (Throwable)e);
        }
        if (settingsChangedListener != null) {
            settingsChangedListener.onSettingsChanged(enabled);
        }
    }

    public static void setSettingsChangedListener(SettingsChangedListener settingsChangedListenerParam) {
        settingsChangedListener = settingsChangedListenerParam;
    }
}

