/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation;

import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.InstallationNode;
import com.ur.polyscope.installation.MetaData;
import com.ur.polyscope.installation.OnDispose;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.VersionMetaData;
import com.ur.polyscope.scriptwriter.HackToGenerateScript;
import com.ur.polyscope.scriptwriter.PreambleScript;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class Installation
extends InstallationNode
implements HackToGenerateScript {
    public static final String DEFAULT_FILE_NAME = "default";
    public static final int INSTALLATION_VERSION = 2;
    private Map<Class<?>, InstallationComponent> components = new HashMap(10);
    private Map<Class<?>, MetaData> metaData;

    public Installation(InstallationComponent ... installationComponents) {
        this(new HashSet<InstallationComponent>(Arrays.asList(installationComponents)));
    }

    @Inject
    private Installation(Set<InstallationComponent> installationComponents) {
        for (InstallationComponent each : installationComponents) {
            this.components.put(each.getType(), each);
        }
        this.metaData = new HashMap(10);
        this.metaData.put(PersistanceMetaData.class, new PersistanceMetaData());
        this.metaData.put(VersionMetaData.class, new VersionMetaData());
    }

    @Override
    public String getTypeName() {
        return InstallationNode.provider.installationTabTranslation();
    }

    @Override
    public ScriptWriter generatePreambleScript(ScriptWriter writer) {
        for (InstallationComponent each : this.components.values()) {
            if (!(each instanceof PreambleScript)) continue;
            ((PreambleScript)each).generatePreambleScript(writer, this.getScriptGenerator().getScriptGeneratorLookup());
        }
        return writer;
    }

    public void dispose() {
        for (InstallationComponent each : this.components.values()) {
            if (!(each instanceof OnDispose)) continue;
            ((OnDispose)((Object)each)).dispose();
        }
    }

    public <T extends InstallationComponent> T getComponent(Class<T> componentType) {
        return (T)this.components.get(componentType);
    }

    public void setComponent(InstallationComponent component) {
        this.components.put(component.getType(), component);
    }

    public Iterable<InstallationComponent> getAllComponents() {
        return this.components.values();
    }

    public <T extends MetaData> T getMetaData(Class<T> metaDataType) {
        return (T)this.metaData.get(metaDataType);
    }

    public void setMetaData(MetaData metaData) {
        this.metaData.put(metaData.getType(), metaData);
    }
}

