/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation;

import com.ur.polyscope.installation.InstallationNodeInfo;
import com.ur.polyscope.installation.InstallationNodeProvider;
import com.ur.polyscope.installation.InstallationScriptGenerator;
import com.ur.polyscope.scriptwriter.ScriptError;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.inject.Inject;

public abstract class InstallationNode {
    private final InstallationScriptGenerator installationScriptGenerator = new InstallationScriptGenerator(this);
    protected static InstallationNodeProvider provider;

    @Inject
    public static void setInstallationNodeProvider(InstallationNodeProvider provider) {
        InstallationNode.provider = provider;
    }

    public InstallationScriptGenerator getScriptGenerator() {
        return this.installationScriptGenerator;
    }

    public ScriptError createScriptError(ScriptWriter.ScriptPosition scriptPosition) {
        return new ScriptError(provider.installationNodeTranslation(), this.getTypeName());
    }

    public InstallationNodeInfo getFirstReference(Enumeration<?> elements) {
        return this.getFirstReference(Collections.list(elements));
    }

    public InstallationNodeInfo getFirstReference(List<?> elements) {
        for (Object element : elements) {
            if (!(element instanceof InstallationNodeInfo) || ((InstallationNodeInfo)element).getInstallationNode() != this) continue;
            return (InstallationNodeInfo)element;
        }
        return null;
    }

    public void clearErrors() {
        this.getScriptGenerator().clearScriptError();
    }

    public boolean hasError() {
        return this.getScriptGenerator().hasScriptError();
    }

    public abstract ScriptWriter generatePreambleScript(ScriptWriter var1);

    public abstract String getTypeName();
}

