/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation;

import com.ur.polyscope.installation.IgnoreClearErrors;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationNode;
import com.ur.polyscope.scriptwriter.ScriptError;
import com.ur.polyscope.scriptwriter.ScriptGenerator;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import java.util.ArrayList;
import java.util.List;

public class InstallationScriptGenerator
implements ScriptGenerator {
    private final InstallationNode installationNode;
    private ScriptGeneratorLookup scriptGeneratorLookup = null;
    private ScriptError scriptError = new ScriptError();
    private static List<RobotInstallationNodeRegistration> robotInstallationNodes = new ArrayList<RobotInstallationNodeRegistration>();

    InstallationScriptGenerator(InstallationNode installationNode) {
        this.installationNode = installationNode;
        InstallationScriptGenerator.registerRobotInstallationNode(installationNode);
    }

    public InstallationNode getInstallationNode() {
        return this.installationNode;
    }

    public boolean hasScriptError() {
        return this.scriptError.hasError();
    }

    public void clearScriptError() {
        this.scriptError.clear();
    }

    public ScriptError getScriptError() {
        return this.scriptError;
    }

    public void setScriptError(ScriptWriter.ScriptPosition scriptPosition) {
        this.scriptError = this.installationNode.createScriptError(scriptPosition);
    }

    public void scriptBegin(ScriptWriter writer) {
        this.scriptBegin(this, writer);
    }

    public void scriptEnd(ScriptWriter writer) {
        this.scriptEnd(this, writer);
    }

    public void scriptBegin(ScriptGenerator generator, ScriptWriter writer) {
        if (this.scriptGeneratorLookup != null) {
            this.scriptGeneratorLookup.markBeginScript(generator, writer);
        }
    }

    public void scriptEnd(ScriptGenerator generator, ScriptWriter writer) {
        if (this.scriptGeneratorLookup != null) {
            this.scriptGeneratorLookup.markEndScript(generator, writer);
        }
    }

    public ScriptGeneratorLookup getScriptGeneratorLookup() {
        return this.scriptGeneratorLookup;
    }

    public void setScriptGeneratorLookup(ScriptGeneratorLookup scriptGeneratorLookup) {
        if (scriptGeneratorLookup != null) {
            this.scriptGeneratorLookup = scriptGeneratorLookup;
        }
    }

    public ScriptWriter generateScriptCodeWithRangeEncapsulation(ScriptWriter writer, ScriptGeneratorLookup scriptGeneratorLookup) {
        this.setScriptGeneratorLookup(scriptGeneratorLookup);
        this.scriptBegin(writer);
        this.installationNode.generatePreambleScript(writer);
        this.scriptEnd(writer);
        return writer;
    }

    public static synchronized void clearRuntimeExceptionRegister(Installation oldInstallation) {
        ArrayList<RobotInstallationNodeRegistration> updatedRobotInstallationNodes = new ArrayList<RobotInstallationNodeRegistration>();
        for (RobotInstallationNodeRegistration registration : robotInstallationNodes) {
            if (oldInstallation != null && (registration.node == oldInstallation || registration.node instanceof IgnoreClearErrors)) continue;
            updatedRobotInstallationNodes.add(registration);
            registration.node.clearErrors();
        }
        robotInstallationNodes = updatedRobotInstallationNodes;
    }

    private static synchronized void registerRobotInstallationNode(InstallationNode node) {
        robotInstallationNodes = new ArrayList<RobotInstallationNodeRegistration>();
        RobotInstallationNodeRegistration registration = new RobotInstallationNodeRegistration(node);
        robotInstallationNodes.add(registration);
    }

    static class RobotInstallationNodeRegistration {
        public InstallationNode node;

        RobotInstallationNodeRegistration(InstallationNode node) {
            this.node = node;
        }
    }
}

