/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation;

import com.ur.disk.Directories;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.MetaData;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import java.io.File;

public class PersistanceMetaData
implements MetaData {
    public static final String DEFAULT_FILE_NAME = "default";
    public static final String INSTALLATION_EXTENSION = ".installation";
    private final String directory;
    private String fileName;

    public PersistanceMetaData() {
        this(Directories.programs().getPath(), DEFAULT_FILE_NAME);
    }

    public PersistanceMetaData(File file) {
        this(file.getParentFile().getPath(), PersistanceMetaData.extractFileName(file));
    }

    public PersistanceMetaData(String directory, String fileName) {
        this.directory = directory;
        this.fileName = fileName;
        EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

            public void notify(InstallationStateListener installationStateListener) {
                installationStateListener.installationModified();
            }
        });
    }

    @Override
    public Class<?> getType() {
        return PersistanceMetaData.class;
    }

    public File file() {
        return new File(this.directory, String.valueOf(this.fileName) + INSTALLATION_EXTENSION);
    }

    public File fileWithoutExtension() {
        return new File(this.directory, this.fileName);
    }

    public String fileName() {
        return this.fileName;
    }

    public String directory() {
        return this.directory;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PersistanceMetaData) {
            PersistanceMetaData other = (PersistanceMetaData)obj;
            return EqualsUtil.equals((Object)other.directory, (Object)this.directory) && EqualsUtil.equals((Object)other.fileName, (Object)this.fileName);
        }
        return false;
    }

    public String toString() {
        return "{PersistanceMetaData: {directory:" + this.directory + ", fileName:" + this.fileName + "}}";
    }

    private static String extractFileName(File file) {
        String result = file.getName();
        if (result.endsWith(INSTALLATION_EXTENSION)) {
            result = result.substring(0, result.length() - INSTALLATION_EXTENSION.length());
        }
        return result;
    }
}

