/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.urcap.proxy;

import com.ur.polyscope.installation.urcap.proxy.DriverNodeBuilder;
import com.ur.polyscope.installation.urcap.proxy.PreambleGeneratorService;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.contribution.ViewAPIProvider;
import com.ur.urcap.api.contribution.driver.general.userinput.CustomUserInputConfiguration;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import com.ur.urcap.api.domain.data.DataModel;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.ImageIcon;

public final class DriverNodeFactory {
    private static final Logger LOG = LogFactory.createLogger(DriverNodeFactory.class);
    private static final List<DriverNodeBuilderProxy> instances = new ArrayList<DriverNodeBuilderProxy>();
    private static DriverNodeBuilder realBuilder;

    private DriverNodeFactory() {
    }

    @Inject
    public static void setRealBuilder(DriverNodeBuilder builder) {
        realBuilder = builder;
        if (builder == null) {
            instances.clear();
        } else {
            for (DriverNodeBuilderProxy each : instances) {
                each.wrapped = DriverNodeFactory.realBuilder.copy();
            }
        }
    }

    public static DriverNodeBuilder createBuilder() {
        return new DriverNodeBuilderProxy();
    }

    private static class DoNothingDriverNodeBuilder
    implements DriverNodeBuilder {
        public static final String ASKED_TO_BE_CONFIGURED_BEFORE_SYSTEM_WAS_AVAILABLE = "Driver contribution not available. Installation asked to be configured before system was available";

        private DoNothingDriverNodeBuilder() {
        }

        @Override
        public SwingInstallationNodeView<? extends InstallationNodeContribution> createView(ViewAPIProvider apiProvider, ImageIcon logo) {
            LOG.fatal(ASKED_TO_BE_CONFIGURED_BEFORE_SYSTEM_WAS_AVAILABLE, new Object[0]);
            return null;
        }

        @Override
        public CustomUserInputConfiguration createCustomConfiguration(DataModel model) {
            LOG.fatal(ASKED_TO_BE_CONFIGURED_BEFORE_SYSTEM_WAS_AVAILABLE, new Object[0]);
            return null;
        }

        @Override
        public InstallationNodeContribution createNodeContribution(PreambleGeneratorService service, SwingInstallationNodeView view) {
            LOG.fatal(ASKED_TO_BE_CONFIGURED_BEFORE_SYSTEM_WAS_AVAILABLE, new Object[0]);
            return null;
        }

        @Override
        public DriverNodeBuilder copy() {
            LOG.fatal(ASKED_TO_BE_CONFIGURED_BEFORE_SYSTEM_WAS_AVAILABLE, new Object[0]);
            return this;
        }
    }

    private static class DriverNodeBuilderProxy
    implements DriverNodeBuilder {
        private DriverNodeBuilder wrapped = new DoNothingDriverNodeBuilder();

        public DriverNodeBuilderProxy() {
            if (realBuilder != null) {
                this.wrapped = realBuilder.copy();
            }
            instances.add(this);
        }

        @Override
        public SwingInstallationNodeView<? extends InstallationNodeContribution> createView(ViewAPIProvider apiProvider, ImageIcon logo) {
            return this.wrapped.createView(apiProvider, logo);
        }

        @Override
        public CustomUserInputConfiguration createCustomConfiguration(DataModel model) {
            return this.wrapped.createCustomConfiguration(model);
        }

        @Override
        public InstallationNodeContribution createNodeContribution(PreambleGeneratorService service, SwingInstallationNodeView view) {
            return this.wrapped.createNodeContribution(service, view);
        }

        @Override
        public DriverNodeBuilder copy() {
            return null;
        }
    }
}

