/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.handlers;

import com.ur.polyscope.screwdriving.program.ScriptGenerationContext;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.simple.Acceleration;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Speed;
import com.ur.urcap.api.domain.variable.Variable;

final class HandlerScriptGenerator {
    private HandlerScriptGenerator() {
    }

    static void generateUntilOK(ScriptWriter scriptWriter, ScriptGenerationContext scriptGenerationContext, String functionName) {
        HandlerScriptGenerator.generateLoopInitialization(scriptWriter, scriptGenerationContext);
        scriptWriter.ifCondition(functionName + "()");
        HandlerScriptGenerator.generateHandlerAction(scriptWriter, scriptGenerationContext);
    }

    static void generateUntilTime(ScriptWriter scriptWriter, double time, ScriptGenerationContext scriptGenerationContext) {
        HandlerScriptGenerator.generateLoopInitialization(scriptWriter, scriptGenerationContext);
        String varName = HandlerScriptGenerator.resolveName(scriptWriter, scriptGenerationContext.getTimeVariable());
        String ifCondition = varName + ">" + time;
        scriptWriter.ifCondition(ifCondition);
        HandlerScriptGenerator.generateHandlerAction(scriptWriter, scriptGenerationContext);
    }

    static void generateUntilDistance(ScriptWriter scriptWriter, double distance, ScriptGenerationContext scriptGenerationContext) {
        distance = 0.001 * distance;
        HandlerScriptGenerator.generateLoopInitialization(scriptWriter, scriptGenerationContext);
        String varName = HandlerScriptGenerator.resolveName(scriptWriter, scriptGenerationContext.getScrewDistanceVariable());
        String ifCondition = varName + ">" + distance;
        scriptWriter.ifCondition(ifCondition);
        HandlerScriptGenerator.generateHandlerAction(scriptWriter, scriptGenerationContext);
    }

    static void generateUntilExpression(ScriptWriter scriptWriter, String expr, ScriptGenerationContext scriptGenerationContext) {
        HandlerScriptGenerator.generateLoopInitialization(scriptWriter, scriptGenerationContext);
        scriptWriter.ifCondition(expr);
        HandlerScriptGenerator.generateHandlerAction(scriptWriter, scriptGenerationContext);
    }

    static void generateErrorDistance(ScriptWriter scriptWriter, double distLimit, ScriptGenerationContext scriptGenerationContext) {
        distLimit = 0.001 * distLimit;
        String varName = HandlerScriptGenerator.resolveName(scriptWriter, scriptGenerationContext.getScrewDistanceVariable());
        String elseifCondition = varName + " > " + distLimit;
        scriptWriter.elseIfCondition(elseifCondition);
        HandlerScriptGenerator.generateHandlerAction(scriptWriter, scriptGenerationContext);
    }

    static void generateErrorNOK(ScriptWriter scriptWriter, ScriptGenerationContext scriptGenerationContext, String functionName) {
        scriptWriter.elseIfCondition(functionName + "()");
        HandlerScriptGenerator.generateHandlerAction(scriptWriter, scriptGenerationContext);
    }

    static void generateErrorTimeout(ScriptWriter scriptWriter, double timeout, ScriptGenerationContext scriptGenerationContext) {
        String varName = HandlerScriptGenerator.resolveName(scriptWriter, scriptGenerationContext.getTimeVariable());
        String ifCondition = varName + ">" + timeout;
        scriptWriter.elseIfCondition(ifCondition);
        HandlerScriptGenerator.generateHandlerAction(scriptWriter, scriptGenerationContext);
    }

    private static void generateForceMode(ScriptWriter scriptWriter, boolean start, ScriptGenerationContext scriptGenerationContext) {
        ScriptGenerationContext.FollowScrew followScrew = scriptGenerationContext.getFollowScrew();
        double speed = followScrew.getSpeed().getAs(Speed.Unit.MM_S) * 0.001;
        if (start) {
            scriptWriter.sleep(0.02);
            scriptWriter.appendLine("zero_ftsensor()");
            scriptWriter.appendLine("screw_driving(" + followScrew.getForce().getAs(Force.Unit.N) + "," + speed + ")");
        } else {
            scriptWriter.appendLine("end_screw_driving()");
        }
    }

    private static void generateHandlerAction(ScriptWriter scriptWriter, ScriptGenerationContext scriptGenerationContext) {
        String continueVariable = HandlerScriptGenerator.resolveName(scriptWriter, scriptGenerationContext.getContinueScrewDrivingVariable());
        scriptGenerationContext.getStopCapability().generateScript(scriptWriter, scriptGenerationContext.getOperationParameters());
        if (scriptGenerationContext.isFollowingScrew()) {
            switch (scriptGenerationContext.getFollowScrew().getFollowScrewMode()) {
                case FORCE: {
                    HandlerScriptGenerator.generateForceMode(scriptWriter, false, scriptGenerationContext);
                    break;
                }
                case SPEED: {
                    double acc = scriptGenerationContext.getFollowScrew().getAcceleration().getAs(Acceleration.Unit.M_S2);
                    String moveThreadIDVariable = HandlerScriptGenerator.resolveName(scriptWriter, scriptGenerationContext.getMoveThreadIDVariable());
                    HandlerScriptGenerator.stopMoveThread(scriptWriter, moveThreadIDVariable, acc);
                    break;
                }
                case EXPRESSION: {
                    String moveThreadIDVariable = HandlerScriptGenerator.resolveName(scriptWriter, scriptGenerationContext.getMoveThreadIDVariable());
                    HandlerScriptGenerator.stopMoveThread(scriptWriter, moveThreadIDVariable, 1.2);
                }
            }
        }
        scriptWriter.assign(continueVariable, "0");
        scriptWriter.writeChildren();
    }

    private static void stopMoveThread(ScriptWriter scriptWriter, String threadID, double acceleration) {
        scriptWriter.appendLine("kill " + threadID);
        scriptWriter.appendLine("stopl(" + acceleration + ")");
    }

    private static void generateLoopInitialization(ScriptWriter scriptWriter, ScriptGenerationContext scriptGenerationContext) {
        String timeVariable = HandlerScriptGenerator.resolveName(scriptWriter, scriptGenerationContext.getTimeVariable());
        String startPosVariable = HandlerScriptGenerator.resolveName(scriptWriter, scriptGenerationContext.getScrewPositionVariable());
        String continueVariable = HandlerScriptGenerator.resolveName(scriptWriter, scriptGenerationContext.getContinueScrewDrivingVariable());
        String displacementVariable = HandlerScriptGenerator.resolveName(scriptWriter, scriptGenerationContext.getScrewDistanceVariable());
        HandlerScriptGenerator.handleTCP(scriptWriter, scriptGenerationContext);
        if (scriptGenerationContext.isFollowingScrew()) {
            switch (scriptGenerationContext.getFollowScrew().getFollowScrewMode()) {
                case FORCE: {
                    HandlerScriptGenerator.generateForceMode(scriptWriter, true, scriptGenerationContext);
                    break;
                }
                case SPEED: {
                    String moveThread = scriptWriter.getResolvedVariableName(scriptGenerationContext.getMoveThreadVariable());
                    scriptWriter.assign(scriptGenerationContext.getMoveThreadIDVariable(), "run " + moveThread + "()");
                    break;
                }
            }
        }
        if (scriptGenerationContext.isUsingTime()) {
            scriptWriter.assign(scriptGenerationContext.getTimeVariable(), "0");
        }
        if (scriptGenerationContext.isUsingDistance()) {
            scriptWriter.assign(startPosVariable, "get_actual_tcp_pose()");
        }
        if (scriptGenerationContext.isUsingDistance()) {
            scriptWriter.assign(displacementVariable, "0");
        }
        scriptWriter.whileCondition(continueVariable + ">0");
        if (scriptGenerationContext.isUsingTime()) {
            scriptWriter.assign(timeVariable, timeVariable + " + get_steptime()");
        }
        if (scriptGenerationContext.isUsingDistance()) {
            scriptWriter.assign(displacementVariable, "point_dist(" + startPosVariable + ",get_actual_tcp_pose())");
        }
    }

    private static void handleTCP(ScriptWriter scriptWriter, ScriptGenerationContext scriptGenerationContext) {
        if (scriptGenerationContext.getTCP() != null) {
            scriptWriter.set_tcp(scriptGenerationContext.getTCP());
        }
    }

    private static String resolveName(ScriptWriter scriptWriter, Variable variable) {
        return scriptWriter.getResolvedVariableName(variable);
    }
}

