/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.handlers;

import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.screwdriving.handlers.MachineErrorHandlerType;
import com.ur.polyscope.screwdriving.handlers.MachineErrorProgramNodeView;
import com.ur.polyscope.screwdriving.installation.ScrewdrivingInstallationNodeContribution;
import com.ur.polyscope.screwdriving.internal.ImageResource;
import com.ur.polyscope.screwdriving.internal.TextResource;
import com.ur.polyscope.screwdriving.program.Screwdriving;
import com.ur.polyscope.screwdriving.simpsons.CapabilitiesDefinition;
import com.ur.polyscope.screwdriving.simpsons.Capability;
import com.ur.polyscope.screwdriving.util.AbstractCustomProgramNodeContribution;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.IconContribution;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionInsertedContext;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.driver.screwdriver.ScrewdriverParameters;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.builtin.CommentNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.Icon;

public class MachineErrorProgramNodeContribution
extends AbstractCustomProgramNodeContribution
implements IconContribution,
MachineErrorHandlerType {
    private static final String MACHINE_ERROR_VARIABLE_NAME = "machineError";
    private static final Logger LOG = LogFactory.createLogger(MachineErrorProgramNodeContribution.class);
    private final TextResource textResource;
    private final ProgramAPI programAPI;
    private final MachineErrorProgramNodeView view;

    public MachineErrorProgramNodeContribution(TextResource textResource, ProgramAPI programAPI, MachineErrorProgramNodeView machineErrorProgramNodeView) {
        this.textResource = textResource;
        this.programAPI = programAPI;
        this.view = machineErrorProgramNodeView;
    }

    private void addCommentNode() {
        this.programAPI.getUndoRedoManager().recordChanges(() -> {
            CommentNode commentNode = this.programAPI.getProgramModel().getProgramNodeFactory().createCommentNode();
            commentNode.setComment(this.textResource.handlerComment());
            try {
                this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).addChild((ProgramNode)commentNode);
            }
            catch (TreeStructureException e) {
                LOG.error("Unable to insert comment node", (Throwable)e);
            }
        });
    }

    @Override
    public void onInserted(ContributionInsertedContext contributionInsertedContext) {
        TreeNode rootTreeNode;
        super.onInserted(contributionInsertedContext);
        if (!contributionInsertedContext.isCloning() && (rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this)).getChildren().isEmpty()) {
            this.addCommentNode();
        }
    }

    public void openView() {
        this.updateView();
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.textResource.machineErrorHandler();
    }

    public boolean isDefined() {
        return this.hasSufficientCapabilities();
    }

    public void generateScript(ScriptWriter scriptWriter) {
        this.generateMachineErrorAssignmentStatement(scriptWriter);
        scriptWriter.ifCondition(MACHINE_ERROR_VARIABLE_NAME);
        scriptWriter.writeChildren();
        scriptWriter.elseCondition();
        this.generateStartScrewDriver(scriptWriter);
    }

    public Icon getIcon(boolean isUndefined) {
        if (isUndefined) {
            return ImageResource.programUntilUndefined();
        }
        return ImageResource.programUntil();
    }

    private boolean hasSufficientCapabilities() {
        Optional<CapabilitiesDefinition> capabilitiesDefinition = this.getCapabilitiesDefinition();
        return capabilitiesDefinition.isPresent() && capabilitiesDefinition.get().hasMachineErrorHandlerCapability();
    }

    void updateView() {
        this.view.showCapabilitiesWarning(!this.hasSufficientCapabilities());
    }

    private void generateMachineErrorAssignmentStatement(ScriptWriter scriptWriter) {
        Optional<CapabilitiesDefinition> capabilitiesDefinition = this.getCapabilitiesDefinition();
        if (capabilitiesDefinition.isPresent()) {
            ArrayList capabilities = new ArrayList();
            CapabilitiesDefinition definition = capabilitiesDefinition.get();
            definition.getCapability(Capability.CapabilityType.MACHINE_READY).ifPresent(capabilities::add);
            definition.getCapability(Capability.CapabilityType.PROGRAM_SELECTION).ifPresent(capabilities::add);
            definition.getCapability(Capability.CapabilityType.FEED_SCREW).ifPresent(capabilities::add);
            definition.getCapability(Capability.CapabilityType.PREPARE).ifPresent(capabilities::add);
            StringBuilder machineErrorString = new StringBuilder();
            boolean initialized = false;
            machineErrorString.append("not(");
            for (Capability capability : capabilities) {
                if (initialized) {
                    machineErrorString.append(" and ");
                }
                machineErrorString.append(this.getScrewdriving().getFunctionName(capability.getCapabilityType())).append("()");
                initialized = true;
            }
            machineErrorString.append(')');
            scriptWriter.assign(MACHINE_ERROR_VARIABLE_NAME, machineErrorString.toString());
        }
    }

    private Optional<CapabilitiesDefinition> getCapabilitiesDefinition() {
        ScrewdrivingInstallationNodeContribution installationNode = (ScrewdrivingInstallationNodeContribution)this.programAPI.getInstallationNode(ScrewdrivingInstallationNodeContribution.class);
        return installationNode.getCapabilitiesDefinition();
    }

    private void generateStartScrewDriver(ScriptWriter scriptWriter) {
        Optional<CapabilitiesDefinition> capabilitiesDefinition = this.getCapabilitiesDefinition();
        if (capabilitiesDefinition.isPresent()) {
            CapabilitiesDefinition definition = capabilitiesDefinition.get();
            Optional<Capability> startCap = definition.getCapability(Capability.CapabilityType.START_DRIVE_SCREW);
            ScrewdriverParameters screwdriverOperationParameters = this.getScrewdriving().getScrewdriverOperationParameters();
            startCap.ifPresent(capability -> capability.generateScript(scriptWriter, screwdriverOperationParameters));
            this.handleNativeWaitForOKNOK(scriptWriter, definition);
        }
    }

    private void handleNativeWaitForOKNOK(ScriptWriter scriptWriter, CapabilitiesDefinition definition) {
        if (definition.isNative()) {
            Optional<Capability> okCap = definition.getCapability(Capability.CapabilityType.OK);
            Optional<Capability> nokCap = definition.getCapability(Capability.CapabilityType.NOTOK);
            boolean hasOKCapability = okCap.isPresent();
            boolean hasNOKCapability = nokCap.isPresent();
            if (!hasOKCapability && !hasNOKCapability) {
                return;
            }
            String condition = "";
            if (hasOKCapability) {
                condition = this.getScrewdriving().getFunctionName(Capability.CapabilityType.OK) + "()";
            }
            if (hasNOKCapability) {
                if (!condition.isEmpty()) {
                    condition = condition + " or ";
                }
                condition = condition + this.getScrewdriving().getFunctionName(Capability.CapabilityType.NOTOK) + "()";
            }
            scriptWriter.whileCondition(condition);
            scriptWriter.sleep(0.01);
            scriptWriter.end();
        }
    }

    private Screwdriving getScrewdriving() {
        return (Screwdriving)this.getParentContribution();
    }

    void deleteNode() {
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        this.getScrewdriving().removeHandler(root);
    }
}

