/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.handlers;

import com.ur.polyscope.screwdriving.handlers.MachineErrorProgramNodeContribution;
import com.ur.polyscope.screwdriving.internal.ImageResource;
import com.ur.polyscope.screwdriving.internal.TextResource;
import com.ur.polyscope.screwdriving.util.SwingLayout;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.util.swing.HTML;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class MachineErrorProgramNodeView
implements SwingProgramNodeView<MachineErrorProgramNodeContribution> {
    private static final int LEFT_ADJUSTMENT = 0;
    private static final int ROW_WIDTH = 680;
    private final TextResource textResource;
    private JLabel warningLabel;

    MachineErrorProgramNodeView(TextResource textResource) {
        this.textResource = textResource;
    }

    public void buildUI(JPanel jPanel, ContributionProvider<MachineErrorProgramNodeContribution> contributionProvider) {
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(this.createTopPanel());
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(this.createAddHandlerPanel(contributionProvider));
    }

    private JPanel createTopPanel() {
        JPanel topSection = SwingLayout.createBoxLayoutPanel(new Dimension(680, 260), 1);
        topSection.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.warningLabel = new JLabel(HTML.html((String)HTML.p((String)this.textResource.machineErrorHandlerWarning())), ImageResource.warning(), 10);
        this.warningLabel.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.warningLabel.setVisible(false);
        topSection.add(this.warningLabel);
        JLabel description = new JLabel(HTML.html((String)HTML.p((String)this.textResource.machineErrorHandlerDescription())));
        topSection.add(description);
        return topSection;
    }

    private JPanel createAddHandlerPanel(ContributionProvider<MachineErrorProgramNodeContribution> contributionProvider) {
        JPanel addHandlerPanel = SwingLayout.createBoxLayoutPanel(new Dimension(680, 30), 0);
        addHandlerPanel.setAlignmentX(0.0f);
        addHandlerPanel.setBorder(new EmptyBorder(0, 15, 0, 0));
        addHandlerPanel.add(Box.createHorizontalGlue());
        JButton undefinedDeleteButton = new JButton(ImageResource.delete());
        SwingLayout.setDimension(undefinedDeleteButton, 40, 40);
        undefinedDeleteButton.addActionListener(e -> ((MachineErrorProgramNodeContribution)contributionProvider.get()).deleteNode());
        addHandlerPanel.add(undefinedDeleteButton);
        JPanel spacer = new JPanel();
        SwingLayout.setDimension(spacer, 15, 40);
        addHandlerPanel.add(spacer);
        return addHandlerPanel;
    }

    void showCapabilitiesWarning(boolean showWarning) {
        this.warningLabel.setVisible(showWarning);
    }
}

