/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.handlers;

import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.screwdriving.handlers.HandlerConfiguration;
import com.ur.polyscope.screwdriving.handlers.HandlerNodeType;
import com.ur.polyscope.screwdriving.handlers.HandlerScriptGenerator;
import com.ur.polyscope.screwdriving.handlers.HandlerType;
import com.ur.polyscope.screwdriving.handlers.ScrewdrivingHandlersNodeView;
import com.ur.polyscope.screwdriving.handlers.ValidatorHelper;
import com.ur.polyscope.screwdriving.installation.ScrewdrivingInstallationNodeContribution;
import com.ur.polyscope.screwdriving.internal.ImageResource;
import com.ur.polyscope.screwdriving.internal.impl.TextResourceImpl;
import com.ur.polyscope.screwdriving.program.Screwdriving;
import com.ur.polyscope.screwdriving.program.ScriptGenerationContext;
import com.ur.polyscope.screwdriving.simpsons.CapabilitiesDefinition;
import com.ur.polyscope.screwdriving.simpsons.Capability;
import com.ur.polyscope.screwdriving.util.AbstractCustomProgramNodeContribution;
import com.ur.polyscope.screwdriving.util.ExpressionKeyboard;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.IconContribution;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionInsertedContext;
import com.ur.polyscope.urcaps.userinteraction.keyboard.KeyboardExpressionInput;
import com.ur.swing.units.Units;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.builtin.CommentNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.system.localization.Localization;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.value.expression.Expression;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.swing.Icon;

public class ScrewdrivingHandlersNodeContribution
extends AbstractCustomProgramNodeContribution
implements HandlerNodeType,
IconContribution {
    private static final String KEY_PROGRAM_HANDLER_TYPE = "handlerType";
    private static final String KEY_SUCCESS_HANDLER_ONLY = "successHandlerOnly";
    private static final String KEY_UNTIL_TIMEOUT_VALUE = "untilTimeoutValue";
    private static final String KEY_UNTIL_DISTANCE_VALUE = "untilDistanceValue";
    private static final String KEY_UNTIL_EXPRESSION_VALUE = "untilTimeoutValue";
    private static final String KEY_ERROR_DISTANCE_VALUE = "errorDistanceValue";
    private static final String KEY_ERROR_TIMEOUT_VALUE = "errorTimeoutValue";
    private static final String KEY_UNTIL_EXPRESSION_STRING_VALUE = "untilExpressionStringValue";
    private static final Double MAX_TIME = 300.0;
    private static final Double MAX_DISTANCE = 500.0;
    private static final Double MAX_DISTANCE_IMPERIAL = 2.0;
    private static final Logger LOG = LogFactory.createLogger(ScrewdrivingHandlersNodeContribution.class);
    private static ExpressionKeyboard expressionKeyboard;
    private final DataModel model;
    private final ScrewdrivingHandlersNodeView view;
    private final TextResourceImpl textResource;
    private final UndoRedoManager undoRedoManager;
    private final ProgramAPI programAPI;
    private final Localization localization;
    private KeyboardInputFactory keyboardFactory;

    ScrewdrivingHandlersNodeContribution(DataModel dataModel, ScrewdrivingHandlersNodeView view, TextResourceImpl textResource, UndoRedoManager undoRedoManager, ProgramAPI programAPI, Localization localization, KeyboardInputFactory keyboardFactory) {
        this.model = dataModel;
        this.view = view;
        this.textResource = textResource;
        this.undoRedoManager = undoRedoManager;
        this.programAPI = programAPI;
        this.localization = localization;
        this.keyboardFactory = keyboardFactory;
    }

    @Inject
    public static void setExpressionKeyboard(ExpressionKeyboard expressionKeyboard) {
        ScrewdrivingHandlersNodeContribution.expressionKeyboard = expressionKeyboard;
    }

    private void addCommentNode() {
        this.programAPI.getUndoRedoManager().recordChanges(() -> {
            CommentNode commentNode = this.programAPI.getProgramModel().getProgramNodeFactory().createCommentNode();
            commentNode.setComment(this.textResource.handlerComment());
            try {
                this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).addChild((ProgramNode)commentNode);
            }
            catch (TreeStructureException e) {
                LOG.error("Unable to insert comment node", (Throwable)e);
            }
        });
    }

    @Override
    public void onInserted(ContributionInsertedContext contributionInsertedContext) {
        TreeNode rootTreeNode;
        super.onInserted(contributionInsertedContext);
        if (!contributionInsertedContext.isCloning() && (rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this)).getChildren().isEmpty()) {
            this.addCommentNode();
        }
    }

    public void openView() {
        this.updateView();
    }

    private void updateView() {
        Screwdriving screwdriving = this.getScrewdriving();
        this.view.updateView(this.getHandlerType(), screwdriving.hasSuccessHandler(), screwdriving.getDefinedHandlerTypes(), this.isSuccessHandlerOnly(), this.getHandlerConfiguration(), screwdriving.allowMoreHandlers(), this.getDistanceUnit(), screwdriving.isFollowScrewEnabled(), this.getScrewdrivingCapabilities().orElse(null));
    }

    public void closeView() {
    }

    public String getTitle() {
        HandlerType handlerType = this.getHandlerType();
        if (handlerType == null) {
            return this.textResource.until() + "        ";
        }
        String type = this.textResource.handlerType(handlerType);
        HandlerConfiguration handlerConfiguration = this.getHandlerConfiguration();
        String additionalText = "";
        if (handlerConfiguration.getValue().isPresent()) {
            switch (handlerType) {
                case HANDLER_UNTIL_TIME: 
                case HANDLER_ERROR_TIMEOUT: {
                    double timeValue = (Double)handlerConfiguration.getValue().get();
                    if (!(timeValue > 0.0)) break;
                    additionalText = String.format("%.2f s", timeValue);
                    break;
                }
                case HANDLER_UNTIL_DISTANCE: 
                case HANDLER_ERROR_DISTANCE: {
                    Length length = (Length)handlerConfiguration.getValue().get();
                    double lengthValue = length.getAs(this.getDistanceUnit());
                    additionalText = lengthValue > 0.0 ? String.format("%.2f ", lengthValue) + Units.getText().unitMm() : "";
                    break;
                }
            }
        }
        return handlerType.isSuccessState() ? type + " " + additionalText : this.textResource.error() + ": " + type + " " + additionalText;
    }

    public boolean isDefined() {
        return this.getHandlerType() != null && this.isLegalHandlerType() && this.hasValueSet();
    }

    public void generateScript(ScriptWriter scriptWriter) {
        ScriptGenerationContext scriptGenerationContext = this.getScrewdriving().getScriptGenerationContext();
        HandlerConfiguration handlerConfiguration = this.getHandlerConfiguration();
        switch (handlerConfiguration.getHandlerType()) {
            case HANDLER_UNTIL_OK: {
                HandlerScriptGenerator.generateUntilOK(scriptWriter, scriptGenerationContext, this.getScrewdriving().getFunctionName(Capability.CapabilityType.OK));
                break;
            }
            case HANDLER_UNTIL_TIME: {
                double val = (Double)handlerConfiguration.getValue().get();
                HandlerScriptGenerator.generateUntilTime(scriptWriter, val, scriptGenerationContext);
                break;
            }
            case HANDLER_UNTIL_DISTANCE: {
                double val = ((Length)handlerConfiguration.getValue().get()).getAs(Length.Unit.MM);
                HandlerScriptGenerator.generateUntilDistance(scriptWriter, val, scriptGenerationContext);
                break;
            }
            case HANDLER_UNTIL_EXPRESSION: {
                String str = this.getUntilExpressionScript();
                HandlerScriptGenerator.generateUntilExpression(scriptWriter, str, scriptGenerationContext);
                break;
            }
            case HANDLER_ERROR_DISTANCE: {
                double val = ((Length)handlerConfiguration.getValue().get()).getAs(Length.Unit.MM);
                HandlerScriptGenerator.generateErrorDistance(scriptWriter, val, scriptGenerationContext);
                break;
            }
            case HANDLER_ERROR_NOT_OK: {
                HandlerScriptGenerator.generateErrorNOK(scriptWriter, scriptGenerationContext, this.getScrewdriving().getFunctionName(Capability.CapabilityType.NOTOK));
                break;
            }
            case HANDLER_ERROR_TIMEOUT: {
                double timeout = (Double)handlerConfiguration.getValue().get();
                HandlerScriptGenerator.generateErrorTimeout(scriptWriter, timeout, scriptGenerationContext);
                break;
            }
        }
    }

    @Override
    public HandlerType getHandlerType() {
        String handlerTypeString = this.model.get(KEY_PROGRAM_HANDLER_TYPE, (String)null);
        if (handlerTypeString != null) {
            return HandlerType.valueOf(handlerTypeString);
        }
        return null;
    }

    void setHandlerType(HandlerType handlerType) {
        this.undoRedoManager.recordChanges(() -> {
            this.model.set(KEY_PROGRAM_HANDLER_TYPE, handlerType.name());
            this.model.remove(KEY_UNTIL_DISTANCE_VALUE);
            this.model.remove("untilTimeoutValue");
            this.model.remove("untilTimeoutValue");
            this.model.remove(KEY_UNTIL_EXPRESSION_STRING_VALUE);
            this.model.remove(KEY_ERROR_TIMEOUT_VALUE);
            this.model.remove(KEY_ERROR_DISTANCE_VALUE);
        });
        this.updateView();
    }

    @Override
    public void setSuccessHandlerOnly() {
        this.model.set(KEY_SUCCESS_HANDLER_ONLY, true);
    }

    @Override
    public boolean isSuccessHandlerOnly() {
        return this.model.get(KEY_SUCCESS_HANDLER_ONLY, false);
    }

    public Icon getIcon(boolean isUndefined) {
        if (!isUndefined) {
            return ImageResource.programUntil();
        }
        return ImageResource.programUntilUndefined();
    }

    public HandlerConfiguration getHandlerConfiguration() {
        HandlerType handlerType = this.getHandlerType();
        HandlerConfiguration<Object> result = null;
        if (handlerType != null) {
            switch (handlerType) {
                case HANDLER_UNTIL_OK: {
                    result = new HandlerConfiguration<Object>(handlerType, null);
                    break;
                }
                case HANDLER_UNTIL_TIME: {
                    result = new HandlerConfiguration<Double>(handlerType, this.getUntilTimeValue());
                    break;
                }
                case HANDLER_UNTIL_DISTANCE: {
                    result = new HandlerConfiguration<Length>(handlerType, this.getUntilDistanceValue());
                    break;
                }
                case HANDLER_UNTIL_EXPRESSION: {
                    result = new HandlerConfiguration<String>(handlerType, this.getUntilExpression());
                    break;
                }
                case HANDLER_ERROR_NOT_OK: {
                    result = new HandlerConfiguration<Object>(handlerType, null);
                    break;
                }
                case HANDLER_ERROR_DISTANCE: {
                    result = new HandlerConfiguration<Length>(handlerType, this.getErrorDistanceValue());
                    break;
                }
                case HANDLER_ERROR_TIMEOUT: {
                    result = new HandlerConfiguration<Double>(handlerType, this.getErrorTimeoutValue());
                }
            }
        }
        return result;
    }

    private Length getErrorDistanceValue() {
        return this.model.get(KEY_ERROR_DISTANCE_VALUE, (Length)null);
    }

    private String getUntilExpression() {
        String expression = this.getUntilExpressionString();
        if (expression.isEmpty()) {
            expression = this.getUntilExpressionScript();
        }
        return expression;
    }

    private double getUntilTimeValue() {
        return this.model.get("untilTimeoutValue", 0.0);
    }

    private String getUntilExpressionScript() {
        return this.model.get("untilTimeoutValue", "");
    }

    private String getUntilExpressionString() {
        return this.model.get(KEY_UNTIL_EXPRESSION_STRING_VALUE, "");
    }

    private Screwdriving getScrewdriving() {
        return (Screwdriving)this.getParentContribution();
    }

    void deleteNode() {
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        this.getScrewdriving().removeHandler(root);
    }

    private void setUntilTimeValue(double value) {
        this.undoRedoManager.recordChanges(() -> this.model.set("untilTimeoutValue", value));
        this.updateView();
    }

    private void setUntilDistanceValue(double value) {
        Length.Unit distanceUnit = this.getDistanceUnit();
        SimpleValueFactory valueFactory = this.programAPI.getValueFactoryProvider().getSimpleValueFactory();
        this.undoRedoManager.recordChanges(() -> this.model.set(KEY_UNTIL_DISTANCE_VALUE, valueFactory.createLength(value, distanceUnit)));
        this.updateView();
    }

    private void setErrorTimeoutValue(double value) {
        this.undoRedoManager.recordChanges(() -> this.model.set(KEY_ERROR_TIMEOUT_VALUE, value));
        this.updateView();
    }

    private void setErrorDistanceValue(double value) {
        Length.Unit distanceUnit = this.getDistanceUnit();
        SimpleValueFactory valueFactory = this.programAPI.getValueFactoryProvider().getSimpleValueFactory();
        this.undoRedoManager.recordChanges(() -> this.model.set(KEY_ERROR_DISTANCE_VALUE, valueFactory.createLength(value, distanceUnit)));
        this.updateView();
    }

    private boolean isLegalHandlerType() {
        boolean isLegal = true;
        Screwdriving screwdriving = this.getScrewdriving();
        if (screwdriving == null) {
            isLegal = false;
        } else {
            HandlerType handlerType = this.getHandlerType();
            if (handlerType != null) {
                List<HandlerType> existingHandlers = screwdriving.getDefinedHandlerTypes();
                boolean followingScrew = screwdriving.isFollowScrewEnabled();
                switch (handlerType) {
                    case HANDLER_UNTIL_OK: {
                        isLegal = this.hasCapability(Capability.CapabilityType.OK);
                        break;
                    }
                    case HANDLER_UNTIL_DISTANCE: {
                        isLegal = followingScrew;
                        break;
                    }
                    case HANDLER_ERROR_NOT_OK: {
                        isLegal = this.hasCapability(Capability.CapabilityType.NOTOK);
                        break;
                    }
                    case HANDLER_ERROR_DISTANCE: {
                        isLegal = !existingHandlers.contains((Object)HandlerType.HANDLER_UNTIL_DISTANCE) && followingScrew;
                        break;
                    }
                    case HANDLER_ERROR_TIMEOUT: {
                        isLegal = !existingHandlers.contains((Object)HandlerType.HANDLER_UNTIL_TIME);
                        break;
                    }
                }
            }
        }
        return isLegal;
    }

    private boolean hasValueSet() {
        boolean result = true;
        HandlerType handlerType = this.getHandlerType();
        if (handlerType != null) {
            switch (handlerType) {
                case HANDLER_UNTIL_TIME: {
                    result = this.getUntilTimeValue() > 0.0;
                    break;
                }
                case HANDLER_UNTIL_DISTANCE: {
                    result = this.getUntilDistanceValue() != null;
                    break;
                }
                case HANDLER_UNTIL_EXPRESSION: {
                    result = !this.getUntilExpression().isEmpty();
                    break;
                }
                case HANDLER_ERROR_DISTANCE: {
                    result = this.getErrorDistanceValue() != null;
                    break;
                }
                case HANDLER_ERROR_TIMEOUT: {
                    result = this.getErrorTimeoutValue() > 0.0;
                    break;
                }
            }
        }
        return result;
    }

    KeyboardNumberInput<Double> getDoubleKeyboard(HandlerType handlerType) {
        double initialValue;
        KeyboardNumberInput keyboard = this.keyboardFactory.createPositiveDoubleKeypadInput();
        switch (handlerType) {
            case HANDLER_UNTIL_TIME: {
                initialValue = this.getUntilTimeValue();
                break;
            }
            case HANDLER_UNTIL_DISTANCE: {
                Length untilDistanceValue = this.getUntilDistanceValue();
                initialValue = untilDistanceValue != null ? untilDistanceValue.getAs(this.getDistanceUnit()) : -1.0;
                break;
            }
            case HANDLER_ERROR_DISTANCE: {
                Length errorDistanceValue = this.getErrorDistanceValue();
                initialValue = errorDistanceValue != null ? errorDistanceValue.getAs(this.getDistanceUnit()) : -1.0;
                break;
            }
            case HANDLER_ERROR_TIMEOUT: {
                initialValue = this.getErrorTimeoutValue();
                break;
            }
            default: {
                initialValue = 0.0;
            }
        }
        if (initialValue > 0.0) {
            keyboard.setInitialValue((Object)initialValue);
        }
        keyboard.setErrorValidator(this.createDoubleValidator(handlerType));
        return keyboard;
    }

    InputValidator<Double> createDoubleValidator(final HandlerType handlerType) {
        return new InputValidator<Double>(){

            public boolean isValid(Double aDouble) {
                return ValidatorHelper.isValid(aDouble, ScrewdrivingHandlersNodeContribution.this.getMaxValue(handlerType));
            }

            public String getMessage(Double aDouble) {
                String result = null;
                if (aDouble > 0.0) {
                    if (aDouble > ScrewdrivingHandlersNodeContribution.this.getMaxValue(handlerType)) {
                        switch (handlerType) {
                            case HANDLER_UNTIL_TIME: 
                            case HANDLER_ERROR_TIMEOUT: {
                                result = ScrewdrivingHandlersNodeContribution.this.textResource.valueMustBeLessThan("" + MAX_TIME, Units.getText().unitSeconds());
                                break;
                            }
                            case HANDLER_UNTIL_DISTANCE: 
                            case HANDLER_ERROR_DISTANCE: {
                                result = ScrewdrivingHandlersNodeContribution.this.textResource.valueMustBeLessThan(String.format("%.2f", ScrewdrivingHandlersNodeContribution.this.getMaxValue(handlerType)), Units.getText().unitMm());
                                break;
                            }
                        }
                    } else {
                        result = ScrewdrivingHandlersNodeContribution.this.textResource.maxTwoDecimals();
                    }
                } else {
                    result = ScrewdrivingHandlersNodeContribution.this.textResource.valueMustBeLargerThanZero();
                }
                return result;
            }
        };
    }

    private double getMaxValue(HandlerType handlerType) {
        double result = Double.MAX_VALUE;
        switch (handlerType) {
            case HANDLER_UNTIL_TIME: 
            case HANDLER_ERROR_TIMEOUT: {
                result = MAX_TIME;
                break;
            }
            case HANDLER_UNTIL_DISTANCE: 
            case HANDLER_ERROR_DISTANCE: {
                result = this.localization.getUnitType() == UnitType.IMPERIAL ? MAX_DISTANCE_IMPERIAL : MAX_DISTANCE;
                break;
            }
        }
        return result;
    }

    private Length.Unit getDistanceUnit() {
        UnitType unitType = this.localization.getUnitType();
        return unitType == UnitType.METRIC ? Length.Unit.MM : Length.Unit.IN;
    }

    private double getErrorTimeoutValue() {
        return this.model.get(KEY_ERROR_TIMEOUT_VALUE, 0.0);
    }

    private Length getUntilDistanceValue() {
        return this.model.get(KEY_UNTIL_DISTANCE_VALUE, (Length)null);
    }

    KeyboardInputCallback<Double> getHandlerDoubleCallback(final HandlerType handlerType) {
        return new KeyboardInputCallback<Double>(){

            public void onOk(Double aDouble) {
                switch (handlerType) {
                    case HANDLER_UNTIL_TIME: {
                        ScrewdrivingHandlersNodeContribution.this.setUntilTimeValue(aDouble);
                        break;
                    }
                    case HANDLER_UNTIL_DISTANCE: {
                        ScrewdrivingHandlersNodeContribution.this.setUntilDistanceValue(aDouble);
                        break;
                    }
                    case HANDLER_ERROR_DISTANCE: {
                        ScrewdrivingHandlersNodeContribution.this.setErrorDistanceValue(aDouble);
                        break;
                    }
                    case HANDLER_ERROR_TIMEOUT: {
                        ScrewdrivingHandlersNodeContribution.this.setErrorTimeoutValue(aDouble);
                        break;
                    }
                }
            }
        };
    }

    KeyboardExpressionInput getUntilExpressionKeyboard() {
        String initialValue = this.getUntilExpression();
        return expressionKeyboard.getExpressionKeyboard(initialValue);
    }

    KeyboardInputCallback<Expression> getExpressionCallback() {
        return expressionKeyboard.getExpressionCallback(this.model, "untilTimeoutValue", KEY_UNTIL_EXPRESSION_STRING_VALUE, this.undoRedoManager);
    }

    void addHandler() {
        this.getScrewdriving().addHandler();
        this.updateView();
    }

    private boolean hasCapability(Capability.CapabilityType capabilityType) {
        Optional<CapabilitiesDefinition> capabilities = this.getScrewdrivingCapabilities();
        return capabilities.isPresent() && capabilities.get().getCapability(capabilityType).isPresent();
    }

    private Optional<CapabilitiesDefinition> getScrewdrivingCapabilities() {
        ScrewdrivingInstallationNodeContribution installationNode = (ScrewdrivingInstallationNodeContribution)this.programAPI.getInstallationNode(ScrewdrivingInstallationNodeContribution.class);
        return installationNode.getCapabilitiesDefinition();
    }
}

