/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.handlers;

import com.ur.polyscope.screwdriving.handlers.HandlerConfiguration;
import com.ur.polyscope.screwdriving.handlers.HandlerType;
import com.ur.polyscope.screwdriving.handlers.HandlerTypeRenderer;
import com.ur.polyscope.screwdriving.handlers.ScrewdrivingHandlersNodeContribution;
import com.ur.polyscope.screwdriving.internal.ImageResource;
import com.ur.polyscope.screwdriving.internal.TextResource;
import com.ur.polyscope.screwdriving.simpsons.CapabilitiesDefinition;
import com.ur.polyscope.screwdriving.simpsons.Capability;
import com.ur.polyscope.urcaps.userinteraction.keyboard.KeyboardExpressionInput;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.EnumComboBoxModel;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.units.Units;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.util.swing.HTML;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class ScrewdrivingHandlersNodeView
implements SwingProgramNodeView<ScrewdrivingHandlersNodeContribution> {
    private static final String OK_BUTTON = ScrewdrivingHandlersNodeView.class.getSimpleName() + ".okButton";
    private static final String TIME_BUTTON = ScrewdrivingHandlersNodeView.class.getSimpleName() + ".timeButton";
    private static final String DISTANCE_BUTTON = ScrewdrivingHandlersNodeView.class.getSimpleName() + ".distanceButton";
    private static final String EXPRESSION_BUTTON = ScrewdrivingHandlersNodeView.class.getSimpleName() + ".expressionButton";
    private static final String NOT_OK_BUTTON = ScrewdrivingHandlersNodeView.class.getSimpleName() + ".notOkButton";
    private static final String ERROR_DISTANCE_BUTTON = ScrewdrivingHandlersNodeView.class.getSimpleName() + ".errorDistanceButton";
    private static final String TIMEOUT_BUTTON = ScrewdrivingHandlersNodeView.class.getSimpleName() + ".timeoutButton";
    private static final String TIME_INPUT_FIELD = ScrewdrivingHandlersNodeView.class.getSimpleName() + ".timeInput";
    private static final String DISTANCE_INPUT_FIELD = ScrewdrivingHandlersNodeView.class.getSimpleName() + ".distanceInput";
    private static final String ERROR_DISTANCE_INPUT_FIELD = ScrewdrivingHandlersNodeView.class.getSimpleName() + ".errorDistanceInput";
    private static final String EXPRESSION_INPUT_FIELD = ScrewdrivingHandlersNodeView.class.getSimpleName() + ".expressionInput";
    private static final String TIMEOUT_INPUT_FIELD = ScrewdrivingHandlersNodeView.class.getSimpleName() + ".timeoutInput";
    private static final String HANDLER_DROPDOWN = ScrewdrivingHandlersNodeView.class.getSimpleName() + ".handlerDropdown";
    private static final Color BETWEEN_CARD_COLOR = new Color(230, 230, 230);
    private static final int CONTENT_WIDTH = 680;
    private final TextResource textResource;
    private JPanel typeSelectionPanel;
    private JPanel configurationPanel;
    private JComboBox<HandlerType> headerComboBox;
    private JButton okHandlerButton;
    private JButton timeHandlerButton;
    private JButton distanceHandlerButton;
    private JButton expressionHandlerButton;
    private JButton notOkHandlerButton;
    private JButton errorDistanceHandlerButton;
    private JButton timeoutHandlerButton;
    private JPanel okConfigurationPanel;
    private JPanel timeConfigurationPanel;
    private JPanel distanceConfigurationPanel;
    private JPanel expressionConfigurationPanel;
    private JPanel notOkConfigurationPanel;
    private JPanel timeoutConfigurationPanel;
    private JPanel errorDistanceConfigurationPanel;
    private JTextField untilTimeField;
    private JTextField untilDistanceField;
    private JTextField untilExpressionField;
    private JTextField errorTimeoutField;
    private JTextField errorDistanceField;
    private HandlerTypeRenderer handlerRenderer;
    private JButton addHandlerButton;
    private JLabel addUntilLabel;
    private JButton undefinedDeleteButton;

    ScrewdrivingHandlersNodeView(TextResource textResource) {
        this.textResource = textResource;
    }

    public void buildUI(JPanel jPanel, ContributionProvider<ScrewdrivingHandlersNodeContribution> contributionProvider) {
        JLabel description = new JLabel(this.textResource.handlerGeneralDescription());
        description.setAlignmentX(0.0f);
        ScrewdrivingHandlersNodeView.setDimension(description, 680, 50);
        description.setBorder(new EmptyBorder(0, 15, 0, 0));
        this.typeSelectionPanel = this.createTypeSelectionPanel(contributionProvider);
        this.configurationPanel = this.createConfigurationPanel(contributionProvider);
        jPanel.add(description);
        jPanel.add(this.typeSelectionPanel);
        jPanel.add(this.configurationPanel);
        jPanel.add(this.createAddHandlerPanel(contributionProvider));
    }

    void updateView(HandlerType selectedType, boolean successHandlerExists, List<HandlerType> existingHandlers, boolean successHandlerOnly, HandlerConfiguration handlerConfiguration, boolean enableAddHandler, Length.Unit lengthUnit, boolean followScrewEnabled, CapabilitiesDefinition capabilities) {
        if (selectedType == null) {
            this.typeSelectionPanel.setVisible(true);
            this.configurationPanel.setVisible(false);
            this.toggleButtons(capabilities, successHandlerExists, existingHandlers, successHandlerOnly, followScrewEnabled);
        } else {
            this.typeSelectionPanel.setVisible(false);
            this.configurationPanel.setVisible(true);
            this.updateComboBoxModel(capabilities, selectedType, existingHandlers, successHandlerOnly, followScrewEnabled);
            this.toggleConfigurationPanels(selectedType);
            this.updateConfigurationValue(handlerConfiguration, lengthUnit);
        }
        this.undefinedDeleteButton.setVisible(!successHandlerOnly);
        this.addHandlerButton.setEnabled(enableAddHandler);
        this.addUntilLabel.setEnabled(enableAddHandler);
    }

    private JPanel createAddHandlerPanel(ContributionProvider<ScrewdrivingHandlersNodeContribution> contributionProvider) {
        JPanel addHandlerPanel = ScrewdrivingHandlersNodeView.createBoxLayoutPanel(680, 30, 0);
        addHandlerPanel.setAlignmentX(0.0f);
        addHandlerPanel.setBorder(new EmptyBorder(0, 15, 0, 0));
        this.addHandlerButton = new JButton(ImageResource.plusIcon());
        this.addHandlerButton.setAlignmentX(0.0f);
        this.addHandlerButton.addActionListener(e -> ((ScrewdrivingHandlersNodeContribution)contributionProvider.get()).addHandler());
        this.addUntilLabel = new JLabel(HTML.html((String)HTML.fontBold((String)this.textResource.addUntil())));
        this.addUntilLabel.setBorder(new EmptyBorder(0, 10, 0, 0));
        addHandlerPanel.add(this.addHandlerButton);
        addHandlerPanel.add(this.addUntilLabel);
        addHandlerPanel.add(Box.createHorizontalGlue());
        this.undefinedDeleteButton = new JButton(ImageResource.delete());
        ScrewdrivingHandlersNodeView.setDimension(this.undefinedDeleteButton, 40, 40);
        this.undefinedDeleteButton.addActionListener(e -> ((ScrewdrivingHandlersNodeContribution)contributionProvider.get()).deleteNode());
        addHandlerPanel.add(this.undefinedDeleteButton);
        JPanel spacer = new JPanel();
        ScrewdrivingHandlersNodeView.setDimension(spacer, 15, 40);
        addHandlerPanel.add(spacer);
        return addHandlerPanel;
    }

    private static JPanel createBoxLayoutPanel(int width, int height, int axis) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, axis));
        panel.setAlignmentX(0.0f);
        panel.setAlignmentY(0.0f);
        ScrewdrivingHandlersNodeView.setDimension(panel, width, height);
        return panel;
    }

    private JPanel createTypeSelectionPanel(ContributionProvider<ScrewdrivingHandlersNodeContribution> contributionProvider) {
        int successPanelHeight = 225;
        int errorPanelHeight = 175;
        JPanel panel = new JPanel();
        ScrewdrivingHandlersNodeView.setDimension(panel, 680, 425);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentX(0.0f);
        panel.setBorder(new EmptyBorder(0, 15, 0, 0));
        JPanel successPanel = new JPanel();
        ScrewdrivingHandlersNodeView.setDimension(successPanel, 680, successPanelHeight);
        successPanel.setLayout(new BoxLayout(successPanel, 0));
        JPanel successButtonPanel = new JPanel();
        successButtonPanel.setLayout(new BoxLayout(successButtonPanel, 1));
        successButtonPanel.setAlignmentX(0.0f);
        ScrewdrivingHandlersNodeView.setDimension(successButtonPanel, 300, successPanelHeight);
        this.okHandlerButton = ScrewdrivingHandlersNodeView.createHandlerButton(contributionProvider, this.textResource.ok(), HandlerType.HANDLER_UNTIL_OK, OK_BUTTON);
        this.timeHandlerButton = ScrewdrivingHandlersNodeView.createHandlerButton(contributionProvider, this.textResource.time(), HandlerType.HANDLER_UNTIL_TIME, TIME_BUTTON);
        this.distanceHandlerButton = ScrewdrivingHandlersNodeView.createHandlerButton(contributionProvider, this.textResource.distance(), HandlerType.HANDLER_UNTIL_DISTANCE, DISTANCE_BUTTON);
        this.expressionHandlerButton = ScrewdrivingHandlersNodeView.createHandlerButton(contributionProvider, this.textResource.expression(), HandlerType.HANDLER_UNTIL_EXPRESSION, EXPRESSION_BUTTON);
        JLabel successLabel = new JLabel(HTML.html((String)HTML.h2((String)this.textResource.success())));
        successLabel.setAlignmentX(0.0f);
        successButtonPanel.add(successLabel);
        successButtonPanel.add(this.okHandlerButton);
        successButtonPanel.add(this.timeHandlerButton);
        successButtonPanel.add(this.distanceHandlerButton);
        successButtonPanel.add(this.expressionHandlerButton);
        successButtonPanel.add(Box.createVerticalGlue());
        JLabel successIllustration = new JLabel(ImageResource.thumbsup());
        ScrewdrivingHandlersNodeView.setDimension(successIllustration, 300, successPanelHeight);
        successPanel.add(successButtonPanel);
        successPanel.add(successIllustration);
        panel.add(successPanel);
        JPanel separator = new JPanel();
        ScrewdrivingHandlersNodeView.setDimension(separator, 680, 2);
        separator.setBackground(BETWEEN_CARD_COLOR);
        separator.setBorder(new EmptyBorder(5, 0, 5, 0));
        panel.add(separator);
        JPanel errorPanel = new JPanel();
        ScrewdrivingHandlersNodeView.setDimension(errorPanel, 680, errorPanelHeight);
        errorPanel.setLayout(new BoxLayout(errorPanel, 0));
        JPanel errorButtonPanel = new JPanel();
        errorButtonPanel.setLayout(new BoxLayout(errorButtonPanel, 1));
        errorButtonPanel.setAlignmentX(0.0f);
        ScrewdrivingHandlersNodeView.setDimension(errorButtonPanel, 300, errorPanelHeight);
        this.notOkHandlerButton = ScrewdrivingHandlersNodeView.createHandlerButton(contributionProvider, this.textResource.handlerErrorNotOk(), HandlerType.HANDLER_ERROR_NOT_OK, NOT_OK_BUTTON);
        this.errorDistanceHandlerButton = ScrewdrivingHandlersNodeView.createHandlerButton(contributionProvider, this.textResource.handlerErrorDistance(), HandlerType.HANDLER_ERROR_DISTANCE, ERROR_DISTANCE_BUTTON);
        this.timeoutHandlerButton = ScrewdrivingHandlersNodeView.createHandlerButton(contributionProvider, this.textResource.handlerErrorTimeout(), HandlerType.HANDLER_ERROR_TIMEOUT, TIMEOUT_BUTTON);
        errorButtonPanel.add(Box.createVerticalGlue());
        JLabel errorLabel = new JLabel(HTML.html((String)HTML.h2((String)this.textResource.error())));
        errorLabel.setAlignmentX(0.0f);
        errorButtonPanel.add(errorLabel);
        errorButtonPanel.add(this.notOkHandlerButton);
        errorButtonPanel.add(this.errorDistanceHandlerButton);
        errorButtonPanel.add(this.timeoutHandlerButton);
        errorButtonPanel.add(Box.createVerticalGlue());
        JLabel errorIllustration = new JLabel(ImageResource.thumbsdown());
        ScrewdrivingHandlersNodeView.setDimension(errorIllustration, 300, errorPanelHeight);
        errorPanel.add(errorButtonPanel);
        errorPanel.add(errorIllustration);
        panel.add(errorPanel);
        return panel;
    }

    private static JButton createHandlerButton(ContributionProvider<ScrewdrivingHandlersNodeContribution> contributionProvider, String buttonText, HandlerType handlerType, String buttonName) {
        JButton handlerButton = new JButton(buttonText);
        handlerButton.setName(buttonName);
        ScrewdrivingHandlersNodeView.setDimension(handlerButton, 200, 45);
        handlerButton.addActionListener(e -> ((ScrewdrivingHandlersNodeContribution)contributionProvider.get()).setHandlerType(handlerType));
        handlerButton.setAlignmentX(0.0f);
        handlerButton.setBorder(new CompoundBorder(new EmptyBorder(5, 0, 5, 0), new LineBorder(G5LookAndFeel.UNIVERSAL_ROBOTS_DARK_BLUE)));
        return handlerButton;
    }

    private JPanel createConfigurationPanel(ContributionProvider<ScrewdrivingHandlersNodeContribution> contributionProvider) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentX(0.0f);
        ScrewdrivingHandlersNodeView.setDimension(panel, 680, 425);
        panel.setBorder(new EmptyBorder(0, 15, 0, 0));
        this.headerComboBox = new JComboBox();
        this.headerComboBox.setName(HANDLER_DROPDOWN);
        ScrewdrivingHandlersNodeView.setDimension(this.headerComboBox, 200, 35);
        this.headerComboBox.setModel((ComboBoxModel<HandlerType>)new EnumComboBoxModel(HandlerType.class, false));
        this.handlerRenderer = new HandlerTypeRenderer(this.textResource);
        ComboBoxRenderer.bindRenderer(this.headerComboBox, (RenderingStrategy)this.handlerRenderer);
        this.headerComboBox.addActionListener(e -> ((ScrewdrivingHandlersNodeContribution)contributionProvider.get()).setHandlerType((HandlerType)((Object)((Object)this.headerComboBox.getSelectedItem()))));
        JButton configurationDeleteButton = new JButton(ImageResource.delete());
        ScrewdrivingHandlersNodeView.setDimension(configurationDeleteButton, 40, 40);
        configurationDeleteButton.addActionListener(e -> ((ScrewdrivingHandlersNodeContribution)contributionProvider.get()).deleteNode());
        JPanel header = new JPanel();
        ScrewdrivingHandlersNodeView.setDimension(header, 680, 40);
        header.setAlignmentX(0.0f);
        header.setLayout(new BoxLayout(header, 0));
        header.add(this.headerComboBox);
        header.add(Box.createHorizontalGlue());
        this.untilTimeField = new JTextField();
        this.untilDistanceField = new JTextField();
        this.untilExpressionField = new JTextField();
        this.untilExpressionField.setHorizontalAlignment(0);
        this.errorDistanceField = new JTextField();
        this.errorTimeoutField = new JTextField();
        this.okConfigurationPanel = ScrewdrivingHandlersNodeView.createConfigurationPanel(new JPanel());
        this.timeConfigurationPanel = ScrewdrivingHandlersNodeView.createConfigurationPanel(this.createConfigurationContentPanel(contributionProvider, HandlerType.HANDLER_UNTIL_TIME, this.textResource.timeout(), Units.getText().unitS()));
        this.distanceConfigurationPanel = ScrewdrivingHandlersNodeView.createConfigurationPanel(this.createConfigurationContentPanel(contributionProvider, HandlerType.HANDLER_UNTIL_DISTANCE, this.textResource.distance(), Units.getText().unitMm()));
        this.expressionConfigurationPanel = ScrewdrivingHandlersNodeView.createConfigurationPanel(this.createConfigurationContentPanel(contributionProvider, HandlerType.HANDLER_UNTIL_EXPRESSION, this.textResource.expression(), null));
        this.notOkConfigurationPanel = ScrewdrivingHandlersNodeView.createConfigurationPanel(new JPanel());
        this.errorDistanceConfigurationPanel = ScrewdrivingHandlersNodeView.createConfigurationPanel(this.createConfigurationContentPanel(contributionProvider, HandlerType.HANDLER_ERROR_DISTANCE, this.textResource.distance(), Units.getText().unitMm()));
        this.timeoutConfigurationPanel = ScrewdrivingHandlersNodeView.createConfigurationPanel(this.createConfigurationContentPanel(contributionProvider, HandlerType.HANDLER_ERROR_TIMEOUT, this.textResource.timeout(), Units.getText().unitS()));
        panel.add(header);
        panel.add(this.okConfigurationPanel);
        panel.add(this.timeConfigurationPanel);
        panel.add(this.distanceConfigurationPanel);
        panel.add(this.expressionConfigurationPanel);
        panel.add(this.notOkConfigurationPanel);
        panel.add(this.errorDistanceConfigurationPanel);
        panel.add(this.timeoutConfigurationPanel);
        return panel;
    }

    private static JPanel createConfigurationPanel(JPanel contentPanel) {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(10, 0, 0, 0));
        panel.setAlignmentX(0.0f);
        ScrewdrivingHandlersNodeView.setDimension(panel, 680, 350);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(contentPanel);
        return panel;
    }

    private JPanel createConfigurationContentPanel(final ContributionProvider<ScrewdrivingHandlersNodeContribution> contributionProvider, final HandlerType handlerType, String textFieldLabel, String textFieldUnit) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        ScrewdrivingHandlersNodeView.setDimension(panel, 680, 100);
        JLabel inputHeader = new JLabel(textFieldLabel);
        inputHeader.setBorder(new EmptyBorder(0, 0, 5, 0));
        panel.add(inputHeader);
        JPanel inputPanel = new JPanel();
        inputPanel.setAlignmentX(0.0f);
        inputPanel.setLayout(new BoxLayout(inputPanel, 0));
        final JTextField textField = this.getConfigurationTextField(handlerType);
        if (textField != null) {
            ScrewdrivingHandlersNodeView.setDimension(textField, handlerType == HandlerType.HANDLER_UNTIL_EXPRESSION ? 300 : 100, 30);
            textField.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (handlerType == HandlerType.HANDLER_UNTIL_EXPRESSION) {
                        KeyboardExpressionInput keyboard = ((ScrewdrivingHandlersNodeContribution)contributionProvider.get()).getUntilExpressionKeyboard();
                        keyboard.show(textField, ((ScrewdrivingHandlersNodeContribution)contributionProvider.get()).getExpressionCallback());
                    } else {
                        KeyboardNumberInput<Double> keyboard = ((ScrewdrivingHandlersNodeContribution)contributionProvider.get()).getDoubleKeyboard(handlerType);
                        keyboard.show(textField, ((ScrewdrivingHandlersNodeContribution)contributionProvider.get()).getHandlerDoubleCallback(handlerType));
                    }
                }
            });
            inputPanel.add(textField);
        }
        if (textFieldUnit != null) {
            JLabel unitLabel = new JLabel(textFieldUnit);
            unitLabel.setBorder(new EmptyBorder(0, 5, 0, 0));
            ScrewdrivingHandlersNodeView.setDimension(unitLabel, 40, 30);
            inputPanel.add(unitLabel);
        }
        panel.add(inputPanel);
        return panel;
    }

    private JTextField getConfigurationTextField(HandlerType handlerType) {
        JTextField textField;
        switch (handlerType) {
            case HANDLER_UNTIL_TIME: {
                textField = this.untilTimeField;
                textField.setName(TIME_INPUT_FIELD);
                break;
            }
            case HANDLER_UNTIL_DISTANCE: {
                textField = this.untilDistanceField;
                textField.setName(DISTANCE_INPUT_FIELD);
                break;
            }
            case HANDLER_UNTIL_EXPRESSION: {
                textField = this.untilExpressionField;
                textField.setName(EXPRESSION_INPUT_FIELD);
                break;
            }
            case HANDLER_ERROR_DISTANCE: {
                textField = this.errorDistanceField;
                textField.setName(ERROR_DISTANCE_INPUT_FIELD);
                break;
            }
            case HANDLER_ERROR_TIMEOUT: {
                textField = this.errorTimeoutField;
                textField.setName(TIMEOUT_INPUT_FIELD);
                break;
            }
            default: {
                textField = null;
            }
        }
        return textField;
    }

    private void toggleButtons(CapabilitiesDefinition capabilities, boolean successHandlerExists, List<HandlerType> existingHandlers, boolean successHandlerOnly, boolean followScrewEnabled) {
        this.toggleSuccessButtons(capabilities, successHandlerExists, successHandlerOnly, followScrewEnabled);
        this.toggleErrorButtons(capabilities, existingHandlers, successHandlerOnly, followScrewEnabled);
    }

    private void toggleSuccessButtons(CapabilitiesDefinition capabilities, boolean successHandlerExists, boolean successHandlerOnly, boolean followScrewEnabled) {
        this.okHandlerButton.setEnabled(capabilities != null && capabilities.getCapability(Capability.CapabilityType.OK).isPresent() && (!successHandlerExists || successHandlerOnly));
        this.timeHandlerButton.setEnabled(!successHandlerExists || successHandlerOnly);
        this.distanceHandlerButton.setEnabled((!successHandlerExists || successHandlerOnly) && followScrewEnabled);
        this.expressionHandlerButton.setEnabled(!successHandlerExists || successHandlerOnly);
    }

    private void toggleErrorButtons(CapabilitiesDefinition capabilities, List<HandlerType> existingHandlers, boolean successHandlerOnly, boolean followScrewEnabled) {
        this.notOkHandlerButton.setEnabled(capabilities != null && capabilities.getCapability(Capability.CapabilityType.NOTOK).isPresent() && !existingHandlers.contains((Object)HandlerType.HANDLER_ERROR_NOT_OK) && !successHandlerOnly);
        this.errorDistanceHandlerButton.setEnabled(!existingHandlers.contains((Object)HandlerType.HANDLER_ERROR_DISTANCE) && !existingHandlers.contains((Object)HandlerType.HANDLER_UNTIL_DISTANCE) && !successHandlerOnly && followScrewEnabled);
        this.timeoutHandlerButton.setEnabled(!existingHandlers.contains((Object)HandlerType.HANDLER_ERROR_TIMEOUT) && !existingHandlers.contains((Object)HandlerType.HANDLER_UNTIL_TIME) && !successHandlerOnly);
    }

    private void updateComboBoxModel(CapabilitiesDefinition capabilities, HandlerType selectedType, List<HandlerType> existingHandlers, boolean successHandlerOnly, boolean followScrewEnabled) {
        existingHandlers.remove((Object)selectedType);
        this.handlerRenderer.clearIllegalTypes();
        ComboBoxModel<HandlerType> comboBoxModel = successHandlerOnly || selectedType.isSuccessState() ? this.updateSuccesHandlerComboBox(capabilities, followScrewEnabled) : this.updateErrorHandlerComboBox(capabilities, existingHandlers, followScrewEnabled);
        comboBoxModel.setSelectedItem((Object)selectedType);
        this.headerComboBox.setModel(comboBoxModel);
    }

    private ComboBoxModel<HandlerType> updateSuccesHandlerComboBox(CapabilitiesDefinition capabilities, boolean followScrewEnabled) {
        List<HandlerType> excluded = Arrays.stream(HandlerType.values()).filter(handlerType -> !handlerType.isSuccessState()).collect(Collectors.toList());
        if (capabilities == null || !capabilities.getCapability(Capability.CapabilityType.OK).isPresent()) {
            excluded.add(HandlerType.HANDLER_UNTIL_OK);
            this.handlerRenderer.addIllegalType(HandlerType.HANDLER_UNTIL_OK);
        }
        if (!followScrewEnabled) {
            excluded.add(HandlerType.HANDLER_UNTIL_DISTANCE);
            this.handlerRenderer.addIllegalType(HandlerType.HANDLER_UNTIL_DISTANCE);
        }
        EnumComboBoxModel comboBoxModel = new EnumComboBoxModel(HandlerType.class, (Enum[])excluded.toArray(new HandlerType[0]));
        return comboBoxModel;
    }

    private ComboBoxModel<HandlerType> updateErrorHandlerComboBox(CapabilitiesDefinition capabilities, List<HandlerType> existingHandlers, boolean followScrewEnabled) {
        List<HandlerType> excluded = Arrays.stream(HandlerType.values()).filter(o -> o.isSuccessState() || existingHandlers.contains(o)).collect(Collectors.toList());
        if (existingHandlers.contains((Object)HandlerType.HANDLER_UNTIL_TIME)) {
            excluded.add(HandlerType.HANDLER_ERROR_TIMEOUT);
            this.handlerRenderer.addIllegalType(HandlerType.HANDLER_ERROR_TIMEOUT);
        }
        if (existingHandlers.contains((Object)HandlerType.HANDLER_UNTIL_DISTANCE)) {
            excluded.add(HandlerType.HANDLER_ERROR_DISTANCE);
            this.handlerRenderer.addIllegalType(HandlerType.HANDLER_ERROR_DISTANCE);
        }
        if (capabilities == null || !capabilities.getCapability(Capability.CapabilityType.NOTOK).isPresent()) {
            excluded.add(HandlerType.HANDLER_ERROR_NOT_OK);
            this.handlerRenderer.addIllegalType(HandlerType.HANDLER_ERROR_NOT_OK);
        }
        if (!followScrewEnabled) {
            excluded.add(HandlerType.HANDLER_ERROR_DISTANCE);
            this.handlerRenderer.addIllegalType(HandlerType.HANDLER_ERROR_DISTANCE);
        }
        EnumComboBoxModel comboBoxModel = new EnumComboBoxModel(HandlerType.class, (Enum[])excluded.toArray(new HandlerType[0]));
        return comboBoxModel;
    }

    private void toggleConfigurationPanels(HandlerType selectedType) {
        this.okConfigurationPanel.setVisible(false);
        this.timeConfigurationPanel.setVisible(false);
        this.distanceConfigurationPanel.setVisible(false);
        this.expressionConfigurationPanel.setVisible(false);
        this.notOkConfigurationPanel.setVisible(false);
        this.errorDistanceConfigurationPanel.setVisible(false);
        this.timeoutConfigurationPanel.setVisible(false);
        switch (selectedType) {
            case HANDLER_UNTIL_OK: {
                this.okConfigurationPanel.setVisible(true);
                break;
            }
            case HANDLER_UNTIL_TIME: {
                this.timeConfigurationPanel.setVisible(true);
                break;
            }
            case HANDLER_UNTIL_DISTANCE: {
                this.distanceConfigurationPanel.setVisible(true);
                break;
            }
            case HANDLER_UNTIL_EXPRESSION: {
                this.expressionConfigurationPanel.setVisible(true);
                break;
            }
            case HANDLER_ERROR_NOT_OK: {
                this.notOkConfigurationPanel.setVisible(true);
                break;
            }
            case HANDLER_ERROR_DISTANCE: {
                this.errorDistanceConfigurationPanel.setVisible(true);
                break;
            }
            case HANDLER_ERROR_TIMEOUT: {
                this.timeoutConfigurationPanel.setVisible(true);
            }
        }
    }

    private void updateConfigurationValue(HandlerConfiguration handlerConfiguration, Length.Unit lengthUnit) {
        this.clearFields();
        Optional value = handlerConfiguration.getValue();
        if (value.isPresent()) {
            switch (handlerConfiguration.getHandlerType()) {
                case HANDLER_UNTIL_TIME: {
                    Double untilTime = (Double)value.get();
                    this.setValueIfPositive(untilTime, this.untilTimeField);
                    break;
                }
                case HANDLER_UNTIL_DISTANCE: {
                    Length untilDistance = (Length)value.get();
                    this.setLengthValue(untilDistance, lengthUnit, this.untilDistanceField);
                    break;
                }
                case HANDLER_UNTIL_EXPRESSION: {
                    String expression = value.get().toString();
                    this.untilExpressionField.setText(expression.isEmpty() ? "f(x)" : expression);
                    ScrewdrivingHandlersNodeView.setDimension(this.untilExpressionField, 450, 30);
                    break;
                }
                case HANDLER_ERROR_DISTANCE: {
                    Length errorDistance = (Length)value.get();
                    this.setLengthValue(errorDistance, lengthUnit, this.errorDistanceField);
                    break;
                }
                case HANDLER_ERROR_TIMEOUT: {
                    Double errorTimeout = (Double)value.get();
                    this.setValueIfPositive(errorTimeout, this.errorTimeoutField);
                    break;
                }
            }
        }
    }

    private void clearFields() {
        this.untilTimeField.setText("");
        this.untilDistanceField.setText("");
        this.untilExpressionField.setText("");
        this.errorDistanceField.setText("");
        this.errorTimeoutField.setText("");
    }

    private void setValueIfPositive(Double value, JTextField textField) {
        if (value > 0.0) {
            textField.setText(String.format("%.2f", value));
        } else {
            textField.setText("");
        }
    }

    private void setLengthValue(Length lengthValue, Length.Unit unit, JTextField textField) {
        if (lengthValue != null) {
            textField.setText(String.format("%.2f", lengthValue.getAs(unit)));
        } else {
            textField.setText("");
        }
    }

    private static void setDimension(JComponent component, int width, int height) {
        Dimension dimension = new Dimension(width, height);
        component.setMaximumSize(dimension);
        component.setMinimumSize(dimension);
        component.setPreferredSize(dimension);
    }
}

