/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.handlers;

import java.math.BigDecimal;
import java.math.RoundingMode;

public final class ValidatorHelper {
    private ValidatorHelper() {
    }

    public static boolean isValid(Double aDouble, Double maxValue) {
        if (ValidatorHelper.validDecimals(aDouble)) {
            return aDouble > 0.0 && aDouble <= maxValue;
        }
        return false;
    }

    public static boolean validDecimals(Double aDouble) {
        int integerPlaces;
        String text = Double.toString(Math.abs(aDouble));
        if (text.contains("E")) {
            BigDecimal bd = BigDecimal.valueOf(aDouble).setScale(10, RoundingMode.HALF_UP).stripTrailingZeros();
            text = bd.toPlainString();
        }
        if ((integerPlaces = text.indexOf(46)) <= -1) {
            return true;
        }
        int decimalPlaces = text.length() - integerPlaces - 1;
        return decimalPlaces < 3;
    }
}

