/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.installation;

import com.ur.polyscope.screwdriving.installation.NativeScrewdrivingConfiguration;
import com.ur.polyscope.screwdriving.internal.TextResource;
import com.ur.polyscope.screwdriving.program.IOscriptGeneration;
import com.ur.polyscope.screwdriving.program.ScrewdriverProgramImpl;
import com.ur.polyscope.screwdriving.simpsons.CapabilitiesDefinition;
import com.ur.polyscope.screwdriving.simpsons.Capability;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.screwdriverprogram.ScrewdriverProgram;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.screwdriverprogram.ScrewdriverProgramListProvider;
import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.api.domain.tcp.TCP;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

final class CapabilityGenerator {
    private static final String RETURN_TRUE = "return True";

    private CapabilityGenerator() {
    }

    static CapabilitiesDefinition generateNativeCapabilitiesDefinition(NativeScrewdrivingConfiguration nativeScrewdrivingConfiguration, TextResource textResource, Locale locale) {
        IO[] programSelectionOutputs;
        boolean hasProgramSelection;
        CapabilitiesDefinition result = new CapabilitiesDefinition();
        result.setNative(true);
        result.setRequireTCP(true);
        result.setSupportOperationType(true);
        TCP tcp = nativeScrewdrivingConfiguration.getTcp();
        if (tcp != null || nativeScrewdrivingConfiguration.getReadyInput() != null) {
            CapabilityGenerator.addPrepareCapability(nativeScrewdrivingConfiguration, locale, result, tcp);
            result.setTcp(tcp);
        }
        if (nativeScrewdrivingConfiguration.getStartOutput() != null) {
            result.addCapability(new Capability(Capability.CapabilityType.START_DRIVE_SCREW, (scriptWriter, parameters) -> IOscriptGeneration.generateSetBinaryIO(scriptWriter, nativeScrewdrivingConfiguration.getStartOutput(), true), null, locale));
            result.addCapability(new Capability(Capability.CapabilityType.STOP_DRIVE_SCREW, (scriptWriter, parameters) -> IOscriptGeneration.generateSetBinaryIO(scriptWriter, nativeScrewdrivingConfiguration.getStartOutput(), false), null, locale));
            String condition = IOscriptGeneration.generateIOCondition(nativeScrewdrivingConfiguration.getStartOutput(), false);
            result.registerStartActiveCondition(condition);
        }
        if (nativeScrewdrivingConfiguration.getOkInput() != null) {
            result.addCapability(new Capability(Capability.CapabilityType.OK, (scriptWriter, parameters) -> scriptWriter.appendLine("return " + IOscriptGeneration.generateIOCondition(nativeScrewdrivingConfiguration.getOkInput(), true)), null, locale));
        }
        if (nativeScrewdrivingConfiguration.getNokInput() != null) {
            result.addCapability(new Capability(Capability.CapabilityType.NOTOK, (scriptWriter, parameters) -> scriptWriter.appendLine("return " + IOscriptGeneration.generateIOCondition(nativeScrewdrivingConfiguration.getNokInput(), true)), null, locale));
        }
        if (hasProgramSelection = Arrays.stream(programSelectionOutputs = nativeScrewdrivingConfiguration.getProgramSelectionOutputs()).anyMatch(Objects::nonNull)) {
            CapabilityGenerator.addProgramSelectionCapability(nativeScrewdrivingConfiguration, textResource, locale, result);
        }
        return result;
    }

    private static void addPrepareCapability(NativeScrewdrivingConfiguration nativeScrewdrivingConfiguration, Locale locale, CapabilitiesDefinition result, TCP tcp) {
        result.addCapability(new Capability(Capability.CapabilityType.PREPARE, (scriptWriter, parameters) -> {
            if (tcp != null) {
                scriptWriter.set_tcp(tcp);
            }
            if (nativeScrewdrivingConfiguration.getReadyInput() != null) {
                scriptWriter.whileNot(IOscriptGeneration.generateIOCondition(nativeScrewdrivingConfiguration.getReadyInput(), true));
                scriptWriter.sleep(0.01);
                scriptWriter.end();
            }
            scriptWriter.appendLine(RETURN_TRUE);
        }, null, locale));
    }

    private static void addProgramSelectionCapability(NativeScrewdrivingConfiguration nativeScrewdrivingConfiguration, TextResource textResource, Locale locale, CapabilitiesDefinition result) {
        if (CapabilityGenerator.isBitwiseSelection(nativeScrewdrivingConfiguration)) {
            result.setProgramListProvider(CapabilityGenerator.getSelectablePrograms(nativeScrewdrivingConfiguration, textResource));
            result.setBitwiseProgramSelection(true);
        } else {
            result.setBitwiseProgramSelection(false);
        }
        result.addCapability(new Capability(Capability.CapabilityType.PROGRAM_SELECTION, (scriptWriter, parameters) -> {
            Integer program;
            ScrewdriverProgram screwdriverProgram = parameters.getScrewdriverProgram();
            if (screwdriverProgram != null && (program = Integer.valueOf(screwdriverProgram.getId())) >= 0) {
                IOscriptGeneration.generateProgramSelection(scriptWriter, nativeScrewdrivingConfiguration.getProgramSelectionOutputs(), program);
                double delayTimeInSeconds = nativeScrewdrivingConfiguration.getDelayTimeInSeconds();
                scriptWriter.sleep(delayTimeInSeconds);
            }
            scriptWriter.appendLine(RETURN_TRUE);
        }, null, locale));
    }

    private static boolean isBitwiseSelection(NativeScrewdrivingConfiguration configuration) {
        IO[] outputs;
        boolean bitwiseSelection = true;
        for (IO output : outputs = configuration.getProgramSelectionOutputs()) {
            if (output == null || output.getType() != IO.IOType.INTEGER) continue;
            bitwiseSelection = false;
        }
        return bitwiseSelection;
    }

    private static ScrewdriverProgramListProvider getSelectablePrograms(NativeScrewdrivingConfiguration configuration, TextResource textResource) {
        ArrayList<ScrewdriverProgram> result = new ArrayList<ScrewdriverProgram>();
        int numberOfBitsAvailable = CapabilityGenerator.numberOfBitsAvailable(configuration);
        for (int i = 0; i < numberOfBitsAvailable; ++i) {
            String displayName = CapabilityGenerator.generateProgramTextEntryForIndex(i, textResource);
            result.add(CapabilityGenerator.createScrewdriverProgram("" + i, displayName));
        }
        if (numberOfBitsAvailable > 0) {
            result.add(0, CapabilityGenerator.createScrewdriverProgram("-1", textResource.selectProgram()));
        }
        return programList -> programList.addAll(result);
    }

    private static int numberOfBitsAvailable(NativeScrewdrivingConfiguration configuration) {
        IO[] programSelectionOutputs = configuration.getProgramSelectionOutputs();
        int numberOfBits = 0;
        for (IO programSelectionOutput : programSelectionOutputs) {
            if (programSelectionOutput == null) continue;
            ++numberOfBits;
        }
        if (numberOfBits == 0) {
            return 0;
        }
        double combinations = Math.pow(2.0, numberOfBits);
        return (int)combinations;
    }

    private static String generateProgramTextEntryForIndex(int index, TextResource textResource) {
        return textResource.program() + "-" + index;
    }

    private static ScrewdriverProgram createScrewdriverProgram(String id, String name) {
        return new ScrewdriverProgramImpl(id, name);
    }
}

