/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.installation;

import com.ur.polyscope.screwdriving.installation.MissingScrewDriver;
import com.ur.polyscope.screwdriving.installation.ScrewdriverSelection;
import com.ur.polyscope.screwdriving.simpsons.installation.ProxyScrewdriverInstallationNodeService;
import com.ur.polyscope.screwdriving.simpsons.installation.SelectableScrewdriver;
import com.ur.urcap.api.domain.data.DataModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ScrewdriverSelectionImpl
implements ScrewdriverSelection {
    static final String KEY_DRIVER_ID = "selectedDriverID";
    static final String KEY_DRIVER_TITLE = "selectedDriverTitle";
    private final DataModel dataModel;
    private final List<ProxyScrewdriverInstallationNodeService> screwdriverServices;
    private Class serviceClass;
    private Locale locale;

    public ScrewdriverSelectionImpl(DataModel dataModel, List<ProxyScrewdriverInstallationNodeService> screwdriverServices, Class serviceClass, Locale locale) {
        this.dataModel = dataModel;
        this.screwdriverServices = new ArrayList<ProxyScrewdriverInstallationNodeService>(screwdriverServices);
        this.serviceClass = serviceClass;
        this.locale = locale;
    }

    @Override
    public String getId() {
        SelectableScrewdriver selectableScrewdriver = this.get();
        if (selectableScrewdriver != null) {
            return selectableScrewdriver.getProxiedId();
        }
        return this.getIDfromDataModel();
    }

    @Override
    public Class<?> getServiceClass() {
        SelectableScrewdriver selectableScrewdriver = this.get();
        if (selectableScrewdriver instanceof ProxyScrewdriverInstallationNodeService) {
            return ((ProxyScrewdriverInstallationNodeService)selectableScrewdriver).getProxiedService();
        }
        return this.serviceClass;
    }

    @Override
    public SelectableScrewdriver get() {
        String id = this.getIDfromDataModel();
        SelectableScrewdriver proxy = null;
        if (id != null && !id.isEmpty() && (proxy = (SelectableScrewdriver)this.screwdriverServices.stream().filter(selectableScrewdriver -> id.equals(selectableScrewdriver.getProxiedId())).findAny().orElse(null)) == null) {
            proxy = this.createSelectableScrewdriver(id, this.getScrewdriverTitle());
        }
        return proxy;
    }

    @Override
    public void set(SelectableScrewdriver selectedScrewdriver) {
        if (selectedScrewdriver != null) {
            if (selectedScrewdriver instanceof ProxyScrewdriverInstallationNodeService) {
                ProxyScrewdriverInstallationNodeService proxyScrewdriverInstallationNodeService = (ProxyScrewdriverInstallationNodeService)selectedScrewdriver;
                this.setStringInDataModel(KEY_DRIVER_ID, proxyScrewdriverInstallationNodeService.getProxiedId());
                this.setStringInDataModel(KEY_DRIVER_TITLE, proxyScrewdriverInstallationNodeService.getTitle(this.locale));
            }
        } else {
            this.setStringInDataModel(KEY_DRIVER_ID, null);
            this.setStringInDataModel(KEY_DRIVER_TITLE, null);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.dataModel.get(KEY_DRIVER_ID, (String)null) == null;
    }

    private String getIDfromDataModel() {
        return this.dataModel.get(KEY_DRIVER_ID, "");
    }

    private SelectableScrewdriver createSelectableScrewdriver(String id, String screwdriverTitle) {
        return new MissingScrewDriver(id, screwdriverTitle);
    }

    private String getScrewdriverTitle() {
        return this.dataModel.get(KEY_DRIVER_TITLE, "");
    }

    private void setStringInDataModel(String key, String value) {
        this.dataModel.set(key, value);
    }
}

