/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.installation;

import com.ur.polyscope.screwdriving.installation.CapabilityGenerator;
import com.ur.polyscope.screwdriving.installation.MissingScrewDriver;
import com.ur.polyscope.screwdriving.installation.NativeScrewdrivingConfiguration;
import com.ur.polyscope.screwdriving.installation.ScrewdriverSelection;
import com.ur.polyscope.screwdriving.installation.ScrewdrivingInstallationNodeView;
import com.ur.polyscope.screwdriving.internal.ProgramNodeContext;
import com.ur.polyscope.screwdriving.internal.ScrewdrivingProgramContext;
import com.ur.polyscope.screwdriving.internal.TextResource;
import com.ur.polyscope.screwdriving.model.IOFilter;
import com.ur.polyscope.screwdriving.simpsons.CapabilitiesDefinition;
import com.ur.polyscope.screwdriving.simpsons.Capability;
import com.ur.polyscope.screwdriving.simpsons.installation.ProxyScrewdriverInstallationNodeService;
import com.ur.polyscope.screwdriving.simpsons.installation.SelectableScrewdriver;
import com.ur.polyscope.screwdriving.util.ImageUtilities;
import com.ur.polyscope.urcaps.exception.ProxiedException;
import com.ur.polyscope.urcaps.extensions.installationnodecontribution.menu.InstallationMenuCategory;
import com.ur.polyscope.urcaps.extensions.io.IOextension;
import com.ur.swing.units.Units;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.contribution.driver.screwdriver.ScrewdriverContribution;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.InstallationAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.tcp.TCP;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.util.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ScrewdrivingInstallationNodeContribution
implements InstallationNodeContribution,
InstallationMenuCategory {
    private static final String KEY_TCP = "tcp";
    private static final String KEY_OK_INPUT = "okInput";
    private static final String KEY_NOK_INPUT = "nokInput";
    private static final String KEY_READY_INPUT = "readyInput";
    private static final String KEY_PROGRAM_OUTPUT_1 = "programOutput1";
    private static final String KEY_PROGRAM_OUTPUT_2 = "programOutput2";
    private static final String KEY_PROGRAM_OUTPUT_3 = "programOutput3";
    private static final String KEY_PROGRAM_OUTPUT_4 = "programOutput4";
    private static final String KEY_START_OUTPUT = "startOutput";
    private static final String KEY_DELAY = "programSelectionDelay";
    private static final String CHECK_OK_FUNCTION = "screwdriver_is_ok_set";
    private static final String CHECK_NOK_FUNCTION = "screwdriver_is_nok_set";
    private static final String CHECK_READY_FUNCTION = "screwdriver_is_ready_set";
    private static final String PERFORM_PROGRAM_SELECTION_FUNCTION = "screwdriver_perform_program_selection";
    private static final String PERFORM_PREPARE_FUNCTION = "screwdriver_prepare_to_drive";
    private static final String PERFORM_FEED_SCREW_FUNCTION = "screwdriver_perform_feed_screw";
    private final DataModel dataModel;
    private final InstallationAPI installationAPI;
    private final ScrewdrivingInstallationNodeView view;
    private final KeyboardInputFactory keyboardFactory;
    private final List<? extends SelectableScrewdriver> screwdriverServices;
    private final ScrewdriverSelection screwdriverSelection;
    private final ScrewdrivingProgramContext screwdrivingProgramContext;
    private IOFilter selectedIOType;
    private Locale locale;
    private TextResource textResource;
    private IOextension.OutputAction previousOutputAction = IOextension.OutputAction.NONE;
    private boolean datamodelUpdated = true;
    private CapabilitiesDefinition nativeCapabilitiesDefinition;

    ScrewdrivingInstallationNodeContribution(DataModel dataModel, InstallationAPIProvider installationAPIProvider, ScrewdrivingInstallationNodeView view, TextResource textResource, List<ProxyScrewdriverInstallationNodeService> services, ScrewdriverSelection screwdriverSelection, ScrewdrivingProgramContext screwdrivingProgramContext) {
        this.dataModel = dataModel;
        this.installationAPI = installationAPIProvider.getInstallationAPI();
        this.view = view;
        this.keyboardFactory = installationAPIProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory();
        this.locale = installationAPIProvider.getSystemAPI().getSystemSettings().getLocalization().getLocale();
        this.textResource = textResource;
        this.screwdriverServices = new ArrayList<ProxyScrewdriverInstallationNodeService>(services);
        this.screwdriverSelection = screwdriverSelection;
        this.screwdrivingProgramContext = screwdrivingProgramContext;
    }

    public void openView() {
        this.updateView();
    }

    public void closeView() {
    }

    public void generateScript(ScriptWriter scriptWriter) {
        SelectableScrewdriver sd = this.screwdriverSelection.get();
        if (sd instanceof MissingScrewDriver) {
            return;
        }
        if (sd != null) {
            ProxyScrewdriverInstallationNodeService proxy = (ProxyScrewdriverInstallationNodeService)sd;
            ScrewdriverContribution contribution = proxy.getScrewdriverContribution();
            scriptWriter.appendLine("# begin: URCap Installation Node");
            scriptWriter.appendLine("#  Source: " + proxy.getSymbolicName());
            scriptWriter.appendLine("#  Type: " + this.getContributionTitle(contribution));
            this.addPreamble(scriptWriter, contribution);
            scriptWriter.appendLine("# end: URCap Installation Node");
        }
        for (ProgramNodeContext programNodeParameter : this.screwdrivingProgramContext.getAllProgramNodeContexts()) {
            this.generateUtilityFunctions(scriptWriter, programNodeParameter);
        }
    }

    private void addPreamble(ScriptWriter scriptWriter, ScrewdriverContribution contribution) {
        try {
            contribution.generatePreambleScript(scriptWriter);
        }
        catch (RuntimeException e) {
            throw new ProxiedException(e, contribution.getClass(), "com.ur.polyscope.screwdriving.installation.ScrewdrivingInstallationNodeContribution", "addPreamble");
        }
    }

    private String getContributionTitle(ScrewdriverContribution contribution) {
        try {
            return contribution.getTitle(this.locale);
        }
        catch (RuntimeException e) {
            throw new ProxiedException(e, contribution.getClass(), "com.ur.polyscope.screwdriving.installation.ScrewdrivingInstallationNodeContribution", "getContributionTitle");
        }
    }

    public Icon getLogo() {
        SelectableScrewdriver sd = this.screwdriverSelection.get();
        if (sd != null) {
            ImageIcon logo = sd.getLogo();
            return logo != null ? ImageUtilities.createScaledLogo(logo, 100, 100) : null;
        }
        return null;
    }

    public String getTitle() {
        SelectableScrewdriver sd = this.screwdriverSelection.get();
        if (sd != null) {
            return sd.getTitle(this.locale);
        }
        return this.textResource.userDefinedScrewdriver();
    }

    private void generateUtilityFunctions(ScriptWriter scriptWriter, ProgramNodeContext context) {
        Optional<CapabilitiesDefinition> capabilitiesDefinition = this.getCapabilitiesDefinition();
        if (capabilitiesDefinition.isPresent()) {
            CapabilitiesDefinition definition = capabilitiesDefinition.get();
            this.createCapabilityFunction(scriptWriter, Capability.CapabilityType.OK, definition, context);
            this.createCapabilityFunction(scriptWriter, Capability.CapabilityType.NOTOK, definition, context);
            this.createCapabilityFunction(scriptWriter, Capability.CapabilityType.MACHINE_READY, definition, context);
            this.createCapabilityFunction(scriptWriter, Capability.CapabilityType.PROGRAM_SELECTION, definition, context);
            this.createCapabilityFunction(scriptWriter, Capability.CapabilityType.FEED_SCREW, definition, context);
            this.createCapabilityFunction(scriptWriter, Capability.CapabilityType.PREPARE, definition, context);
        }
    }

    private void createCapabilityFunction(ScriptWriter scriptWriter, Capability.CapabilityType capabilityType, CapabilitiesDefinition capabilitiesDefinition, ProgramNodeContext context) {
        Optional<Capability> capability = capabilitiesDefinition.getCapability(capabilityType);
        capability.ifPresent(cap -> {
            scriptWriter.defineFunction(this.getFunctionNameFromCapabilityType(capabilityType, context.getIndex()));
            cap.generateScript(scriptWriter, context.getOperationParameters());
            scriptWriter.end();
        });
    }

    private String getFunctionNameFromCapabilityType(Capability.CapabilityType capabilityType, int index) {
        String result = null;
        switch (capabilityType) {
            case MACHINE_READY: {
                result = CHECK_READY_FUNCTION;
                break;
            }
            case PROGRAM_SELECTION: {
                result = PERFORM_PROGRAM_SELECTION_FUNCTION;
                break;
            }
            case FEED_SCREW: {
                result = PERFORM_FEED_SCREW_FUNCTION;
                break;
            }
            case PREPARE: {
                result = PERFORM_PREPARE_FUNCTION;
                break;
            }
            case OK: {
                result = CHECK_OK_FUNCTION;
                break;
            }
            case NOTOK: {
                result = CHECK_NOK_FUNCTION;
                break;
            }
        }
        if (result != null) {
            result = result + "_" + index;
        }
        return result;
    }

    public String getFunctionNameForCapability(String programNodeId, Capability.CapabilityType type) {
        return this.getFunctionNameFromCapabilityType(type, this.getIndexForProgramNode(programNodeId));
    }

    private int getIndexForProgramNode(String programNodeId) {
        Optional<ProgramNodeContext> context = this.screwdrivingProgramContext.getAllProgramNodeContexts().stream().filter(programNodeContext -> programNodeContext.getProgramNodeId().equals(programNodeId)).findFirst();
        return context.map(ProgramNodeContext::getIndex).orElse(-1);
    }

    private NativeScrewdrivingConfiguration getScrewdrivingConfiguration() {
        NativeScrewdrivingConfiguration result = new NativeScrewdrivingConfiguration();
        result.setTcp(this.getTCP());
        result.setOkInput(this.getIOFromDataModel(KEY_OK_INPUT));
        result.setNokInput(this.getIOFromDataModel(KEY_NOK_INPUT));
        result.setReadyInput(this.getIOFromDataModel(KEY_READY_INPUT));
        result.setProgramSelectionOutputs(this.getSelectedProgramIOs());
        result.setStartOutput(this.getIOFromDataModel(KEY_START_OUTPUT));
        result.setDelayTimeInSeconds(this.dataModel.get(KEY_DELAY, 1.0));
        result.setSD(this.screwdriverSelection.get());
        return result;
    }

    public boolean isDefined() {
        SelectableScrewdriver currentSimpsonScrewdriver = this.screwdriverSelection.get();
        if (currentSimpsonScrewdriver instanceof MissingScrewDriver) {
            return false;
        }
        return currentSimpsonScrewdriver == null || ((ProxyScrewdriverInstallationNodeService)currentSimpsonScrewdriver).isDefined();
    }

    public Optional<CapabilitiesDefinition> getCapabilitiesDefinition() {
        SelectableScrewdriver currentSimpsonScrewdriver = this.screwdriverSelection.get();
        CapabilitiesDefinition result = null;
        if (currentSimpsonScrewdriver != null) {
            if (currentSimpsonScrewdriver instanceof ProxyScrewdriverInstallationNodeService) {
                result = ((ProxyScrewdriverInstallationNodeService)currentSimpsonScrewdriver).getScrewdriverContext().getCapabilitiesDefinition();
            }
        } else if (this.datamodelUpdated) {
            this.nativeCapabilitiesDefinition = result = CapabilityGenerator.generateNativeCapabilitiesDefinition(this.getScrewdrivingConfiguration(), this.textResource, this.locale);
            this.datamodelUpdated = false;
        } else {
            result = this.nativeCapabilitiesDefinition;
        }
        return Optional.ofNullable(result);
    }

    void setTCP(TCP selectedTCP) {
        this.setTCPInDataModel(selectedTCP);
        this.updateView();
    }

    void setSD(SelectableScrewdriver selectedSD) {
        this.setNativeStartIOAction(selectedSD);
        this.screwdriverSelection.set(selectedSD);
        this.datamodelUpdated = true;
        this.updateView();
    }

    private void setNativeStartIOAction(SelectableScrewdriver selectedSD) {
        IO startIO;
        boolean selectedDriverNative;
        boolean previousDriverNative = this.screwdriverSelection.isEmpty();
        boolean bl = selectedDriverNative = selectedSD == null;
        if (previousDriverNative && !selectedDriverNative) {
            this.resetCurrentStartIOAction();
        } else if (!previousDriverNative && selectedDriverNative && (startIO = this.getIOFromDataModel(KEY_START_OUTPUT)) != null) {
            this.setStartOutputIOAction(startIO);
        }
    }

    void setSelectedIOType(IOFilter ioType) {
        this.selectedIOType = ioType;
        this.updateView();
    }

    void setOKInput(IO input) {
        if (input != null) {
            this.setStringInDataModel(KEY_OK_INPUT, input.getDefaultName());
        } else {
            this.removeValueFromDataModel(KEY_OK_INPUT);
        }
        this.updateView();
    }

    void setNOKInput(IO input) {
        if (input != null) {
            this.setStringInDataModel(KEY_NOK_INPUT, input.getDefaultName());
        } else {
            this.removeValueFromDataModel(KEY_NOK_INPUT);
        }
        this.updateView();
    }

    void setReadyInput(IO input) {
        if (input != null) {
            this.setStringInDataModel(KEY_READY_INPUT, input.getDefaultName());
        } else {
            this.removeValueFromDataModel(KEY_READY_INPUT);
        }
        this.updateView();
    }

    void setProgramOutput(IO output, int index) {
        String key = ScrewdrivingInstallationNodeContribution.getProgramOutputKey(index);
        if (key != null) {
            if (output != null) {
                this.setStringInDataModel(key, output.getDefaultName());
                this.handleIntegerRegister(output, index);
            } else {
                this.removeValueFromDataModel(key);
            }
            this.updateView();
        }
    }

    private void handleIntegerRegister(IO output, int index) {
        if (output.getType() == IO.IOType.INTEGER) {
            switch (index) {
                case 1: {
                    this.removeValueFromDataModel(KEY_PROGRAM_OUTPUT_2);
                    this.removeValueFromDataModel(KEY_PROGRAM_OUTPUT_3);
                    this.removeValueFromDataModel(KEY_PROGRAM_OUTPUT_4);
                    break;
                }
                case 2: {
                    this.removeValueFromDataModel(KEY_PROGRAM_OUTPUT_1);
                    this.removeValueFromDataModel(KEY_PROGRAM_OUTPUT_3);
                    this.removeValueFromDataModel(KEY_PROGRAM_OUTPUT_4);
                    break;
                }
                case 3: {
                    this.removeValueFromDataModel(KEY_PROGRAM_OUTPUT_1);
                    this.removeValueFromDataModel(KEY_PROGRAM_OUTPUT_2);
                    this.removeValueFromDataModel(KEY_PROGRAM_OUTPUT_4);
                    break;
                }
                case 4: {
                    this.removeValueFromDataModel(KEY_PROGRAM_OUTPUT_1);
                    this.removeValueFromDataModel(KEY_PROGRAM_OUTPUT_2);
                    this.removeValueFromDataModel(KEY_PROGRAM_OUTPUT_3);
                    break;
                }
            }
        }
    }

    private static String getProgramOutputKey(int index) {
        String key;
        switch (index) {
            case 1: {
                key = KEY_PROGRAM_OUTPUT_1;
                break;
            }
            case 2: {
                key = KEY_PROGRAM_OUTPUT_2;
                break;
            }
            case 3: {
                key = KEY_PROGRAM_OUTPUT_3;
                break;
            }
            case 4: {
                key = KEY_PROGRAM_OUTPUT_4;
                break;
            }
            default: {
                key = null;
            }
        }
        return key;
    }

    void setStartOutput(IO output) {
        this.resetCurrentStartIOAction();
        if (output != null) {
            this.setStringInDataModel(KEY_START_OUTPUT, output.getDefaultName());
            this.setStartOutputIOAction(output);
        } else {
            this.removeValueFromDataModel(KEY_START_OUTPUT);
        }
        this.updateView();
    }

    private void resetCurrentStartIOAction() {
        IO previousIO = this.getIOFromDataModel(KEY_START_OUTPUT);
        if (previousIO instanceof IOextension) {
            ((IOextension)previousIO).setOutputIOAction(this.previousOutputAction);
        }
        this.previousOutputAction = IOextension.OutputAction.NONE;
    }

    private void setStartOutputIOAction(IO startIO) {
        if (startIO instanceof IOextension) {
            IOextension iOextension = (IOextension)startIO;
            this.previousOutputAction = iOextension.getOutputIOAction();
            iOextension.setOutputIOAction(IOextension.OutputAction.LOW_WHEN_PROGRAM_STOPPED);
        }
    }

    KeyboardNumberInput<Double> getDelayKeyboard() {
        KeyboardNumberInput keyboard = this.keyboardFactory.createPositiveDoubleKeypadInput();
        double delay = this.getProgramSelectionDelay();
        if (delay > 0.0) {
            keyboard.setInitialValue((Object)delay);
        }
        keyboard.setErrorValidator((InputValidator)new InputValidator<Double>(){

            public boolean isValid(Double aDouble) {
                return aDouble != null && aDouble > 0.0 && aDouble <= 300.0;
            }

            public String getMessage(Double aDouble) {
                return aDouble > 0.0 ? ScrewdrivingInstallationNodeContribution.this.textResource.valueMustBeLessThan("300", Units.getText().unitSeconds()) : ScrewdrivingInstallationNodeContribution.this.textResource.valueMustBeLargerThanZero();
            }
        });
        return keyboard;
    }

    KeyboardInputCallback<Double> getDelayCallback() {
        return new KeyboardInputCallback<Double>(){

            public void onOk(Double aDouble) {
                ScrewdrivingInstallationNodeContribution.this.setProgramSelectionDelay(aDouble);
            }
        };
    }

    private double getProgramSelectionDelay() {
        return this.dataModel.get(KEY_DELAY, 1.0);
    }

    private void setProgramSelectionDelay(double delay) {
        this.setDoubleInDataModel(delay);
        this.updateView();
    }

    private void updateView() {
        SelectableScrewdriver selectedScrewdriver;
        ScrewdrivingInstallationNodeView.ViewData viewData = new ScrewdrivingInstallationNodeView.ViewData();
        viewData.allInputs = this.installationAPI.getIOModel().getIOs(this.getInputFilter());
        viewData.programSelectionOutputs = this.installationAPI.getIOModel().getIOs(this.getOutputFilter(true));
        viewData.startOutputs = this.installationAPI.getIOModel().getIOs(this.getOutputFilter(false));
        viewData.selectableScrewdrivers = new ArrayList<SelectableScrewdriver>(this.screwdriverServices);
        viewData.selectedScrewdriver = selectedScrewdriver = this.screwdriverSelection.get();
        viewData.tcps = this.installationAPI.getTCPModel().getTCPs();
        if (selectedScrewdriver != null) {
            selectedScrewdriver.updateWrappedView();
        }
        this.view.updateView(this.getScrewdrivingConfiguration(), viewData);
    }

    private Filter<IO> getInputFilter() {
        Filter<IO> result = this.selectedIOType == null ? io -> io.isInput() && (io.getType() == IO.IOType.DIGITAL || io.getType() == IO.IOType.BOOLEAN) : this.createInputFilter();
        return result;
    }

    private Filter<IO> createInputFilter() {
        Filter result;
        switch (this.selectedIOType) {
            case DIGITAL: {
                result = io -> io.isInput() && io.getType() == IO.IOType.DIGITAL && this.assertIOInterfaceTypes((IO)io, IO.InterfaceType.UR_STANDARD, IO.InterfaceType.UR_CONFIGURABLE, IO.InterfaceType.UR_TOOL);
                break;
            }
            case REGISTERS: {
                result = io -> io.isInput() && io.getInterfaceType() == IO.InterfaceType.UR_GENERAL_PURPOSE && io.getType() == IO.IOType.BOOLEAN;
                break;
            }
            case MODBUS: {
                result = io -> io.isInput() && io.getInterfaceType() == IO.InterfaceType.UR_MODBUS && io.getType() == IO.IOType.DIGITAL;
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)this.selectedIOType) + " is not applicable");
            }
        }
        return result;
    }

    private Filter<IO> getOutputFilter(boolean allowIntegerRegister) {
        Filter<IO> result = this.selectedIOType == null ? io -> {
            boolean isInput = !io.isInput();
            boolean correctType = io.getType() == IO.IOType.DIGITAL || io.getType() == IO.IOType.BOOLEAN || allowIntegerRegister && io.getType() == IO.IOType.INTEGER;
            return isInput && correctType;
        } : this.createOutputFilter(allowIntegerRegister);
        return result;
    }

    private Filter<IO> createOutputFilter(boolean allowIntegerRegister) {
        Filter<IO> result;
        switch (this.selectedIOType) {
            case DIGITAL: {
                result = this.digitalOutputFilter();
                break;
            }
            case REGISTERS: {
                result = this.registersOutputFilter(allowIntegerRegister);
                break;
            }
            case MODBUS: {
                result = this.modbusOutputFilter(allowIntegerRegister);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)this.selectedIOType) + " is not applicable");
            }
        }
        return result;
    }

    private Filter<IO> digitalOutputFilter() {
        return io -> {
            boolean correctType = io.getType() == IO.IOType.DIGITAL && this.assertIOInterfaceTypes((IO)io, IO.InterfaceType.UR_STANDARD, IO.InterfaceType.UR_TOOL, IO.InterfaceType.UR_CONFIGURABLE);
            return !io.isInput() && correctType;
        };
    }

    private Filter<IO> registersOutputFilter(boolean allowIntegerRegister) {
        return io -> {
            boolean correctType = this.assertIOInterfaceTypes((IO)io, IO.InterfaceType.UR_GENERAL_PURPOSE) && (allowIntegerRegister && io.getType() == IO.IOType.INTEGER || io.getType() == IO.IOType.BOOLEAN);
            return !io.isInput() && correctType;
        };
    }

    private Filter<IO> modbusOutputFilter(boolean allowIntegerRegister) {
        return io -> {
            boolean correctType = this.assertIOInterfaceTypes((IO)io, IO.InterfaceType.UR_MODBUS) && (allowIntegerRegister && io.getType() == IO.IOType.INTEGER || io.getType() == IO.IOType.DIGITAL);
            return !io.isInput() && correctType;
        };
    }

    private IO[] getSelectedProgramIOs() {
        IO[] result = new IO[4];
        String[] bits = this.getProgramSelectionFromDataModel();
        for (int i = 0; i < bits.length; ++i) {
            String bit = bits[i];
            IO io = this.findIO(bit);
            if (io == null) continue;
            result[i] = io;
        }
        return result;
    }

    private boolean assertIOInterfaceTypes(IO io, IO.InterfaceType ... types) {
        for (IO.InterfaceType type : types) {
            if (io.getInterfaceType() != type) continue;
            return true;
        }
        return false;
    }

    private TCP getTCP() {
        TCP datamodelTCP = this.dataModel.get(KEY_TCP, (TCP)null);
        if (datamodelTCP != null) {
            Collection tcps = this.installationAPI.getTCPModel().getTCPs();
            for (TCP tcp : tcps) {
                if (!tcp.getDisplayName().equals(datamodelTCP.getDisplayName())) continue;
                return tcp;
            }
        }
        return null;
    }

    private IO getIOFromDataModel(String key) {
        String ioName = this.dataModel.get(key, (String)null);
        return this.findIO(ioName);
    }

    private IO findIO(String ioName) {
        Collection foundIOs = this.installationAPI.getIOModel().getIOs(io -> io.getDefaultName().equals(ioName));
        return foundIOs.isEmpty() ? null : (IO)foundIOs.iterator().next();
    }

    private String[] getProgramSelectionFromDataModel() {
        String io1 = this.dataModel.get(KEY_PROGRAM_OUTPUT_1, (String)null);
        String io2 = this.dataModel.get(KEY_PROGRAM_OUTPUT_2, (String)null);
        String io3 = this.dataModel.get(KEY_PROGRAM_OUTPUT_3, (String)null);
        String io4 = this.dataModel.get(KEY_PROGRAM_OUTPUT_4, (String)null);
        return new String[]{io1, io2, io3, io4};
    }

    private void setStringInDataModel(String key, String value) {
        this.dataModel.set(key, value);
        this.datamodelUpdated = true;
    }

    private void removeValueFromDataModel(String key) {
        this.dataModel.remove(key);
        this.datamodelUpdated = true;
    }

    private void setTCPInDataModel(TCP tcp) {
        if (tcp != null) {
            this.dataModel.set(KEY_TCP, tcp);
        } else {
            this.removeValueFromDataModel(KEY_TCP);
        }
        this.datamodelUpdated = true;
    }

    private void setDoubleInDataModel(double delay) {
        this.dataModel.set(KEY_DELAY, delay);
        this.datamodelUpdated = true;
    }

    public InstallationMenuCategory.InstallationMenu getInstallationMenu() {
        return InstallationMenuCategory.InstallationMenu.GENERAL;
    }
}

