/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.installation;

import com.ur.polyscope.screwdriving.installation.NativeScrewdrivingConfiguration;
import com.ur.polyscope.screwdriving.installation.ScrewdrivingInstallationNodeContribution;
import com.ur.polyscope.screwdriving.internal.ImageResource;
import com.ur.polyscope.screwdriving.internal.TextResource;
import com.ur.polyscope.screwdriving.model.IOFilter;
import com.ur.polyscope.screwdriving.model.IOFilterRenderer;
import com.ur.polyscope.screwdriving.model.IORenderingStrategy;
import com.ur.polyscope.screwdriving.model.SDRenderingStrategy;
import com.ur.polyscope.screwdriving.model.TCPRenderingStrategy;
import com.ur.polyscope.screwdriving.simpsons.installation.ProxyScrewdriverInstallationNodeService;
import com.ur.polyscope.screwdriving.simpsons.installation.SelectableScrewdriver;
import com.ur.polyscope.urcaps.URCapErrorHandler;
import com.ur.polyscope.urcaps.URCapErrorPanel;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.EnumComboBoxModel;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.units.Units;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import com.ur.urcap.api.domain.SystemAPI;
import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.api.domain.system.localization.Localization;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.tcp.TCP;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class ScrewdrivingInstallationNodeView
implements SwingInstallationNodeView<ScrewdrivingInstallationNodeContribution> {
    private static final String SELECT_TCP = ScrewdrivingInstallationNodeView.class.getSimpleName() + ".selectTCP";
    private static final String SELECT_IO_FILTER = ScrewdrivingInstallationNodeView.class.getSimpleName() + ".selectIOFilter";
    private static final String SELECT_OK = ScrewdrivingInstallationNodeView.class.getSimpleName() + ".selectOK";
    private static final String SELECT_NOK = ScrewdrivingInstallationNodeView.class.getSimpleName() + ".selectNOK";
    private static final String SELECT_READY = ScrewdrivingInstallationNodeView.class.getSimpleName() + ".selectReady";
    private static final String SELECT_PROGRAM_1 = ScrewdrivingInstallationNodeView.class.getSimpleName() + ".selectProgram1";
    private static final String SELECT_PROGRAM_2 = ScrewdrivingInstallationNodeView.class.getSimpleName() + ".selectProgram2";
    private static final String SELECT_PROGRAM_3 = ScrewdrivingInstallationNodeView.class.getSimpleName() + ".selectProgram3";
    private static final String SELECT_PROGRAM_4 = ScrewdrivingInstallationNodeView.class.getSimpleName() + ".selectProgram4";
    private static final String SELECT_START = ScrewdrivingInstallationNodeView.class.getSimpleName() + ".selectStart";
    private static final String SELECT_SIMPSONS_DRIVER = ScrewdrivingInstallationNodeView.class.getSimpleName() + ".selectDriver";
    private static final Color BETWEEN_CARD_COLOR = new Color(230, 230, 230);
    private static final String NATIVE_SELECTION = "NATIVE_SELECTION";
    private static final String MISSING_SELECTION = "MISSING_SELECTION";
    private static URCapErrorHandler urCapErrorHandler;
    private MissingPanel missingDriverPanel;
    private JComboBox<TCP> tcpDropDown;
    private TCPRenderingStrategy tcpRenderingStrategy;
    private JLabel tcpXValue;
    private JLabel tcpYValue;
    private JLabel tcpZValue;
    private final TextResource textResource;
    private final SystemAPI systemAPI;
    private JPanel tcpInfoPanel;
    private IOSelectionPanel okSelectionPanel;
    private IOSelectionPanel notOkSelectionPanel;
    private IOSelectionPanel readySelectionPanel;
    private IOSelectionPanel programSelection1Panel;
    private IOSelectionPanel programSelection2Panel;
    private IOSelectionPanel programSelection3Panel;
    private IOSelectionPanel programSelection4Panel;
    private IOSelectionPanel startSelectionPanel;
    private final Length.Unit tcpAxisUnit;
    private JTextField delayTextField;
    private JPanel wrapper;
    private boolean isCompositeInstallation = false;
    private JComboBox<SelectableScrewdriver> SDDropDown;
    private SDRenderingStrategy SDRenderingStrategy;
    private boolean servicesInitialized;
    private Locale locale;
    private Runnable enableScrewderiverSelection;
    private int contentWidth = 1050;

    ScrewdrivingInstallationNodeView(Locale locale, TextResource textResource, SystemAPI systemAPI) {
        this.textResource = textResource;
        this.systemAPI = systemAPI;
        Localization localization = systemAPI.getSystemSettings().getLocalization();
        UnitType unitType = localization.getUnitType();
        this.tcpAxisUnit = unitType == UnitType.METRIC ? Length.Unit.MM : Length.Unit.IN;
        this.locale = locale;
    }

    @Inject
    public static void setUrCapErrorHandler(URCapErrorHandler urCapErrorHandler) {
        ScrewdrivingInstallationNodeView.urCapErrorHandler = urCapErrorHandler;
    }

    public void buildUI(JPanel mainPanel, ScrewdrivingInstallationNodeContribution installationContribution) {
        mainPanel.setLayout(new BorderLayout());
        this.wrapper = new JPanel(new CardLayout());
        ScrewdrivingInstallationNodeView.setSize(this.wrapper, this.contentWidth + 28, 525);
        this.wrapper.add((Component)this.createNativeSelectionPanel(installationContribution), NATIVE_SELECTION);
        this.missingDriverPanel = new MissingPanel();
        this.missingDriverPanel.setup();
        this.wrapper.add((Component)this.missingDriverPanel, MISSING_SELECTION);
        mainPanel.add((Component)this.wrapper, "West");
        this.enableScrewderiverSelection = () -> {
            mainPanel.add((Component)this.createScrewdriverSelectionPanel(installationContribution), "North");
            ((CardLayout)this.wrapper.getLayout()).show(this.wrapper, NATIVE_SELECTION);
            this.isCompositeInstallation = true;
        };
    }

    private JPanel createNativeSelectionPanel(ScrewdrivingInstallationNodeContribution installationContribution) {
        JPanel nativeView = new JPanel();
        nativeView.setLayout(new BoxLayout(nativeView, 1));
        JPanel topPanel = this.createTopPanel(installationContribution);
        JPanel bottomPanel = this.createBottomPanel(installationContribution, this.contentWidth);
        nativeView.add(topPanel);
        JPanel separator = new JPanel();
        ScrewdrivingInstallationNodeView.setSize(separator, this.contentWidth, 5);
        separator.setBackground(BETWEEN_CARD_COLOR);
        nativeView.add(separator);
        nativeView.add(bottomPanel);
        return nativeView;
    }

    private JPanel createScrewdriverSelectionPanel(ScrewdrivingInstallationNodeContribution installationContribution) {
        this.createScrewDriverDropDown(installationContribution);
        JPanel ddPanel = new JPanel();
        ddPanel.setLayout(new BoxLayout(ddPanel, 1));
        ScrewdrivingInstallationNodeView.setSize(ddPanel, this.contentWidth, 47);
        JPanel dropDownPanel = new JPanel();
        dropDownPanel.setLayout(new BoxLayout(dropDownPanel, 0));
        JLabel dropDownLabel = new JLabel(this.textResource.selectScrewdriver());
        dropDownPanel.add(dropDownLabel);
        dropDownPanel.add(Box.createHorizontalStrut(10));
        dropDownPanel.add(this.SDDropDown);
        dropDownPanel.add(Box.createHorizontalGlue());
        ddPanel.add(dropDownPanel);
        JPanel topSeparator = new JPanel();
        ScrewdrivingInstallationNodeView.setSize(topSeparator, this.contentWidth, 5);
        topSeparator.setBackground(BETWEEN_CARD_COLOR);
        ddPanel.add(Box.createVerticalGlue());
        ddPanel.add(topSeparator);
        return ddPanel;
    }

    private void createScrewDriverDropDown(ScrewdrivingInstallationNodeContribution installationContribution) {
        this.SDDropDown = new JComboBox();
        this.SDDropDown.setName(SELECT_SIMPSONS_DRIVER);
        ScrewdrivingInstallationNodeView.setSize(this.SDDropDown, 300, 32);
        this.SDDropDown.addActionListener(actionEvent -> {
            SelectableScrewdriver selectedItem = (SelectableScrewdriver)this.SDDropDown.getSelectedItem();
            installationContribution.setSD(selectedItem);
        });
    }

    private JPanel createTopPanel(ScrewdrivingInstallationNodeContribution installationContribution) {
        int leftPanelWidth = 650;
        int topPanelHeight = 200;
        JLabel headline = new JLabel(HTML.html((String)HTML.h2((String)this.textResource.screwdrivingSetup())));
        ScrewdrivingInstallationNodeView.setSize(headline, leftPanelWidth, 40);
        headline.setAlignmentX(0.0f);
        JLabel descriptionLabel = new JLabel(HTML.html((String)this.textResource.tcpConfigurationDescription()));
        ScrewdrivingInstallationNodeView.setSize(descriptionLabel, leftPanelWidth, 60);
        descriptionLabel.setAlignmentX(0.0f);
        descriptionLabel.setVerticalAlignment(1);
        descriptionLabel.setHorizontalAlignment(2);
        JPanel descPanel = new JPanel();
        ScrewdrivingInstallationNodeView.setSize(descPanel, leftPanelWidth, 110);
        descPanel.setAlignmentX(0.0f);
        descPanel.setLayout(new BoxLayout(descPanel, 1));
        descPanel.add(headline);
        descPanel.add(descriptionLabel);
        this.tcpDropDown = new JComboBox();
        this.tcpDropDown.setName(SELECT_TCP);
        ScrewdrivingInstallationNodeView.setSize(this.tcpDropDown, 200, 32);
        this.tcpDropDown.addActionListener(actionEvent -> {
            TCP selectedItem = (TCP)this.tcpDropDown.getSelectedItem();
            installationContribution.setTCP(selectedItem);
        });
        this.tcpDropDown.setAlignmentY(0.0f);
        JPanel tcpPanel = ScrewdrivingInstallationNodeView.horizontalBoxPanel();
        tcpPanel.add(this.tcpDropDown);
        tcpPanel.add(Box.createHorizontalStrut(20));
        this.tcpInfoPanel = this.createTCPInfoPanel();
        tcpPanel.add(this.tcpInfoPanel);
        tcpPanel.add(Box.createHorizontalGlue());
        tcpPanel.setAlignmentX(0.0f);
        JPanel topLeftPanel = ScrewdrivingInstallationNodeView.verticalBoxPanel();
        ScrewdrivingInstallationNodeView.setSize(topLeftPanel, leftPanelWidth, topPanelHeight);
        topLeftPanel.add(descPanel);
        topLeftPanel.add(tcpPanel);
        topLeftPanel.add(Box.createVerticalGlue());
        JPanel topRightPanel = new JPanel();
        ScrewdrivingInstallationNodeView.setSize(topRightPanel, 400, topPanelHeight);
        JLabel topIllustration = new JLabel(ImageResource.tcpSmall());
        topRightPanel.add(topIllustration);
        JPanel topPanel = ScrewdrivingInstallationNodeView.horizontalBoxPanel();
        ScrewdrivingInstallationNodeView.setSize(topPanel, this.contentWidth, topPanelHeight);
        topPanel.add(topLeftPanel);
        JPanel topSeparator = new JPanel();
        ScrewdrivingInstallationNodeView.setSize(topSeparator, 5, topPanelHeight);
        topSeparator.setBackground(BETWEEN_CARD_COLOR);
        topPanel.add(topSeparator);
        topPanel.add(Box.createHorizontalGlue());
        topPanel.add(topRightPanel);
        return topPanel;
    }

    private JPanel createBottomPanel(ScrewdrivingInstallationNodeContribution installationContribution, int contentWidth) {
        JPanel bottomPanel = new JPanel();
        ScrewdrivingInstallationNodeView.setSize(bottomPanel, contentWidth, 370);
        bottomPanel.setLayout(new GridLayout(1, 4));
        JPanel filterColumn = ScrewdrivingInstallationNodeView.verticalBoxPanel();
        filterColumn.add(ScrewdrivingInstallationNodeView.createHeaderLabel(this.textResource.ioSignals()));
        SelectionPanel interfaceSelectionPanel = new SelectionPanel(this.textResource.interf(), SELECT_IO_FILTER);
        EnumComboBoxModel model = new EnumComboBoxModel(IOFilter.class, true);
        interfaceSelectionPanel.comboBox.setModel(model);
        ComboBoxRenderer.bindRenderer(interfaceSelectionPanel.comboBox, (RenderingStrategy)new IOFilterRenderer(this.textResource));
        interfaceSelectionPanel.comboBox.addActionListener(e -> installationContribution.setSelectedIOType((IOFilter)((Object)((Object)interfaceSelectionPanel.comboBox.getSelectedItem()))));
        filterColumn.add(interfaceSelectionPanel);
        JPanel inputColumn = ScrewdrivingInstallationNodeView.verticalBoxPanel();
        inputColumn.add(ScrewdrivingInstallationNodeView.createHeaderLabel(this.textResource.input()));
        this.okSelectionPanel = this.createIOSelectionPanel(this.textResource.ok(), SELECT_OK);
        this.okSelectionPanel.addActionListener(e -> {
            IO selectedIO = (IO)this.okSelectionPanel.getSelectedItem();
            installationContribution.setOKInput(selectedIO);
        });
        this.notOkSelectionPanel = this.createIOSelectionPanel(this.textResource.notOk(), SELECT_NOK);
        this.notOkSelectionPanel.addActionListener(e -> {
            IO selectedIO = (IO)this.notOkSelectionPanel.getSelectedItem();
            installationContribution.setNOKInput(selectedIO);
        });
        this.readySelectionPanel = this.createIOSelectionPanel(this.textResource.ready(), SELECT_READY);
        this.readySelectionPanel.addActionListener(e -> {
            IO selectedIO = (IO)this.readySelectionPanel.getSelectedItem();
            installationContribution.setReadyInput(selectedIO);
        });
        inputColumn.add(this.okSelectionPanel);
        inputColumn.add(this.notOkSelectionPanel);
        inputColumn.add(this.readySelectionPanel);
        JPanel programColumn = ScrewdrivingInstallationNodeView.verticalBoxPanel();
        programColumn.add(ScrewdrivingInstallationNodeView.createHeaderLabel(this.textResource.output()));
        this.programSelection1Panel = this.createIOSelectionPanel(this.textResource.programSelection(1), SELECT_PROGRAM_1);
        ScrewdrivingInstallationNodeView.addProgramSelectionActionListener(installationContribution, this.programSelection1Panel, 1);
        this.programSelection2Panel = this.createIOSelectionPanel(this.textResource.programSelection(2), SELECT_PROGRAM_2);
        ScrewdrivingInstallationNodeView.addProgramSelectionActionListener(installationContribution, this.programSelection2Panel, 2);
        this.programSelection3Panel = this.createIOSelectionPanel(this.textResource.programSelection(3), SELECT_PROGRAM_3);
        ScrewdrivingInstallationNodeView.addProgramSelectionActionListener(installationContribution, this.programSelection3Panel, 3);
        this.programSelection4Panel = this.createIOSelectionPanel(this.textResource.programSelection(4), SELECT_PROGRAM_4);
        ScrewdrivingInstallationNodeView.addProgramSelectionActionListener(installationContribution, this.programSelection4Panel, 4);
        programColumn.add(this.programSelection1Panel);
        programColumn.add(this.programSelection2Panel);
        programColumn.add(this.programSelection3Panel);
        programColumn.add(this.programSelection4Panel);
        JPanel column4 = ScrewdrivingInstallationNodeView.verticalBoxPanel();
        column4.add(ScrewdrivingInstallationNodeView.createHeaderLabel(""));
        this.startSelectionPanel = this.createIOSelectionPanel(this.textResource.start(), SELECT_START);
        this.startSelectionPanel.addActionListener(e -> {
            IO selectedIO = (IO)this.startSelectionPanel.getSelectedItem();
            installationContribution.setStartOutput(selectedIO);
        });
        column4.add(this.startSelectionPanel);
        JPanel delayPanel = this.createDelayPanel(installationContribution);
        column4.add(delayPanel);
        bottomPanel.add(filterColumn);
        bottomPanel.add(inputColumn);
        bottomPanel.add(programColumn);
        bottomPanel.add(column4);
        return bottomPanel;
    }

    private JPanel createDelayPanel(final ScrewdrivingInstallationNodeContribution installationContribution) {
        JPanel delayPanel = new JPanel();
        delayPanel.setLayout(new BoxLayout(delayPanel, 1));
        ScrewdrivingInstallationNodeView.setSize(delayPanel, 250, 80);
        delayPanel.setBorder(new EmptyBorder(0, 0, 5, 5));
        JLabel delayLabel = new JLabel(HTML.html((String)HTML.p((String)this.textResource.programSelectionDelay())));
        ScrewdrivingInstallationNodeView.setSize(delayLabel, 200, 35);
        delayLabel.setAlignmentX(0.0f);
        this.delayTextField = new JTextField();
        ScrewdrivingInstallationNodeView.setSize(this.delayTextField, 180, 30);
        this.delayTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                KeyboardNumberInput<Double> keyboard = installationContribution.getDelayKeyboard();
                keyboard.show(ScrewdrivingInstallationNodeView.this.delayTextField, installationContribution.getDelayCallback());
            }
        });
        JLabel delayUnitLabel = new JLabel(Units.getText().unitS());
        delayUnitLabel.setBorder(new EmptyBorder(0, 5, 0, 0));
        JPanel delayTextPanel = new JPanel();
        delayTextPanel.setLayout(new BoxLayout(delayTextPanel, 0));
        delayTextPanel.add(this.delayTextField);
        delayTextPanel.add(delayUnitLabel);
        ScrewdrivingInstallationNodeView.setSize(delayTextPanel, 200, 30);
        delayTextPanel.setAlignmentX(0.0f);
        delayPanel.add(delayLabel);
        delayPanel.add(delayTextPanel);
        return delayPanel;
    }

    private static void addProgramSelectionActionListener(ScrewdrivingInstallationNodeContribution installationContribution, IOSelectionPanel selectionPanel, int index) {
        selectionPanel.addActionListener(e -> {
            IO selectedIO = (IO)selectionPanel.getSelectedItem();
            installationContribution.setProgramOutput(selectedIO, index);
        });
    }

    void updateView(NativeScrewdrivingConfiguration configuration, ViewData viewData) {
        if (!this.servicesInitialized) {
            if (!viewData.selectableScrewdrivers.isEmpty() || viewData.selectedScrewdriver != null) {
                for (SelectableScrewdriver service : viewData.selectableScrewdrivers) {
                    this.addSimpsonsView(service);
                }
                this.enableScrewderiverSelection.run();
            }
            this.servicesInitialized = true;
        }
        if (this.isCompositeInstallation) {
            this.updateSDPanel(configuration, viewData.selectedScrewdriver, viewData.selectableScrewdrivers);
        }
        this.updateTCPPanel(viewData.tcps, configuration);
        this.updateSelectionPanels(viewData.allInputs, viewData.programSelectionOutputs, viewData.startOutputs, configuration);
    }

    private void addSimpsonsView(SelectableScrewdriver service) {
        if (service.isConfiguredCorrectly()) {
            this.wrapper.add((Component)service.getView().getPanel(), service.getProxiedId());
        } else {
            ProxyScrewdriverInstallationNodeService nodeService = (ProxyScrewdriverInstallationNodeService)service;
            if (nodeService.getExceptionThrownDuringCreate() != null) {
                urCapErrorHandler.handle((Throwable)nodeService.getExceptionThrownDuringCreate());
            }
            URCapErrorPanel errorPanel = urCapErrorHandler.getErrorPanel();
            errorPanel.setMetadataFromClass(nodeService.getProxiedService());
            errorPanel.setBackground(Color.WHITE);
            this.wrapper.add((Component)errorPanel, service.getProxiedId());
        }
    }

    private void updateSDPanel(NativeScrewdrivingConfiguration configuration, SelectableScrewdriver screwDriver, List<SelectableScrewdriver> services) {
        DefaultComboBoxModel comboBoxModel = new DefaultComboBoxModel();
        comboBoxModel.addElement(null);
        services.forEach(comboBoxModel::addElement);
        comboBoxModel.setSelectedItem(configuration.getSD());
        this.SDDropDown.setModel(comboBoxModel);
        if (this.SDRenderingStrategy == null) {
            this.SDRenderingStrategy = new SDRenderingStrategy(this.locale, this.textResource);
            ComboBoxRenderer.bindRenderer(this.SDDropDown, (RenderingStrategy)this.SDRenderingStrategy);
        }
        this.SDRenderingStrategy.updateModel(services);
        if (screwDriver != null) {
            if (services.contains(screwDriver)) {
                ((CardLayout)this.wrapper.getLayout()).show(this.wrapper, screwDriver.getProxiedId());
            } else {
                this.missingDriverPanel.setMissingScrewdriver(screwDriver);
                ((CardLayout)this.wrapper.getLayout()).show(this.wrapper, MISSING_SELECTION);
            }
        } else {
            ((CardLayout)this.wrapper.getLayout()).show(this.wrapper, NATIVE_SELECTION);
        }
    }

    private void updateTCPPanel(Collection<TCP> tcps, NativeScrewdrivingConfiguration configuration) {
        DefaultComboBoxModel comboBoxModel = new DefaultComboBoxModel();
        comboBoxModel.addElement(null);
        tcps.forEach(comboBoxModel::addElement);
        comboBoxModel.setSelectedItem(configuration.getTcp());
        this.tcpDropDown.setModel(comboBoxModel);
        if (this.tcpRenderingStrategy == null) {
            this.tcpRenderingStrategy = new TCPRenderingStrategy(this.textResource);
            ComboBoxRenderer.bindRenderer(this.tcpDropDown, (RenderingStrategy)this.tcpRenderingStrategy);
        }
        if (configuration.getTcp() == null) {
            this.tcpInfoPanel.setVisible(false);
        } else {
            this.tcpInfoPanel.setVisible(true);
            Position tcpPosition = configuration.getTcp().getOffset().getPosition();
            Localization localization = this.systemAPI.getSystemSettings().getLocalization();
            this.tcpXValue.setText(String.format(localization.getLocale(), "%.2f", tcpPosition.getX(this.tcpAxisUnit)));
            this.tcpYValue.setText(String.format(localization.getLocale(), "%.2f", tcpPosition.getY(this.tcpAxisUnit)));
            this.tcpZValue.setText(String.format(localization.getLocale(), "%.2f", tcpPosition.getZ(this.tcpAxisUnit)));
        }
    }

    private void updateSelectionPanels(Collection<IO> inputs, Collection<IO> programSelectionOutputs, Collection<IO> startOutputs, NativeScrewdrivingConfiguration configuration) {
        Collection<IO> usedIOs = ScrewdrivingInstallationNodeView.getAllUsedIOs(configuration);
        Collection<IO> possibleInputs = ScrewdrivingInstallationNodeView.removeUsedIOs(inputs, usedIOs);
        Collection<IO> possibleProgramOutputs = ScrewdrivingInstallationNodeView.removeUsedIOs(programSelectionOutputs, usedIOs);
        Collection<IO> possibleStartOutputs = ScrewdrivingInstallationNodeView.removeUsedIOs(startOutputs, usedIOs);
        this.okSelectionPanel.updateComponent(ScrewdrivingInstallationNodeView.withSelectedIO(possibleInputs, configuration.getOkInput()), configuration.getOkInput());
        this.notOkSelectionPanel.updateComponent(ScrewdrivingInstallationNodeView.withSelectedIO(possibleInputs, configuration.getNokInput()), configuration.getNokInput());
        this.readySelectionPanel.updateComponent(ScrewdrivingInstallationNodeView.withSelectedIO(possibleInputs, configuration.getReadyInput()), configuration.getReadyInput());
        IO[] programSelections = configuration.getProgramSelectionOutputs();
        this.programSelection1Panel.updateComponent(ScrewdrivingInstallationNodeView.withSelectedIO(possibleProgramOutputs, programSelections[0]), programSelections[0]);
        this.programSelection2Panel.updateComponent(ScrewdrivingInstallationNodeView.withSelectedIO(possibleProgramOutputs, programSelections[1]), programSelections[1]);
        this.programSelection3Panel.updateComponent(ScrewdrivingInstallationNodeView.withSelectedIO(possibleProgramOutputs, programSelections[2]), programSelections[2]);
        this.programSelection4Panel.updateComponent(ScrewdrivingInstallationNodeView.withSelectedIO(possibleProgramOutputs, programSelections[3]), programSelections[3]);
        this.startSelectionPanel.updateComponent(ScrewdrivingInstallationNodeView.withSelectedIO(possibleStartOutputs, configuration.getStartOutput()), configuration.getStartOutput());
        this.delayTextField.setText("" + configuration.getDelayTimeInSeconds());
        this.removeInvalidProgramSelections(configuration);
    }

    private void removeInvalidProgramSelections(NativeScrewdrivingConfiguration configuration) {
        IO[] outputs = configuration.getProgramSelectionOutputs();
        boolean foundIntRegister = false;
        for (int i = 0; i < outputs.length; ++i) {
            IO output = outputs[i];
            if (output == null || output.getType() != IO.IOType.INTEGER) continue;
            foundIntRegister = true;
            switch (i) {
                case 0: {
                    this.programSelection2Panel.comboBox.setEnabled(false);
                    this.programSelection3Panel.comboBox.setEnabled(false);
                    this.programSelection4Panel.comboBox.setEnabled(false);
                    break;
                }
                case 1: {
                    this.programSelection1Panel.comboBox.setEnabled(false);
                    this.programSelection3Panel.comboBox.setEnabled(false);
                    this.programSelection4Panel.comboBox.setEnabled(false);
                    break;
                }
                case 2: {
                    this.programSelection1Panel.comboBox.setEnabled(false);
                    this.programSelection2Panel.comboBox.setEnabled(false);
                    this.programSelection4Panel.comboBox.setEnabled(false);
                    break;
                }
                case 3: {
                    this.programSelection1Panel.comboBox.setEnabled(false);
                    this.programSelection2Panel.comboBox.setEnabled(false);
                    this.programSelection3Panel.comboBox.setEnabled(false);
                    break;
                }
            }
            break;
        }
        if (!foundIntRegister) {
            this.programSelection1Panel.comboBox.setEnabled(true);
            this.programSelection2Panel.comboBox.setEnabled(true);
            this.programSelection3Panel.comboBox.setEnabled(true);
            this.programSelection4Panel.comboBox.setEnabled(true);
        }
    }

    private static Collection<IO> withSelectedIO(Collection<IO> possibleIOs, IO selectedIO) {
        ArrayList<IO> result = new ArrayList<IO>(possibleIOs);
        if (selectedIO != null && !result.contains(selectedIO)) {
            result.add(0, selectedIO);
        }
        return result;
    }

    private static Collection<IO> removeUsedIOs(Collection<IO> ios, Collection<IO> usedIOs) {
        ArrayList<IO> result = new ArrayList<IO>(ios);
        result.removeAll(usedIOs);
        return result;
    }

    private static Collection<IO> getAllUsedIOs(NativeScrewdrivingConfiguration configuration) {
        ArrayList<IO> usedIOs = new ArrayList<IO>();
        usedIOs.add(configuration.getOkInput());
        usedIOs.add(configuration.getNokInput());
        usedIOs.add(configuration.getReadyInput());
        usedIOs.addAll(Arrays.asList(configuration.getProgramSelectionOutputs()));
        usedIOs.add(configuration.getStartOutput());
        return usedIOs.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static JLabel createHeaderLabel(String s) {
        JLabel label = new JLabel(HTML.html((String)HTML.fontBold((String)s)));
        ScrewdrivingInstallationNodeView.setSize(label, 200, 40);
        return label;
    }

    private IOSelectionPanel createIOSelectionPanel(String labelText, String comboBoxName) {
        return new IOSelectionPanel(labelText, comboBoxName);
    }

    private JPanel createTCPInfoPanel() {
        JPanel result = ScrewdrivingInstallationNodeView.verticalBoxPanel();
        ScrewdrivingInstallationNodeView.setSize(result, 200, 100);
        result.setAlignmentY(0.0f);
        result.setBorder(new EmptyBorder(0, 45, 0, 0));
        this.tcpXValue = ScrewdrivingInstallationNodeView.createTCPAxisValue();
        this.tcpYValue = ScrewdrivingInstallationNodeView.createTCPAxisValue();
        this.tcpZValue = ScrewdrivingInstallationNodeView.createTCPAxisValue();
        JPanel xPanel = ScrewdrivingInstallationNodeView.createTCPAxisPanel("X");
        xPanel.add(this.tcpXValue);
        xPanel.add(ScrewdrivingInstallationNodeView.createTCPAxisLabel());
        JPanel yPanel = ScrewdrivingInstallationNodeView.createTCPAxisPanel("Y");
        yPanel.add(this.tcpYValue);
        yPanel.add(ScrewdrivingInstallationNodeView.createTCPAxisLabel());
        JPanel zPanel = ScrewdrivingInstallationNodeView.createTCPAxisPanel("Z");
        zPanel.add(this.tcpZValue);
        zPanel.add(ScrewdrivingInstallationNodeView.createTCPAxisLabel());
        result.add(xPanel);
        result.add(yPanel);
        result.add(zPanel);
        result.add(Box.createVerticalGlue());
        return result;
    }

    private static JPanel createTCPAxisPanel(String axis) {
        JPanel panel = ScrewdrivingInstallationNodeView.horizontalBoxPanel();
        ScrewdrivingInstallationNodeView.setSize(panel, 200, 28);
        JLabel label = new JLabel(axis + ": ");
        label.setHorizontalAlignment(2);
        ScrewdrivingInstallationNodeView.setSize(label, 30, 28);
        panel.add(label);
        return panel;
    }

    private static JLabel createTCPAxisValue() {
        JLabel result = new JLabel();
        ScrewdrivingInstallationNodeView.setSize(result, 85, 28);
        result.setHorizontalAlignment(4);
        return result;
    }

    private static JLabel createTCPAxisLabel() {
        JLabel result = new JLabel();
        ScrewdrivingInstallationNodeView.setSize(result, 75, 28);
        result.setText(Units.getText().unitMm());
        result.setHorizontalAlignment(2);
        result.setBorder(new EmptyBorder(0, 5, 0, 0));
        return result;
    }

    private static JPanel verticalBoxPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        return p;
    }

    private static JPanel horizontalBoxPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        return p;
    }

    private static void setSize(Component jComponent, int width, int height) {
        Dimension dimension = new Dimension(width, height);
        jComponent.setSize(new Dimension(dimension));
        jComponent.setPreferredSize(dimension);
        jComponent.setMinimumSize(dimension);
        jComponent.setMaximumSize(dimension);
    }

    private class IOSelectionPanel
    extends SelectionPanel<IO> {
        private IORenderingStrategy renderingStrategy;

        IOSelectionPanel(String labelText, String comboBoxName) {
            super(labelText, comboBoxName);
            this.renderingStrategy = new IORenderingStrategy(ScrewdrivingInstallationNodeView.this.textResource);
            this.setup();
        }

        private void setup() {
            ComboBoxRenderer.bindRenderer((JComboBox)this.comboBox, (RenderingStrategy)this.renderingStrategy);
        }

        void updateComponent(Collection<IO> model, IO selectedIO) {
            this.renderingStrategy.updateModel(model);
            DefaultComboBoxModel<IO> comboBoxModel = this.createIOModel(model);
            if (selectedIO != null) {
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    IO element = comboBoxModel.getElementAt(i);
                    if (element == null || !element.getDefaultName().equals(selectedIO.getDefaultName())) continue;
                    comboBoxModel.setSelectedItem(selectedIO);
                    break;
                }
            } else {
                comboBoxModel.setSelectedItem(null);
            }
            this.comboBox.setModel(comboBoxModel);
        }

        void addActionListener(ActionListener actionListener) {
            this.comboBox.addActionListener(actionListener);
        }

        private DefaultComboBoxModel<IO> createIOModel(Collection<IO> inputs) {
            DefaultComboBoxModel<IO> model = new DefaultComboBoxModel<IO>();
            model.addElement(null);
            inputs.forEach(model::addElement);
            return model;
        }
    }

    private static class SelectionPanel<T>
    extends JPanel {
        private JLabel panelLabel;
        JComboBox<T> comboBox;

        SelectionPanel(String labelText, String comboBoxName) {
            this.panelLabel = new JLabel(labelText);
            this.comboBox = new JComboBox();
            this.comboBox.setName(comboBoxName);
            this.setupComponent();
        }

        T getSelectedItem() {
            return (T)this.comboBox.getSelectedItem();
        }

        private void setupComponent() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(new EmptyBorder(5, 0, 5, 5));
            this.setAlignmentX(0.0f);
            this.setComponentSize();
            this.setSubComponentSize(this.panelLabel);
            this.panelLabel.setAlignmentX(0.0f);
            this.add(this.panelLabel);
            this.comboBox.setAlignmentX(0.0f);
            this.setSubComponentSize(this.comboBox);
            this.comboBox.setMaximumRowCount(10);
            this.add(this.comboBox);
        }

        private void setComponentSize() {
            Dimension dimension = new Dimension(250, 80);
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
        }

        void setSubComponentSize(JComponent subComponentSize) {
            Dimension dimension = new Dimension(200, 30);
            subComponentSize.setPreferredSize(dimension);
            subComponentSize.setMinimumSize(dimension);
            subComponentSize.setMaximumSize(dimension);
        }
    }

    static class ViewData {
        Collection<TCP> tcps;
        Collection<IO> allInputs;
        Collection<IO> programSelectionOutputs;
        Collection<IO> startOutputs;
        SelectableScrewdriver selectedScrewdriver;
        List<SelectableScrewdriver> selectableScrewdrivers;

        ViewData() {
        }
    }

    class MissingPanel
    extends JPanel {
        private JLabel label = new JLabel();

        MissingPanel() {
        }

        void setup() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.label);
        }

        public void setMissingScrewdriver(SelectableScrewdriver screwDriver) {
            this.label.setText(ScrewdrivingInstallationNodeView.this.textResource.missingSelectedUrcap() + " " + screwDriver.getTitle(ScrewdrivingInstallationNodeView.this.locale));
        }
    }
}

