/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.internal;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageResource {
    private static boolean isG5 = true;

    private ImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/icons/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="thumbsup.png")
    public static Icon thumbsup() {
        return ImageResource.tryGetImage("thumbsup.png");
    }

    @Key(value="program-until-undefined.png")
    public static Icon programUntilUndefined() {
        return ImageResource.tryGetImage("program-until-undefined.png");
    }

    @Key(value="warning.png")
    public static Icon warning() {
        return ImageResource.tryGetImage("warning.png");
    }

    @Key(value="program-until.png")
    public static Icon programUntil() {
        return ImageResource.tryGetImage("program-until.png");
    }

    @Key(value="plus_icon.png")
    public static Icon plusIcon() {
        return ImageResource.tryGetImage("plus_icon.png");
    }

    @Key(value="delete.png")
    public static Icon delete() {
        return ImageResource.tryGetImage("delete.png");
    }

    @Key(value="tcp_small.png")
    public static Icon tcpSmall() {
        return ImageResource.tryGetImage("tcp_small.png");
    }

    @Key(value="thumbsdown.png")
    public static Icon thumbsdown() {
        return ImageResource.tryGetImage("thumbsdown.png");
    }

    @Key(value="tcp.png")
    public static Icon tcp() {
        return ImageResource.tryGetImage("tcp.png");
    }

    @Key(value="dummy.png")
    public static Icon dummy() {
        return ImageResource.tryGetImage("dummy.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return ImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    static {
        if (isG5) {
            ImageResource.tryGetImage("thumbsup.png");
            ImageResource.tryGetImage("program-until-undefined.png");
            ImageResource.tryGetImage("warning.png");
            ImageResource.tryGetImage("program-until.png");
            ImageResource.tryGetImage("plus_icon.png");
            ImageResource.tryGetImage("delete.png");
            ImageResource.tryGetImage("tcp_small.png");
            ImageResource.tryGetImage("thumbsdown.png");
            ImageResource.tryGetImage("tcp.png");
            ImageResource.tryGetImage("dummy.png");
        }
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = path + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

