/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.internal;

import com.ur.polyscope.screwdriving.handlers.HandlerType;
import com.ur.polyscope.screwdriving.internal.TextResource;
import com.ur.polyscope.screwdriving.swing.driver.ScrewdrivingHandlerDriver;
import com.ur.polyscope.screwdriving.swing.driver.ScrewdrivingNames;
import javax.inject.Inject;

public class ScrewDrivingNamesImpl
implements ScrewdrivingNames {
    private TextResource textResource;

    @Inject
    public ScrewDrivingNamesImpl(TextResource textResource) {
        this.textResource = textResource;
    }

    public String getProgramNodeTitle() {
        return this.textResource.screwdriving();
    }

    public String getUndefinedUntilName() {
        return this.textResource.until() + "        ";
    }

    public String getHandlerDropDownName(ScrewdrivingHandlerDriver.HandlerType handlerType) {
        String result;
        switch (handlerType) {
            case UNTIL_OK: {
                result = HandlerType.HANDLER_UNTIL_OK.toString();
                break;
            }
            case UNTIL_TIME: {
                result = HandlerType.HANDLER_UNTIL_TIME.toString();
                break;
            }
            case UNTIL_DISTANCE: {
                result = HandlerType.HANDLER_UNTIL_DISTANCE.toString();
                break;
            }
            case UNTIL_EXPRESSION: {
                result = HandlerType.HANDLER_UNTIL_EXPRESSION.toString();
                break;
            }
            case ERROR_NOK: {
                result = HandlerType.HANDLER_ERROR_NOT_OK.toString();
                break;
            }
            case ERROR_TIMEOUT: {
                result = HandlerType.HANDLER_ERROR_TIMEOUT.toString();
                break;
            }
            case ERROR_DISTANCE: {
                result = HandlerType.HANDLER_ERROR_DISTANCE.toString();
                break;
            }
            default: {
                throw new IllegalArgumentException(handlerType + " unknown");
            }
        }
        return result;
    }

    public String getHandlerTreeName(ScrewdrivingHandlerDriver.HandlerType handlerType) {
        HandlerType implType;
        switch (handlerType) {
            case UNTIL_OK: {
                implType = HandlerType.HANDLER_UNTIL_OK;
                break;
            }
            case UNTIL_TIME: {
                implType = HandlerType.HANDLER_UNTIL_TIME;
                break;
            }
            case UNTIL_DISTANCE: {
                implType = HandlerType.HANDLER_UNTIL_DISTANCE;
                break;
            }
            case UNTIL_EXPRESSION: {
                implType = HandlerType.HANDLER_UNTIL_EXPRESSION;
                break;
            }
            case ERROR_NOK: {
                implType = HandlerType.HANDLER_ERROR_NOT_OK;
                break;
            }
            case ERROR_TIMEOUT: {
                implType = HandlerType.HANDLER_ERROR_TIMEOUT;
                break;
            }
            case ERROR_DISTANCE: {
                implType = HandlerType.HANDLER_ERROR_DISTANCE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type for " + handlerType);
            }
        }
        String type = this.textResource.handlerType(implType);
        return implType.isSuccessState() ? type : this.textResource.error() + ": " + type;
    }
}

