/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.screwdriving.internal;

import com.ur.polyscope.screwdriving.internal.ProgramNodeContext;
import com.ur.polyscope.screwdriving.program.AllParameters;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ScrewdrivingProgramContext {
    private Map<String, ProgramNodeContext> programNodeContexts;
    private final AtomicInteger ID_GENERATOR = new AtomicInteger(0);

    ScrewdrivingProgramContext() {
        this.programNodeContexts = new HashMap<String, ProgramNodeContext>();
    }

    public void setContextForProgramNode(String programNodeId, AllParameters operationParameters) {
        ProgramNodeContext existingContext = this.programNodeContexts.get(programNodeId);
        if (existingContext == null) {
            this.programNodeContexts.put(programNodeId, new ProgramNodeContext(programNodeId, operationParameters, this.ID_GENERATOR.getAndIncrement()));
        } else {
            existingContext.setOperationParameters(operationParameters);
        }
    }

    public void removeContextForProgramNode(String programNodeId) {
        this.programNodeContexts.remove(programNodeId);
    }

    public ProgramNodeContext getContextForProgramNode(String programNodeId) {
        return this.programNodeContexts.get(programNodeId);
    }

    public Collection<ProgramNodeContext> getAllProgramNodeContexts() {
        return this.programNodeContexts.values();
    }

    public void resetContexts() {
        this.programNodeContexts.clear();
        this.ID_GENERATOR.set(0);
    }
}

